/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.om.snapshot.filter.ReclaimableFilter;
import org.apache.ratis.util.MemoizedCheckedSupplier;
import org.apache.ratis.util.function.CheckedSupplier;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;

public class ReclaimableKeyFilter
extends ReclaimableFilter<OmKeyInfo> {
    private final Map<UUID, Long> exclusiveSizeMap = new HashMap<UUID, Long>();
    private final Map<UUID, Long> exclusiveReplicatedSizeMap = new HashMap<UUID, Long>();

    public ReclaimableKeyFilter(OzoneManager ozoneManager, OmSnapshotManager omSnapshotManager, SnapshotChainManager snapshotChainManager, SnapshotInfo currentSnapshotInfo, KeyManager keyManager, IOzoneManagerLock lock) {
        super(ozoneManager, omSnapshotManager, snapshotChainManager, currentSnapshotInfo, keyManager, lock, 2);
    }

    @Override
    protected String getVolumeName(Table.KeyValue<String, OmKeyInfo> keyValue) throws IOException {
        return ((OmKeyInfo)keyValue.getValue()).getVolumeName();
    }

    @Override
    protected String getBucketName(Table.KeyValue<String, OmKeyInfo> keyValue) throws IOException {
        return ((OmKeyInfo)keyValue.getValue()).getBucketName();
    }

    @Override
    protected Boolean isReclaimable(Table.KeyValue<String, OmKeyInfo> deletedKeyInfo) throws IOException {
        UncheckedAutoCloseableSupplier<OmSnapshot> previousSnapshot = this.getPreviousOmSnapshot(1);
        KeyManager previousKeyManager = Optional.ofNullable(previousSnapshot).map(i -> ((OmSnapshot)i.get()).getKeyManager()).orElse(null);
        MemoizedCheckedSupplier previousKeyInfo = MemoizedCheckedSupplier.valueOf(() -> this.getPreviousSnapshotKeyInfo(this.getVolumeId(), this.getBucketInfo(), (OmKeyInfo)deletedKeyInfo.getValue(), this.getKeyManager(), previousKeyManager));
        if (!((Optional)previousKeyInfo.get()).isPresent()) {
            return true;
        }
        UncheckedAutoCloseableSupplier<OmSnapshot> previousToPreviousSnapshot = this.getPreviousOmSnapshot(0);
        KeyManager previousToPreviousKeyManager = Optional.ofNullable(previousToPreviousSnapshot).map(i -> ((OmSnapshot)i.get()).getKeyManager()).orElse(null);
        MemoizedCheckedSupplier previousPrevKeyInfo = MemoizedCheckedSupplier.valueOf(() -> this.lambda$3((CheckedSupplier)previousKeyInfo, previousKeyManager, previousToPreviousKeyManager));
        SnapshotInfo previousSnapshotInfo = this.getPreviousSnapshotInfo(1);
        this.calculateExclusiveSize(previousSnapshotInfo, (CheckedSupplier<Optional<OmKeyInfo>, IOException>)previousKeyInfo, (CheckedSupplier<Optional<OmKeyInfo>, IOException>)previousPrevKeyInfo, this.exclusiveSizeMap, this.exclusiveReplicatedSizeMap);
        return false;
    }

    public Map<UUID, Long> getExclusiveSizeMap() {
        return this.exclusiveSizeMap;
    }

    public Map<UUID, Long> getExclusiveReplicatedSizeMap() {
        return this.exclusiveReplicatedSizeMap;
    }

    private void calculateExclusiveSize(SnapshotInfo previousSnapshotInfo, CheckedSupplier<Optional<OmKeyInfo>, IOException> keyInfoPrevSnapshot, CheckedSupplier<Optional<OmKeyInfo>, IOException> keyInfoPrevToPrevSnapshot, Map<UUID, Long> exclusiveSizes, Map<UUID, Long> exclusiveReplicatedSizes) throws IOException {
        if (((Optional)keyInfoPrevSnapshot.get()).isPresent() && !((Optional)keyInfoPrevToPrevSnapshot.get()).isPresent()) {
            OmKeyInfo keyInfo = (OmKeyInfo)((Optional)keyInfoPrevSnapshot.get()).get();
            exclusiveSizes.compute(previousSnapshotInfo.getSnapshotId(), (k, v) -> (v == null ? 0L : v) + keyInfo.getDataSize());
            exclusiveReplicatedSizes.compute(previousSnapshotInfo.getSnapshotId(), (k, v) -> (v == null ? 0L : v) + keyInfo.getReplicatedSize());
        }
    }

    private Optional<OmKeyInfo> getPreviousSnapshotKeyInfo(long volumeId, OmBucketInfo bucketInfo, OmKeyInfo keyInfo, KeyManager keyManager, KeyManager previousKeyManager) throws IOException {
        if (keyInfo == null || previousKeyManager == null) {
            return Optional.empty();
        }
        OmKeyInfo prevKeyInfo = (OmKeyInfo)keyManager.getPreviousSnapshotOzoneKeyInfo(volumeId, bucketInfo, keyInfo).apply((Object)previousKeyManager);
        if (prevKeyInfo == null || prevKeyInfo.getObjectID() != keyInfo.getObjectID()) {
            return Optional.empty();
        }
        return SnapshotUtils.isBlockLocationInfoSame(prevKeyInfo, keyInfo) ? Optional.of(prevKeyInfo) : Optional.empty();
    }

    private /* synthetic */ Optional lambda$3(CheckedSupplier checkedSupplier, KeyManager keyManager, KeyManager keyManager2) throws IOException {
        return this.getPreviousSnapshotKeyInfo(this.getVolumeId(), this.getBucketInfo(), ((Optional)checkedSupplier.get()).orElse(null), keyManager, keyManager2);
    }
}

