/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.report;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReportPublisher<T extends Message>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReportPublisher.class);
    private ConfigurationSource config;
    private StateContext context;
    private ScheduledExecutorService executor;

    public void init(StateContext stateContext, ScheduledExecutorService executorService) {
        this.context = stateContext;
        this.executor = executorService;
        this.executor.scheduleAtFixedRate(this, this.getReportFrequency(), this.getReportFrequency(), TimeUnit.MILLISECONDS);
    }

    public void setConf(ConfigurationSource conf) {
        this.config = conf;
    }

    public ConfigurationSource getConf() {
        return this.config;
    }

    @Override
    public void run() {
        if (!this.executor.isShutdown() && this.context.getState() != DatanodeStateMachine.DatanodeStates.SHUTDOWN) {
            this.publishReport();
        }
    }

    private void publishReport() {
        try {
            T report = this.getReport();
            if (report instanceof StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto) {
                this.context.addIncrementalReport((Message)report);
            } else {
                this.context.refreshFullReport((Message)report);
            }
        }
        catch (IOException e) {
            LOG.error("Exception while publishing report.", (Throwable)e);
        }
    }

    protected abstract long getReportFrequency();

    protected abstract T getReport() throws IOException;

    protected StateContext getContext() {
        return this.context;
    }
}

