/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.Set;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MismatchedReplicasHandler
extends AbstractCheck {
    private static final Logger LOG = LoggerFactory.getLogger(MismatchedReplicasHandler.class);
    private final ReplicationManager replicationManager;

    public MismatchedReplicasHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        if (request.isReadOnly()) {
            return false;
        }
        ContainerInfo containerInfo = request.getContainerInfo();
        Set<ContainerReplica> replicas = request.getContainerReplicas();
        if (containerInfo.getState() != HddsProtos.LifeCycleState.CLOSED && containerInfo.getState() != HddsProtos.LifeCycleState.QUASI_CLOSED) {
            return false;
        }
        LOG.debug("Checking container {} in MismatchedReplicasHandler", (Object)containerInfo);
        for (ContainerReplica replica : replicas) {
            StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State replicaState = this.getTransitionState(containerInfo, replica);
            if (replicaState == null) continue;
            LOG.debug("Sending close command for mismatched replica {} of container {}.", (Object)replica, (Object)containerInfo);
            this.replicationManager.sendCloseContainerReplicaCommand(containerInfo, replica.getDatanodeDetails(), StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED.equals((Object)replicaState));
        }
        return false;
    }

    private StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State getTransitionState(ContainerInfo container, ContainerReplica replica) {
        if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN || replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING) {
            return HddsProtos.ReplicationType.RATIS == container.getReplicationType() ? StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED : StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED;
        }
        return container.getState() == HddsProtos.LifeCycleState.CLOSED && replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED && container.getSequenceId() == replica.getSequenceId().longValue() ? StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED : null;
    }
}

