/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.AddSCMRequest;
import org.apache.hadoop.hdds.scm.RemoveSCMRequest;
import org.apache.hadoop.hdds.scm.ha.SCMHAInvocationHandler;
import org.apache.hadoop.hdds.scm.ha.SCMRatisRequest;
import org.apache.hadoop.hdds.scm.ha.SCMRatisResponse;
import org.apache.hadoop.hdds.scm.ha.SCMStateMachine;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.server.RaftServer;

public interface SCMRatisServer {
    public void start() throws IOException;

    public void registerStateMachineHandler(SCMRatisProtocol.RequestType var1, Object var2);

    public SCMRatisResponse submitRequest(SCMRatisRequest var1) throws IOException, ExecutionException, InterruptedException, TimeoutException;

    public boolean triggerSnapshot() throws IOException;

    public void stop() throws IOException;

    public boolean isStopped();

    public RaftServer.Division getDivision();

    public List<String> getRatisRoles();

    public NotLeaderException triggerNotLeaderException();

    public boolean addSCM(AddSCMRequest var1) throws IOException;

    public boolean removeSCM(RemoveSCMRequest var1) throws IOException;

    public SCMStateMachine getSCMStateMachine();

    public GrpcTlsConfig getGrpcTlsConfig();

    public RaftPeerId getLeaderId();

    default public <T> T getProxyHandler(SCMRatisProtocol.RequestType type, Class<T> intf, T impl) {
        SCMHAInvocationHandler invocationHandler = new SCMHAInvocationHandler(type, impl, this);
        return intf.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{intf}, (InvocationHandler)invocationHandler));
    }
}

