/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline.choose.algorithms;

import java.util.List;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.PipelineRequestInformation;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinPipelineChoosePolicy
implements PipelineChoosePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(RoundRobinPipelineChoosePolicy.class);
    private int nextPipelineIndex = 0;

    @Override
    public Pipeline choosePipeline(List<Pipeline> pipelineList, PipelineRequestInformation pri) {
        return pipelineList.get(this.choosePipelineIndex(pipelineList, pri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int choosePipelineIndex(List<Pipeline> pipelineList, PipelineRequestInformation pri) {
        int chosenIndex;
        int numPipelines = pipelineList.size();
        RoundRobinPipelineChoosePolicy roundRobinPipelineChoosePolicy = this;
        synchronized (roundRobinPipelineChoosePolicy) {
            this.nextPipelineIndex %= numPipelines;
            chosenIndex = this.nextPipelineIndex++;
        }
        LOG.debug("chosenIndex = {}, numPipelines = {}", (Object)chosenIndex, (Object)numPipelines);
        return chosenIndex;
    }
}

