/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server.upgrade;

import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;

public enum FinalizationCheckpoint {
    FINALIZATION_REQUIRED(false, true, UpgradeFinalization.Status.FINALIZATION_REQUIRED),
    FINALIZATION_STARTED(true, true, UpgradeFinalization.Status.FINALIZATION_IN_PROGRESS),
    MLV_EQUALS_SLV(true, false, UpgradeFinalization.Status.FINALIZATION_IN_PROGRESS),
    FINALIZATION_COMPLETE(false, false, UpgradeFinalization.Status.FINALIZATION_DONE);

    private final boolean needsFinalizingMark;
    private final boolean needsMlvBehindSlv;
    private final UpgradeFinalization.Status status;

    private FinalizationCheckpoint(boolean needsFinalizingMark, boolean needsMlvBehindSlv, UpgradeFinalization.Status status) {
        this.needsFinalizingMark = needsFinalizingMark;
        this.needsMlvBehindSlv = needsMlvBehindSlv;
        this.status = status;
    }

    public boolean isCurrent(boolean hasFinalizationMark, boolean hasMlvBehindSlv) {
        return hasFinalizationMark == this.needsFinalizingMark && hasMlvBehindSlv == this.needsMlvBehindSlv;
    }

    public boolean needsFinalizingMark() {
        return this.needsFinalizingMark;
    }

    public boolean needsMlvBehindSlv() {
        return this.needsMlvBehindSlv;
    }

    public boolean hasCrossed(FinalizationCheckpoint query) {
        return this.compareTo(query) >= 0;
    }

    public UpgradeFinalization.Status getStatus() {
        return this.status;
    }
}

