/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.protocolPB.GrpcOmTransport;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OzoneClientCache {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientCache.class);
    private final OzoneConfiguration conf;
    private OzoneClient client;

    @Inject
    OzoneClientCache(OzoneConfiguration conf) {
        this.conf = conf;
        LOG.debug("{}: Created", (Object)this);
    }

    @PostConstruct
    public void initialize() throws IOException {
        this.conf.set("ozone.om.group.rights", "NONE");
        this.conf.setIfUnset("ozone.client.required.om.version.min", OzoneConfigKeys.OZONE_CLIENT_REQUIRED_OM_VERSION_MIN_DEFAULT);
        this.conf.setBoolean("ozone.s3.auth.check", true);
        this.client = OzoneClientCache.createClient(this.conf);
        Preconditions.assertTrue((boolean)this.conf.getBoolean("ozone.s3.auth.check", false), (Object)"ozone.s3.auth.check");
        LOG.debug("{}: Initialized", (Object)this);
    }

    public OzoneClient getClient() {
        return this.client;
    }

    public static OzoneClient createClient(OzoneConfiguration ozoneConfiguration) throws IOException {
        String omServiceID = OmUtils.getOzoneManagerServiceId((OzoneConfiguration)ozoneConfiguration);
        SecurityConfig secConfig = new SecurityConfig((ConfigurationSource)ozoneConfiguration);
        try {
            if (secConfig.isGrpcTlsEnabled() && ozoneConfiguration.get("ozone.om.transport.class", "org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory") != "org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory") {
                OzoneClientCache.setCertificate(secConfig, omServiceID, ozoneConfiguration);
            }
            if (omServiceID == null) {
                return OzoneClientFactory.getRpcClient((ConfigurationSource)ozoneConfiguration);
            }
            return OzoneClientFactory.getRpcClient((String)omServiceID, (ConfigurationSource)ozoneConfiguration);
        }
        catch (IOException e) {
            LOG.warn("cannot create OzoneClient", (Throwable)e);
            throw e;
        }
    }

    private static void setCertificate(SecurityConfig secConfig, String omServiceID, OzoneConfiguration conf) throws IOException {
        OzoneConfiguration config = new OzoneConfiguration((Configuration)conf);
        if (secConfig.isGrpcTlsEnabled()) {
            config.set("ozone.om.transport.class", "org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory");
            config.setBoolean("ozone.s3.auth.check", false);
            try (OzoneClient certClient = omServiceID == null ? OzoneClientFactory.getRpcClient((ConfigurationSource)config) : OzoneClientFactory.getRpcClient((String)omServiceID, (ConfigurationSource)config);){
                ServiceInfoEx serviceInfoEx = certClient.getObjectStore().getClientProxy().getOzoneManagerClient().getServiceInfo();
                if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
                    String caCertPem = null;
                    List<String> caCertPems = null;
                    caCertPem = serviceInfoEx.getCaCertificate();
                    caCertPems = serviceInfoEx.getCaCertPemList();
                    if (caCertPems == null || caCertPems.isEmpty()) {
                        if (caCertPem == null) {
                            LOG.error("S3g received empty caCertPems from serviceInfo");
                            throw new CertificateException("No caCerts found; caCertPem can not be null when caCertPems is empty or null");
                        }
                        caCertPems = Collections.singletonList(caCertPem);
                    }
                    GrpcOmTransport.setCaCerts((List)OzoneSecurityUtil.convertToX509((List)caCertPems));
                }
            }
        }
    }

    @PreDestroy
    public void cleanup() {
        LOG.debug("{}: Closing cached client", (Object)this);
        IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.client});
    }
}

