/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientCreator;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.client.ClientTrustManager;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.x509.certificate.client.CACertificateProvider;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.Freon;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.util.PayloadUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dn-echo", aliases={"dne"}, description={"Generate echo RPC request to DataNode"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class DNRPCLoadGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DNRPCLoadGenerator.class);
    private static final int RPC_PAYLOAD_MULTIPLICATION_FACTOR = 1024;
    private static final int MAX_SIZE_KB = 0x1FFFFF;
    private Timer timer;
    private OzoneConfiguration configuration;
    private ByteString payloadReqBytes;
    private int payloadRespSize;
    private List<XceiverClientSpi> clients;
    private String encodedContainerToken;
    @CommandLine.Option(names={"--payload-req"}, description={"Specifies the size of payload in KB in RPC request. "}, defaultValue="0")
    private int payloadReqSizeKB = 0;
    @CommandLine.Option(names={"--payload-resp"}, description={"Specifies the size of payload in KB in RPC response. "}, defaultValue="0")
    private int payloadRespSizeKB = 0;
    @CommandLine.Option(names={"--container-id"}, description={"Send echo to DataNodes associated with this container"})
    private long containerID;
    @CommandLine.Option(names={"--sleep-time-ms"}, description={"Let DataNode to pause for a duration (in milliseconds) for each request"}, defaultValue="0")
    private int sleepTimeMs = 0;
    @CommandLine.Option(names={"--clients"}, description={"number of xceiver clients"}, defaultValue="1")
    private int numClients = 1;
    @CommandLine.Option(names={"--read-only"}, description={"if Ratis, read only or not"}, defaultValue="false")
    private boolean readOnly = false;
    @CommandLine.Option(names={"--ratis"}, description={"if Ratis or grpc"}, defaultValue="false")
    private boolean ratis = false;
    @CommandLine.ParentCommand
    private Freon freon;

    public DNRPCLoadGenerator() {
    }

    @VisibleForTesting
    DNRPCLoadGenerator(OzoneConfiguration ozoneConfiguration) {
        this.configuration = ozoneConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        XceiverClientCreator xceiverClientManager;
        OzoneManagerProtocolClientSideTranslatorPB omClient;
        Preconditions.checkArgument((this.payloadReqSizeKB >= 0 ? 1 : 0) != 0, (Object)"OM echo request payload size should be positive value or zero.");
        Preconditions.checkArgument((this.payloadRespSizeKB >= 0 ? 1 : 0) != 0, (Object)"OM echo response payload size should be positive value or zero.");
        if (this.configuration == null) {
            this.configuration = this.freon.getOzoneConf();
        }
        ContainerOperationClient scmClient = new ContainerOperationClient(this.configuration);
        ContainerInfo containerInfo = scmClient.getContainer(this.containerID);
        List pipelineList = scmClient.listPipelines();
        Pipeline pipeline = pipelineList.stream().filter(p -> p.getId().equals((Object)containerInfo.getPipelineID())).findFirst().orElse(null);
        if (!this.ratis) {
            if (!this.readOnly) {
                LOG.warn("Read only is not set to true for GRPC, setting it to true");
                this.readOnly = true;
            }
            pipeline = pipeline.copyForRead();
        }
        this.encodedContainerToken = scmClient.getEncodedContainerToken(this.containerID);
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.configuration)) {
            omClient = this.createOmClient(this.configuration, null);
            CACertificateProvider caCerts = () -> omClient.getServiceInfo().provideCACerts();
            xceiverClientManager = new XceiverClientCreator((ConfigurationSource)this.configuration, new ClientTrustManager(caCerts, null));
        } else {
            omClient = null;
            xceiverClientManager = new XceiverClientCreator((ConfigurationSource)this.configuration);
        }
        this.clients = new ArrayList<XceiverClientSpi>(this.numClients);
        for (int i = 0; i < this.numClients; ++i) {
            this.clients.add(xceiverClientManager.acquireClient(pipeline));
        }
        this.init();
        this.payloadReqBytes = PayloadUtils.generatePayloadProto3((int)this.payloadSizeInBytes(this.payloadReqSizeKB));
        this.payloadRespSize = this.calculateMaxPayloadSize(this.payloadRespSizeKB);
        this.timer = this.getMetrics().timer("rpc-payload");
        try {
            this.runTests(this::sendRPCReq);
        }
        finally {
            if (omClient != null) {
                omClient.close();
            }
            for (XceiverClientSpi client : this.clients) {
                xceiverClientManager.releaseClient(client, false);
            }
            xceiverClientManager.close();
            scmClient.close();
        }
        return null;
    }

    private int calculateMaxPayloadSize(int payloadSizeKB) {
        if (payloadSizeKB > 0) {
            return Math.min(Math.toIntExact((long)payloadSizeKB * 1024L), 0x1FFFFF);
        }
        return 0;
    }

    private int payloadSizeInBytes(int payloadSizeKB) {
        return payloadSizeKB > 0 ? payloadSizeKB * 1024 : 0;
    }

    private void sendRPCReq(long l) throws Exception {
        this.timer.time(() -> {
            int clientIndex = this.numClients == 1 ? 0 : (int)l % this.numClients;
            ContainerProtos.EchoResponseProto response = ContainerProtocolCalls.echo((XceiverClientSpi)this.clients.get(clientIndex), (String)this.encodedContainerToken, (long)this.containerID, (ByteString)this.payloadReqBytes, (int)this.payloadRespSize, (int)this.sleepTimeMs, (boolean)this.readOnly);
            return null;
        });
    }
}

