/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.client;

import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyPair;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.client.DefaultCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.security.x509.exception.CertificateException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNCertificateClient
extends DefaultCertificateClient {
    private static final Logger LOG = LoggerFactory.getLogger(DNCertificateClient.class);
    public static final String COMPONENT_NAME = "dn";
    private final DatanodeDetails dn;

    public DNCertificateClient(SecurityConfig securityConfig, SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient, DatanodeDetails datanodeDetails, String certSerialId, Consumer<String> saveCertId, Runnable shutdown) {
        super(securityConfig, scmSecurityClient, LOG, certSerialId, COMPONENT_NAME, datanodeDetails.threadNamePrefix(), saveCertId, shutdown);
        this.dn = datanodeDetails;
    }

    @Override
    public CertificateSignRequest.Builder configureCSRBuilder() throws SCMSecurityException {
        CertificateSignRequest.Builder builder = super.configureCSRBuilder();
        try {
            String hostname = InetAddress.getLocalHost().getCanonicalHostName();
            String subject = UserGroupInformation.getCurrentUser().getShortUserName() + "@" + hostname;
            builder.setCA(Boolean.valueOf(false)).setKey(new KeyPair(this.getPublicKey(), this.getPrivateKey())).setConfiguration(this.getSecurityConfig()).setSubject(subject);
            LOG.info("Created csr for DN-> subject:{}", (Object)subject);
            return builder;
        }
        catch (Exception e) {
            LOG.error("Failed to get hostname or current user", (Throwable)e);
            throw new CertificateException("Failed to get hostname or current user", (Throwable)e, CertificateException.ErrorCode.CSR_ERROR);
        }
    }

    @Override
    public SCMSecurityProtocolProtos.SCMGetCertResponseProto sign(CertificateSignRequest csr) throws IOException {
        return this.getScmSecureClient().getDataNodeCertificateChain(this.dn.getProtoBufMessage(), csr.toEncodedFormat());
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }
}

