/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBMetrics;
import org.apache.hadoop.hdds.utils.db.RDBSstFileLoader;
import org.apache.hadoop.hdds.utils.db.RDBSstFileWriter;
import org.apache.hadoop.hdds.utils.db.RDBStoreByteArrayIterator;
import org.apache.hadoop.hdds.utils.db.RDBStoreCodecBufferIterator;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RDBTable
implements Table<byte[], byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(RDBTable.class);
    private final RocksDatabase db;
    private final RocksDatabase.ColumnFamily family;
    private final RDBMetrics rdbMetrics;

    RDBTable(RocksDatabase db, RocksDatabase.ColumnFamily family, RDBMetrics rdbMetrics) {
        this.db = db;
        this.family = family;
        this.rdbMetrics = rdbMetrics;
    }

    public RocksDatabase.ColumnFamily getColumnFamily() {
        return this.family;
    }

    @Override
    void put(ByteBuffer key, ByteBuffer value) throws RocksDatabaseException {
        this.db.put(this.family, key, value);
    }

    @Override
    public void put(byte[] key, byte[] value) throws RocksDatabaseException {
        this.db.put(this.family, key, value);
    }

    @Override
    void putWithBatch(BatchOperation batch, CodecBuffer key, CodecBuffer value) {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("Unexpected batch class: " + batch.getClass().getSimpleName());
        }
        ((RDBBatchOperation)batch).put(this.family, key, value);
    }

    @Override
    public void putWithBatch(BatchOperation batch, byte[] key, byte[] value) {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("batch should be RDBBatchOperation");
        }
        ((RDBBatchOperation)batch).put(this.family, key, value);
    }

    @Override
    public boolean isEmpty() throws RocksDatabaseException {
        try (Table.KeyValueIterator<byte[], byte[]> keyIter = this.iterator((byte[])null, Table.KeyValueIterator.Type.NEITHER);){
            keyIter.seekToFirst();
            boolean bl = !keyIter.hasNext();
            return bl;
        }
    }

    @Override
    public boolean isExist(byte[] key) throws RocksDatabaseException {
        boolean exists;
        this.rdbMetrics.incNumDBKeyMayExistChecks();
        Supplier<byte[]> holder = this.db.keyMayExist(this.family, key);
        if (holder == null) {
            return false;
        }
        byte[] value = holder.get();
        if (value != null) {
            return true;
        }
        boolean bl = exists = this.get(key) != null;
        if (!exists) {
            this.rdbMetrics.incNumDBKeyMayExistMisses();
        }
        return exists;
    }

    @Override
    public byte[] get(byte[] key) throws RocksDatabaseException {
        this.rdbMetrics.incNumDBKeyGets();
        return this.db.get(this.family, key);
    }

    Integer get(ByteBuffer key, ByteBuffer outValue) throws RocksDatabaseException {
        return this.db.get(this.family, key, outValue);
    }

    @Override
    public byte[] getSkipCache(byte[] bytes) throws RocksDatabaseException {
        return this.get(bytes);
    }

    @Override
    public byte[] getIfExist(byte[] key) throws RocksDatabaseException {
        this.rdbMetrics.incNumDBKeyGetIfExistChecks();
        Supplier<byte[]> value = this.db.keyMayExist(this.family, key);
        if (value == null) {
            return null;
        }
        if (value.get() != null) {
            return value.get();
        }
        this.rdbMetrics.incNumDBKeyGetIfExistGets();
        byte[] val = this.get(key);
        if (val == null) {
            this.rdbMetrics.incNumDBKeyGetIfExistMisses();
        }
        return val;
    }

    Integer getIfExist(ByteBuffer key, ByteBuffer outValue) throws RocksDatabaseException {
        this.rdbMetrics.incNumDBKeyGetIfExistChecks();
        Supplier<Integer> value = this.db.keyMayExist(this.family, key, outValue.duplicate());
        if (value == null) {
            return null;
        }
        if (value.get() != null) {
            return value.get();
        }
        this.rdbMetrics.incNumDBKeyGetIfExistGets();
        Integer val = this.get(key, outValue);
        if (val == null) {
            this.rdbMetrics.incNumDBKeyGetIfExistMisses();
        }
        return val;
    }

    @Override
    public void delete(byte[] key) throws RocksDatabaseException {
        this.db.delete(this.family, key);
    }

    @Override
    public void delete(ByteBuffer key) throws RocksDatabaseException {
        this.db.delete(this.family, key);
    }

    @Override
    public void deleteRange(byte[] beginKey, byte[] endKey) throws RocksDatabaseException {
        this.db.deleteRange(this.family, beginKey, endKey);
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, byte[] key) {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("batch should be RDBBatchOperation");
        }
        ((RDBBatchOperation)batch).delete(this.family, key);
    }

    @Override
    public void deleteRangeWithBatch(BatchOperation batch, byte[] beginKey, byte[] endKey) {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("batch should be RDBBatchOperation");
        }
        ((RDBBatchOperation)batch).deleteRange(this.family, beginKey, endKey);
    }

    @Override
    public Table.KeyValueIterator<byte[], byte[]> iterator(byte[] prefix, Table.KeyValueIterator.Type type) throws RocksDatabaseException {
        return new RDBStoreByteArrayIterator(this.db.newIterator(this.family, false), this, prefix, type);
    }

    @Override
    Table.KeyValueIterator<CodecBuffer, CodecBuffer> iterator(CodecBuffer prefix, Table.KeyValueIterator.Type type) throws RocksDatabaseException {
        return new RDBStoreCodecBufferIterator(this.db.newIterator(this.family, false), this, prefix, type);
    }

    @Override
    public String getName() {
        return this.family.getName();
    }

    @Override
    public long getEstimatedKeyCount() throws RocksDatabaseException {
        return this.db.estimateNumKeys(this.family);
    }

    @Override
    public void deleteBatchWithPrefix(BatchOperation batch, byte[] prefix) throws RocksDatabaseException, CodecException {
        try (Table.KeyValueIterator iter = this.iterator(prefix);){
            while (iter.hasNext()) {
                this.deleteWithBatch(batch, (byte[])((Table.KeyValue)iter.next()).getKey());
            }
        }
    }

    @Override
    public void dumpToFileWithPrefix(File externalFile, byte[] prefix) throws RocksDatabaseException, CodecException {
        try (Table.KeyValueIterator iter = this.iterator(prefix);
             RDBSstFileWriter fileWriter = new RDBSstFileWriter(externalFile);){
            while (iter.hasNext()) {
                Table.KeyValue entry = (Table.KeyValue)iter.next();
                fileWriter.put((byte[])entry.getKey(), (byte[])entry.getValue());
            }
        }
    }

    @Override
    public void loadFromFile(File externalFile) throws RocksDatabaseException {
        RDBSstFileLoader.load(this.db, this.family, externalFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Table.KeyValue<byte[], byte[]>> getRangeKVs(byte[] startKey, int count, byte[] prefix, MetadataKeyFilters.KeyPrefixFilter filter, boolean sequential) throws RocksDatabaseException, CodecException {
        ArrayList<Table.KeyValue<byte[], byte[]>> result;
        long start;
        block23: {
            Table.KeyValueIterator it;
            block20: {
                start = Time.monotonicNow();
                if (count < 0) {
                    throw new IllegalArgumentException("Invalid count given " + count + ", count must be greater than 0");
                }
                result = new ArrayList<Table.KeyValue<byte[], byte[]>>();
                try {
                    block21: {
                        ArrayList<Table.KeyValue<byte[], byte[]>> arrayList;
                        block22: {
                            it = this.iterator(prefix);
                            if (startKey == null) {
                                it.seekToFirst();
                                break block20;
                            }
                            if (prefix != null && startKey.length <= prefix.length || this.get(startKey) != null) break block21;
                            arrayList = result;
                            if (it == null) break block22;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            it.close();
                        }
                        long end = Time.monotonicNow();
                        long timeConsumed = end - start;
                        if (!LOG.isDebugEnabled()) return arrayList;
                        if (filter != null) {
                            int scanned = filter.getKeysScannedNum();
                            int hinted = filter.getKeysHintedNum();
                            if (scanned > 0 || hinted > 0) {
                                LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), scanned, hinted});
                            }
                        }
                        LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                        return arrayList;
                    }
                    it.seek(startKey);
                }
                catch (Throwable throwable) {
                    long end = Time.monotonicNow();
                    long timeConsumed = end - start;
                    if (!LOG.isDebugEnabled()) throw throwable;
                    if (filter != null) {
                        int scanned = filter.getKeysScannedNum();
                        int hinted = filter.getKeysHintedNum();
                        if (scanned > 0 || hinted > 0) {
                            LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), scanned, hinted});
                        }
                    }
                    LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                    throw throwable;
                }
            }
            while (it.hasNext() && result.size() < count) {
                Table.KeyValue currentEntry = (Table.KeyValue)it.next();
                if (filter == null || filter.filterKey((byte[])currentEntry.getKey())) {
                    result.add(currentEntry);
                    continue;
                }
                if (result.isEmpty() || !sequential) continue;
                break block23;
            }
            break block23;
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        long end = Time.monotonicNow();
        long timeConsumed = end - start;
        if (!LOG.isDebugEnabled()) return result;
        if (filter != null) {
            int scanned = filter.getKeysScannedNum();
            int hinted = filter.getKeysHintedNum();
            if (scanned > 0 || hinted > 0) {
                LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), scanned, hinted});
            }
        }
        LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
        return result;
    }
}

