/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.fsck;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconSafeModeManager;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconSafeModeMgrTask {
    private static final Logger LOG = LoggerFactory.getLogger(ReconSafeModeMgrTask.class);
    private ContainerManager containerManager;
    private ReconNodeManager nodeManager;
    private ReconSafeModeManager safeModeManager;
    private List<DatanodeInfo> allNodes;
    private List<ContainerInfo> containers;
    private final long interval;
    private final long dnHBInterval;

    public ReconSafeModeMgrTask(ContainerManager containerManager, ReconNodeManager nodeManager, ReconSafeModeManager safeModeManager, ReconTaskConfig reconTaskConfig, OzoneConfiguration ozoneConfiguration) {
        this.safeModeManager = safeModeManager;
        this.containerManager = containerManager;
        this.nodeManager = nodeManager;
        this.allNodes = nodeManager.getAllNodes();
        this.containers = containerManager.getContainers();
        this.interval = reconTaskConfig.getSafeModeWaitThreshold().toMillis();
        this.dnHBInterval = ozoneConfiguration.getTimeDuration("hdds.heartbeat.interval", "30s", TimeUnit.MILLISECONDS);
    }

    public synchronized void start() {
        block5: {
            try {
                long timeElapsed;
                this.tryReconExitSafeMode();
                for (timeElapsed = 0L; this.safeModeManager.getInSafeMode() && timeElapsed <= this.interval; timeElapsed += this.dnHBInterval) {
                    this.wait(this.dnHBInterval);
                    this.allNodes = this.nodeManager.getAllNodes();
                    this.containers = this.containerManager.getContainers();
                    this.tryReconExitSafeMode();
                }
                if (this.safeModeManager.getInSafeMode()) {
                    LOG.warn("Recon could not exit safe mode after {} ms. Exiting safe mode anyway. Please check for any unexpected startup issues", (Object)timeElapsed);
                    this.safeModeManager.setInSafeMode(false);
                } else {
                    LOG.info("Recon exited safe mode after {} ms.", (Object)timeElapsed);
                }
            }
            catch (Throwable t) {
                LOG.error("Exception in ReconSafeModeMgrTask Thread.", t);
                if (!(t instanceof InterruptedException)) break block5;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void tryReconExitSafeMode() {
        if (null == this.allNodes || this.allNodes.isEmpty()) {
            return;
        }
        if (null == this.containers || this.containers.isEmpty()) {
            return;
        }
        HashSet currentContainersInAllDatanodes = new HashSet(this.containers.size());
        this.allNodes.forEach(node -> {
            try {
                currentContainersInAllDatanodes.addAll(this.nodeManager.getContainers((DatanodeDetails)node));
            }
            catch (NodeNotFoundException e) {
                LOG.error("Node not found: {}", node);
            }
        });
        if (this.containers.size() == currentContainersInAllDatanodes.size()) {
            this.safeModeManager.setInSafeMode(false);
        }
    }
}

