/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistory;

public class ContainerReplicaHistoryList {
    private static final Codec<ContainerReplicaHistoryList> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)HddsProtos.ContainerReplicaHistoryListProto.getDefaultInstance()), ContainerReplicaHistoryList::fromProto, ContainerReplicaHistoryList::toProto, ContainerReplicaHistoryList.class);
    private List<ContainerReplicaHistory> replicaHistories;

    public ContainerReplicaHistoryList(List<ContainerReplicaHistory> replicaHistories) {
        this.replicaHistories = new ArrayList<ContainerReplicaHistory>(replicaHistories);
    }

    public static Codec<ContainerReplicaHistoryList> getCodec() {
        return CODEC;
    }

    public List<ContainerReplicaHistory> asList() {
        return Collections.unmodifiableList(this.replicaHistories);
    }

    public List<ContainerReplicaHistory> getList() {
        return this.replicaHistories;
    }

    public static ContainerReplicaHistoryList fromProto(HddsProtos.ContainerReplicaHistoryListProto proto) {
        ArrayList<ContainerReplicaHistory> replicaHistoryList = new ArrayList<ContainerReplicaHistory>();
        for (HddsProtos.ContainerReplicaHistoryProto rhProto : proto.getReplicaHistoryList()) {
            replicaHistoryList.add(ContainerReplicaHistory.fromProto(rhProto));
        }
        return new ContainerReplicaHistoryList(replicaHistoryList);
    }

    public HddsProtos.ContainerReplicaHistoryListProto toProto() {
        HddsProtos.ContainerReplicaHistoryListProto.Builder builder = HddsProtos.ContainerReplicaHistoryListProto.newBuilder();
        this.replicaHistories.stream().map(ContainerReplicaHistory::toProto).forEach(arg_0 -> ((HddsProtos.ContainerReplicaHistoryListProto.Builder)builder).addReplicaHistory(arg_0));
        return builder.build();
    }
}

