/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTaskDbEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTaskDbEventHandler.class);
    private ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private ReconOMMetadataManager reconOMMetadataManager;

    public NSSummaryTaskDbEventHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager) {
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.reconOMMetadataManager = reconOMMetadataManager;
    }

    public ReconNamespaceSummaryManager getReconNamespaceSummaryManager() {
        return this.reconNamespaceSummaryManager;
    }

    public ReconOMMetadataManager getReconOMMetadataManager() {
        return this.reconOMMetadataManager;
    }

    private void updateNSSummariesToDB(Map<Long, NSSummary> nsSummaryMap, Collection<Long> objectIdsToBeDeleted) throws IOException {
        try (RDBBatchOperation rdbBatchOperation = new RDBBatchOperation();){
            for (Map.Entry<Long, NSSummary> entry : nsSummaryMap.entrySet()) {
                try {
                    this.reconNamespaceSummaryManager.batchStoreNSSummaries((BatchOperation)rdbBatchOperation, entry.getKey(), entry.getValue());
                }
                catch (IOException e) {
                    LOG.error("Unable to write Namespace Summary data in Recon DB.", (Throwable)e);
                    throw e;
                }
            }
            for (Long objectId : objectIdsToBeDeleted) {
                try {
                    this.reconNamespaceSummaryManager.batchDeleteNSSummaries((BatchOperation)rdbBatchOperation, objectId);
                }
                catch (IOException e) {
                    LOG.error("Unable to delete Namespace Summary data from Recon DB.", (Throwable)e);
                    throw e;
                }
            }
            this.reconNamespaceSummaryManager.commitBatchOperation(rdbBatchOperation);
        }
        LOG.debug("Successfully updated Namespace Summary data in Recon DB.");
    }

    protected void handlePutKeyEvent(OmKeyInfo keyInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        int binIndex;
        long parentObjectId = keyInfo.getParentObjectID();
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            nsSummary = new NSSummary();
        }
        int[] fileBucket = nsSummary.getFileSizeBucket();
        nsSummary.setNumOfFiles(nsSummary.getNumOfFiles() + 1);
        nsSummary.setSizeOfFiles(nsSummary.getSizeOfFiles() + keyInfo.getDataSize());
        int n = binIndex = ReconUtils.getFileSizeBinIndex(keyInfo.getDataSize());
        fileBucket[n] = fileBucket[n] + 1;
        nsSummary.setFileSizeBucket(fileBucket);
        nsSummaryMap.put(parentObjectId, nsSummary);
        this.propagateSizeUpwards(parentObjectId, keyInfo.getDataSize(), 1, nsSummaryMap);
    }

    protected void handlePutDirEvent(OmDirectoryInfo directoryInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        int existingNumOfFiles;
        long parentObjectId = directoryInfo.getParentObjectID();
        long objectId = directoryInfo.getObjectID();
        String dirName = directoryInfo.getName();
        NSSummary curNSSummary = nsSummaryMap.get(objectId);
        if (curNSSummary == null) {
            curNSSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        }
        boolean directoryAlreadyExists = curNSSummary != null;
        long existingSizeOfFiles = directoryAlreadyExists ? curNSSummary.getSizeOfFiles() : 0L;
        int n = existingNumOfFiles = directoryAlreadyExists ? curNSSummary.getNumOfFiles() : 0;
        if (curNSSummary == null) {
            curNSSummary = new NSSummary();
        }
        curNSSummary.setDirName(dirName);
        curNSSummary.setParentId(parentObjectId);
        nsSummaryMap.put(objectId, curNSSummary);
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            nsSummary = new NSSummary();
        }
        nsSummary.addChildDir(objectId);
        nsSummaryMap.put(parentObjectId, nsSummary);
        if (directoryAlreadyExists && (existingSizeOfFiles > 0L || existingNumOfFiles > 0)) {
            this.propagateSizeUpwards(parentObjectId, existingSizeOfFiles, existingNumOfFiles, nsSummaryMap);
        }
    }

    protected void handleDeleteKeyEvent(OmKeyInfo keyInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        long parentObjectId = keyInfo.getParentObjectID();
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            LOG.error("The namespace table is not correctly populated.");
            return;
        }
        int[] fileBucket = nsSummary.getFileSizeBucket();
        int binIndex = ReconUtils.getFileSizeBinIndex(keyInfo.getDataSize());
        nsSummary.setNumOfFiles(nsSummary.getNumOfFiles() - 1);
        nsSummary.setSizeOfFiles(nsSummary.getSizeOfFiles() - keyInfo.getDataSize());
        int n = binIndex;
        fileBucket[n] = fileBucket[n] - 1;
        nsSummary.setFileSizeBucket(fileBucket);
        nsSummaryMap.put(parentObjectId, nsSummary);
        this.propagateSizeUpwards(parentObjectId, -keyInfo.getDataSize(), -1, nsSummaryMap);
    }

    protected void handleDeleteDirEvent(OmDirectoryInfo directoryInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        NSSummary parentNsSummary;
        long deletedDirObjectId = directoryInfo.getObjectID();
        long parentObjectId = directoryInfo.getParentObjectID();
        NSSummary deletedDirSummary = nsSummaryMap.get(deletedDirObjectId);
        if (deletedDirSummary == null) {
            deletedDirSummary = this.reconNamespaceSummaryManager.getNSSummary(deletedDirObjectId);
        }
        if ((parentNsSummary = nsSummaryMap.get(parentObjectId)) == null) {
            parentNsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (parentNsSummary == null) {
            LOG.error("The namespace table is not correctly populated.");
            return;
        }
        if (deletedDirSummary != null) {
            parentNsSummary.setNumOfFiles(parentNsSummary.getNumOfFiles() - deletedDirSummary.getNumOfFiles());
            parentNsSummary.setSizeOfFiles(parentNsSummary.getSizeOfFiles() - deletedDirSummary.getSizeOfFiles());
            this.propagateSizeUpwards(parentObjectId, -deletedDirSummary.getSizeOfFiles(), -deletedDirSummary.getNumOfFiles(), nsSummaryMap);
            deletedDirSummary.setParentId(0L);
            nsSummaryMap.put(deletedDirObjectId, deletedDirSummary);
        }
        parentNsSummary.removeChildDir(deletedDirObjectId);
        nsSummaryMap.put(parentObjectId, parentNsSummary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flushAndCommitNSToDB(Map<Long, NSSummary> nsSummaryMap) {
        try {
            this.updateNSSummariesToDB(nsSummaryMap, Collections.emptyList());
        }
        catch (IOException e) {
            LOG.error("Unable to write Namespace Summary data in Recon DB.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            nsSummaryMap.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flushAndCommitUpdatedNSToDB(Map<Long, NSSummary> nsSummaryMap, Collection<Long> objectIdsToBeDeleted) {
        try {
            this.updateNSSummariesToDB(nsSummaryMap, objectIdsToBeDeleted);
        }
        catch (IOException e) {
            LOG.error("Unable to write Namespace Summary data in Recon DB. batchSize={}", (Object)nsSummaryMap.size(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            nsSummaryMap.clear();
        }
        return true;
    }

    protected void propagateSizeUpwards(long objectId, long sizeChange, int countChange, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        NSSummary nsSummary = nsSummaryMap.get(objectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        }
        if (nsSummary == null) {
            return;
        }
        long parentId = nsSummary.getParentId();
        if (parentId != 0L) {
            NSSummary parentSummary = nsSummaryMap.get(parentId);
            if (parentSummary == null) {
                parentSummary = this.reconNamespaceSummaryManager.getNSSummary(parentId);
            }
            if (parentSummary != null) {
                parentSummary.setSizeOfFiles(parentSummary.getSizeOfFiles() + sizeChange);
                parentSummary.setNumOfFiles(parentSummary.getNumOfFiles() + countChange);
                nsSummaryMap.put(parentId, parentSummary);
                this.propagateSizeUpwards(parentId, sizeChange, countChange, nsSummaryMap);
            }
        }
    }
}

