/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.reflect.package$;

@ScalaSignature(bytes="\u0006\u0001a3Q!\u0002\u0004\u0002\nMA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\tu\u0001\u0011\u0019\u0011)A\u0006w!)\u0011\t\u0001C\u0001\u0005\")\u0001\n\u0001C!\u0013\n)\")[4Ok6\u0014WM\u001d#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\u0004\t\u0003\u0015!Wm]3s\u0015\tI!\"A\u0003tG\u0006d\u0017M\u0003\u0002\f\u0019\u00051Qn\u001c3vY\u0016T!!\u0004\b\u0002\u000f)\f7m[:p]*\u0011q\u0002E\u0001\nM\u0006\u001cH/\u001a:y[2T\u0011!E\u0001\u0004G>l7\u0001A\u000b\u0003)\u0001\u001a\"\u0001A\u000b\u0011\u0007Yab$D\u0001\u0018\u0015\tA\u0012$A\u0002ti\u0012T!a\u0002\u000e\u000b\u0005ma\u0011\u0001\u00033bi\u0006\u0014\u0017N\u001c3\n\u0005u9\"!F*uIN\u001b\u0017\r\\1s\t\u0016\u001cXM]5bY&TXM\u001d\t\u0003?\u0001b\u0001\u0001B\u0003\"\u0001\t\u0007!EA\u0001U#\t\u0019\u0003\u0006\u0005\u0002%M5\tQEC\u0001\n\u0013\t9SE\u0001\u0003Ok2d\u0007C\u0001\u0013*\u0013\tQSEA\u0002B]f\fqa\u0019:fCR|'\u000f\u0005\u0003%[=r\u0012B\u0001\u0018&\u0005%1UO\\2uS>t\u0017\u0007\u0005\u00021o9\u0011\u0011'\u000e\t\u0003e\u0015j\u0011a\r\u0006\u0003iI\ta\u0001\u0010:p_Rt\u0014B\u0001\u001c&\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y*\u0013AC3wS\u0012,gnY3%cA\u0019Ah\u0010\u0010\u000e\u0003uR!AP\u0013\u0002\u000fI,g\r\\3di&\u0011\u0001)\u0010\u0002\t\u00072\f7o\u001d+bO\u00061A(\u001b8jiz\"\"aQ$\u0015\u0005\u00113\u0005cA#\u0001=5\ta\u0001C\u0003;\u0007\u0001\u000f1\bC\u0003,\u0007\u0001\u0007A&A\u0006eKN,'/[1mSj,Gc\u0001\u0010K%\")1\n\u0002a\u0001\u0019\u0006\u0011!\u000e\u001d\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f2\tAaY8sK&\u0011\u0011K\u0014\u0002\u000b\u0015N|g\u000eU1sg\u0016\u0014\b\"B*\u0005\u0001\u0004!\u0016\u0001B2uqR\u0004\"!\u0016,\u000e\u0003iI!a\u0016\u000e\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cuN\u001c;fqR\u0004")
public abstract class BigNumberDeserializer<T>
extends StdScalarDeserializer<T> {
    private final Function1<String, T> creator;

    public T deserialize(JsonParser jp, DeserializationContext ctxt) {
        Object object;
        JsonToken t = jp.getCurrentToken();
        JsonToken jsonToken = t;
        boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
        if (bl) {
            object = this.creator.apply((Object)jp.getText().trim());
        } else if (JsonToken.VALUE_STRING.equals(jsonToken)) {
            Object object2;
            String text = jp.getText().trim();
            if (text.isEmpty()) {
                object2 = None$.MODULE$.orNull(Predef$.MODULE$.$conforms());
            } else {
                try {
                    object2 = this.creator.apply((Object)text);
                }
                catch (IllegalArgumentException e) {
                    throw ctxt.weirdStringException(text, this._valueClass, "not a valid representation");
                }
            }
            object = object2;
        } else if (JsonToken.START_ARRAY.equals(jsonToken) && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            T value = this.deserialize(jp, ctxt);
            JsonToken jsonToken2 = jp.nextToken();
            JsonToken jsonToken3 = JsonToken.END_ARRAY;
            if (jsonToken2 == null ? jsonToken3 != null : !jsonToken2.equals(jsonToken3)) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap array for single value but there was more than a single value in the array");
            }
            object = value;
        } else {
            object = ctxt.handleUnexpectedToken(this._valueClass, jp);
        }
        return (T)object;
    }

    public BigNumberDeserializer(Function1<String, T> creator, ClassTag<T> evidence$1) {
        this.creator = creator;
        super(package$.MODULE$.classTag(evidence$1).runtimeClass());
    }
}

