/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestExtendedAcls {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static final short REPLICATION = 3;
    private static DistributedFileSystem hdfs;

    @BeforeClass
    public static void setup() throws IOException {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
    }

    @AfterClass
    public static void shutdown() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testDefaultAclNewChildDirFile() throws IOException {
        Path parent = new Path("/testDefaultAclNewChildDirFile");
        ArrayList acls = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        hdfs.mkdirs(parent);
        hdfs.setAcl(parent, (List)acls);
        Path childDir = new Path(parent, "childDir");
        hdfs.mkdirs(childDir);
        Object[] childDirExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)};
        AclStatus childDirAcl = hdfs.getAclStatus(childDir);
        Assert.assertArrayEquals((Object[])childDirExpectedAcl, (Object[])childDirAcl.getEntries().toArray());
        Path childFile = new Path(parent, "childFile");
        hdfs.create(childFile).close();
        Object[] childFileExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        AclStatus childFileAcl = hdfs.getAclStatus(childFile);
        Assert.assertArrayEquals((Object[])childFileExpectedAcl, (Object[])childFileAcl.getEntries().toArray());
        hdfs.delete(parent, true);
    }

    @Test
    public void testDefaultAclExistingDirFile() throws Exception {
        Path parent = new Path("/testDefaultAclExistingDirFile");
        hdfs.mkdirs(parent);
        ArrayList acls1 = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL)});
        ArrayList acls2 = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        hdfs.setAcl(parent, (List)acls1);
        Path childDir = new Path(parent, "childDir");
        hdfs.mkdirs(childDir);
        Object[] childDirExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)};
        AclStatus childDirAcl = hdfs.getAclStatus(childDir);
        Assert.assertArrayEquals((Object[])childDirExpectedAcl, (Object[])childDirAcl.getEntries().toArray());
        Path childFile = new Path(childDir, "childFile");
        hdfs.create(childFile).close();
        Object[] childFileExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        AclStatus childFileAcl = hdfs.getAclStatus(childFile);
        Assert.assertArrayEquals((Object[])childFileExpectedAcl, (Object[])childFileAcl.getEntries().toArray());
        hdfs.setAcl(parent, (List)acls2);
        childDirAcl = hdfs.getAclStatus(childDir);
        Assert.assertArrayEquals((Object[])childDirExpectedAcl, (Object[])childDirAcl.getEntries().toArray());
        childFileAcl = hdfs.getAclStatus(childFile);
        Assert.assertArrayEquals((Object[])childFileExpectedAcl, (Object[])childFileAcl.getEntries().toArray());
        hdfs.removeAcl(parent);
        childDirAcl = hdfs.getAclStatus(childDir);
        Assert.assertArrayEquals((Object[])childDirExpectedAcl, (Object[])childDirAcl.getEntries().toArray());
        childFileAcl = hdfs.getAclStatus(childFile);
        Assert.assertArrayEquals((Object[])childFileExpectedAcl, (Object[])childFileAcl.getEntries().toArray());
        hdfs.setPermission(childFile, new FsPermission(416));
        boolean canAccess = this.tryAccess(childFile, "other", new String[]{"other"}, FsAction.READ);
        Assert.assertFalse((boolean)canAccess);
        hdfs.delete(parent, true);
    }

    @Test
    public void testAccessAclNotInherited() throws IOException {
        Path parent = new Path("/testAccessAclNotInherited");
        hdfs.mkdirs(parent);
        ArrayList acls = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.ALL)});
        hdfs.setAcl(parent, (List)acls);
        Path childDir = new Path(parent, "childDir");
        hdfs.mkdirs(childDir);
        Object[] childDirExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ)};
        AclStatus childDirAcl = hdfs.getAclStatus(childDir);
        Assert.assertArrayEquals((Object[])childDirExpectedAcl, (Object[])childDirAcl.getEntries().toArray());
        Path childFile = new Path(parent, "childFile");
        hdfs.create(childFile).close();
        Object[] childFileExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)};
        AclStatus childFileAcl = hdfs.getAclStatus(childFile);
        Assert.assertArrayEquals((Object[])childFileExpectedAcl, (Object[])childFileAcl.getEntries().toArray());
        hdfs.delete(parent, true);
    }

    @Test
    public void testGradSubdirMoreAccess() throws Exception {
        Path parent = new Path("/testGradSubdirMoreAccess");
        hdfs.mkdirs(parent);
        ArrayList aclsParent = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
        ArrayList aclsChild = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "bar", FsAction.READ_WRITE)});
        hdfs.setAcl(parent, (List)aclsParent);
        Object[] parentDirExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)};
        AclStatus parentAcl = hdfs.getAclStatus(parent);
        Assert.assertArrayEquals((Object[])parentDirExpectedAcl, (Object[])parentAcl.getEntries().toArray());
        Path childDir = new Path(parent, "childDir");
        hdfs.mkdirs(childDir);
        hdfs.modifyAclEntries(childDir, (List)aclsChild);
        Object[] childDirExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "bar", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)};
        AclStatus childDirAcl = hdfs.getAclStatus(childDir);
        Assert.assertArrayEquals((Object[])childDirExpectedAcl, (Object[])childDirAcl.getEntries().toArray());
        Path parentFile = new Path(parent, "parentFile");
        hdfs.create(parentFile).close();
        hdfs.setPermission(parentFile, new FsPermission(416));
        Object[] parentFileExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        AclStatus parentFileAcl = hdfs.getAclStatus(parentFile);
        Assert.assertArrayEquals((Object[])parentFileExpectedAcl, (Object[])parentFileAcl.getEntries().toArray());
        Path childFile = new Path(childDir, "childFile");
        hdfs.create(childFile).close();
        hdfs.setPermission(childFile, new FsPermission(416));
        Object[] childFileExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.READ_WRITE)};
        AclStatus childFileAcl = hdfs.getAclStatus(childFile);
        Assert.assertArrayEquals((Object[])childFileExpectedAcl, (Object[])childFileAcl.getEntries().toArray());
        Assert.assertFalse((boolean)this.tryAccess(parentFile, "barUser", new String[]{"bar"}, FsAction.READ));
        Assert.assertTrue((boolean)this.tryAccess(childFile, "barUser", new String[]{"bar"}, FsAction.READ));
        Assert.assertTrue((boolean)this.tryAccess(parentFile, "foo", new String[]{"fooGroup"}, FsAction.READ));
        Assert.assertTrue((boolean)this.tryAccess(childFile, "foo", new String[]{"fooGroup"}, FsAction.READ));
        hdfs.delete(parent, true);
    }

    @Test
    public void testRestrictAtSubDir() throws Exception {
        Path parent = new Path("/testRestrictAtSubDir");
        hdfs.mkdirs(parent);
        ArrayList aclsParent = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "bar", FsAction.ALL)});
        hdfs.setAcl(parent, (List)aclsParent);
        Object[] parentDirExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "bar", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)};
        AclStatus parentAcl = hdfs.getAclStatus(parent);
        Assert.assertArrayEquals((Object[])parentDirExpectedAcl, (Object[])parentAcl.getEntries().toArray());
        Path parentFile = new Path(parent, "parentFile");
        hdfs.create(parentFile).close();
        hdfs.setPermission(parentFile, new FsPermission(416));
        Object[] parentFileExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.ALL)};
        AclStatus parentFileAcl = hdfs.getAclStatus(parentFile);
        Assert.assertArrayEquals((Object[])parentFileExpectedAcl, (Object[])parentFileAcl.getEntries().toArray());
        Path childDir = new Path(parent, "childDir");
        hdfs.mkdirs(childDir);
        ArrayList newAclsChild = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "bar", FsAction.NONE)});
        hdfs.modifyAclEntries(childDir, (List)newAclsChild);
        Object[] childDirExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "bar", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)};
        AclStatus childDirAcl = hdfs.getAclStatus(childDir);
        Assert.assertArrayEquals((Object[])childDirExpectedAcl, (Object[])childDirAcl.getEntries().toArray());
        Path childFile = new Path(childDir, "childFile");
        hdfs.create(childFile).close();
        hdfs.setPermission(childFile, new FsPermission(416));
        Object[] childFileExpectedAcl = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.NONE)};
        AclStatus childFileAcl = hdfs.getAclStatus(childFile);
        Assert.assertArrayEquals((Object[])childFileExpectedAcl, (Object[])childFileAcl.getEntries().toArray());
        Assert.assertFalse((boolean)this.tryAccess(childFile, "barUser", new String[]{"bar"}, FsAction.READ));
        Assert.assertTrue((boolean)this.tryAccess(childFile, "foo", new String[]{"fooGroup"}, FsAction.READ));
        Assert.assertTrue((boolean)this.tryAccess(parentFile, "barUser", new String[]{"bar"}, FsAction.READ));
        Assert.assertTrue((boolean)this.tryAccess(parentFile, "foo", new String[]{"fooGroup"}, FsAction.READ));
        hdfs.delete(parent, true);
    }

    private boolean tryAccess(Path path, String user, String[] group, FsAction action) throws Exception {
        boolean canAccess;
        UserGroupInformation testUser = UserGroupInformation.createUserForTesting((String)user, (String[])group);
        FileSystem fs = (FileSystem)testUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((Configuration)conf);
            }
        });
        try {
            fs.access(path, action);
            canAccess = true;
        }
        catch (AccessControlException e) {
            canAccess = false;
        }
        return canAccess;
    }
}

