/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.CombinedHostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostFileManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestHostsFiles {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestHostsFiles.class.getName());
    private Class hostFileMgrClass;

    public TestHostsFiles(Class hostFileMgrClass) {
        this.hostFileMgrClass = hostFileMgrClass;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({HostFileManager.class}, {CombinedHostFileManager.class});
    }

    private Configuration getConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        conf.setInt("dfs.namenode.reconstruction.pending.timeout-sec", 1);
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("net.topology.script.file.name", "xyz");
        conf.setClass("dfs.namenode.hosts.provider.classname", this.hostFileMgrClass, HostConfigManager.class);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHostsExcludeInUI() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 2;
        Path filePath = new Path("/testFile");
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/decommission");
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(filePath), 0L, Long.MAX_VALUE);
            String name = locs[0].getNames()[0];
            LOG.info("adding '" + name + "' to decommission");
            hostsFileWriter.initExcludeHost(name);
            ns.getBlockManager().getDatanodeManager().refreshNodes(conf);
            DFSTestUtil.waitForDecommission((FileSystem)fs, name);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            String nodes = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            Assert.assertTrue((String)"Live nodes should contain the decommissioned node", (boolean)nodes.contains("Decommissioned"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHostsIncludeForDeadCount() throws Exception {
        Configuration conf = this.getConf();
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/decommission");
        hostsFileWriter.initIncludeHosts(new String[]{"localhost:52", "127.0.0.1:7777"});
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            FSNamesystem ns = cluster.getNameNode().getNamesystem();
            Assert.assertTrue((ns.getNumDeadDataNodes() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((ns.getNumLiveDataNodes() == 0 ? 1 : 0) != 0);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            String nodes = mbs.getAttribute(mxbeanName, "NumDeadDataNodes") + "";
            Assert.assertTrue(((Integer)mbs.getAttribute(mxbeanName, "NumDeadDataNodes") == 2 ? 1 : 0) != 0);
            Assert.assertTrue(((Integer)mbs.getAttribute(mxbeanName, "NumLiveDataNodes") == 0 ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }
}

