/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.router.AbstractRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class PriorityRouterPolicy
extends AbstractRouterPolicy {
    @Override
    public SubClusterId getHomeSubcluster(ApplicationSubmissionContext appSubmissionContext, List<SubClusterId> blacklist) throws YarnException {
        this.validate(appSubmissionContext);
        Map<SubClusterId, SubClusterInfo> activeSubclusters = this.getActiveSubclusters();
        FederationPolicyUtils.validateSubClusterAvailability(new ArrayList<SubClusterId>(activeSubclusters.keySet()), blacklist);
        Map<SubClusterIdInfo, Float> weights = this.getPolicyInfo().getRouterPolicyWeights();
        SubClusterId chosen = null;
        Float currentBest = Float.valueOf(Float.MIN_VALUE);
        for (SubClusterId id : activeSubclusters.keySet()) {
            SubClusterIdInfo idInfo = new SubClusterIdInfo(id);
            if (blacklist != null && blacklist.contains(id) || !weights.containsKey(idInfo) || !(weights.get(idInfo).floatValue() > currentBest.floatValue())) continue;
            currentBest = weights.get(idInfo);
            chosen = id;
        }
        if (chosen == null) {
            throw new FederationPolicyException("No Active Subcluster with weight vector greater than zero");
        }
        return chosen;
    }
}

