/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class TestSuite
implements Test {
    private Vector fTests = new Vector(10);
    private String fName;
    static /* synthetic */ Class class$junit$framework$Test;
    static /* synthetic */ Class class$java$lang$String;

    public TestSuite() {
    }

    public TestSuite(Class clazz) {
        this.fName = clazz.getName();
        Constructor constructor = this.getConstructor(clazz);
        if (!Modifier.isPublic(clazz.getModifiers())) {
            this.addTest(this.warning("Class " + clazz.getName() + " is not public"));
            return;
        }
        if (constructor == null) {
            this.addTest(this.warning("Class " + clazz.getName() + " has no public constructor TestCase(String name)"));
            return;
        }
        Class clazz2 = clazz;
        Vector vector = new Vector();
        while ((class$junit$framework$Test != null ? class$junit$framework$Test : TestSuite.class$("junit.framework.Test")).isAssignableFrom(clazz2)) {
            Method[] methodArray = clazz2.getDeclaredMethods();
            int n = 0;
            while (n < methodArray.length) {
                this.addTestMethod(methodArray[n], vector, constructor);
                ++n;
            }
            clazz2 = clazz2.getSuperclass();
        }
        if (this.fTests.size() == 0) {
            this.addTest(this.warning("No tests found in " + clazz.getName()));
        }
    }

    public TestSuite(String string) {
        this.fName = string;
    }

    public void addTest(Test test) {
        this.fTests.addElement(test);
    }

    private void addTestMethod(Method method, Vector vector, Constructor constructor) {
        String string = method.getName();
        if (vector.contains(string)) {
            return;
        }
        if (this.isPublicTestMethod(method)) {
            vector.addElement(string);
            Object[] objectArray = new Object[]{string};
            try {
                this.addTest((Test)constructor.newInstance(objectArray));
            }
            catch (Exception exception) {
                this.addTest(this.warning("Cannot instantiate test case: " + string));
            }
        } else if (this.isTestMethod(method)) {
            this.addTest(this.warning("Test method isn't public: " + method.getName()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int countTestCases() {
        int n = 0;
        Enumeration enumeration = this.tests();
        while (enumeration.hasMoreElements()) {
            Test test = (Test)enumeration.nextElement();
            n += test.countTestCases();
        }
        return n;
    }

    private Constructor getConstructor(Class clazz) {
        Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = TestSuite.class$("java.lang.String"))};
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (Exception exception) {}
        return constructor;
    }

    private boolean isPublicTestMethod(Method method) {
        return this.isTestMethod(method) && Modifier.isPublic(method.getModifiers());
    }

    private boolean isTestMethod(Method method) {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getReturnType();
        return classArray.length == 0 && string.startsWith("test") && clazz.equals(Void.TYPE);
    }

    public void run(TestResult testResult) {
        Enumeration enumeration = this.tests();
        while (enumeration.hasMoreElements()) {
            if (testResult.shouldStop()) break;
            Test test = (Test)enumeration.nextElement();
            test.run(testResult);
        }
    }

    public Test testAt(int n) {
        return (Test)this.fTests.elementAt(n);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.fName != null) {
            return this.fName;
        }
        return super.toString();
    }

    private Test warning(final String string) {
        return new TestCase("warning"){

            protected void runTest() {
                Assert.fail(string);
            }
        };
    }
}

