/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics.fate;

import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.accumulo.master.metrics.fate.FateLegacyJMXMetricsMBean;
import org.apache.accumulo.master.metrics.fate.FateMetricSnapshot;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FateLegacyJMXMetrics
implements Metrics,
FateLegacyJMXMetricsMBean {
    private static final Logger log = LoggerFactory.getLogger(FateLegacyJMXMetrics.class);
    private static final long DEFAULT_MIN_REFRESH_DELAY = TimeUnit.SECONDS.toMillis(10L);
    private final long minimumRefreshDelay;
    private final AtomicReference<FateMetricSnapshot> metricValues;
    private volatile long lastUpdate = 0L;
    private final String instanceId;
    private ObjectName objectName = null;
    private volatile boolean enabled = false;
    private final ZooReaderWriter zoo;

    public FateLegacyJMXMetrics(String instanceId, long minimumRefreshDelay) {
        this.instanceId = instanceId;
        this.zoo = ZooReaderWriter.getInstance();
        this.minimumRefreshDelay = Math.max(DEFAULT_MIN_REFRESH_DELAY, minimumRefreshDelay);
        this.metricValues = new AtomicReference<FateMetricSnapshot>(FateMetricSnapshot.builder().build());
        try {
            this.objectName = new ObjectName("accumulo.server.metrics:service=FateLegacyJMXMetrics,name=FateLegacyJMXMetricsMBean,instance=" + Thread.currentThread().getName());
        }
        catch (Exception e) {
            log.error("Exception setting MBean object name", (Throwable)e);
        }
    }

    public void register() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (null == this.objectName) {
            throw new IllegalArgumentException("MBean object name must be set.");
        }
        mbs.registerMBean(this, this.objectName);
        this.enabled = true;
    }

    public void add(String name, long time) {
        throw new UnsupportedOperationException("add() is not implemented");
    }

    public synchronized void snapshot() {
        long now = System.currentTimeMillis();
        if (this.lastUpdate + this.minimumRefreshDelay > now) {
            return;
        }
        FateMetricSnapshot updates = FateMetricSnapshot.getFromZooKeeper(this.instanceId, (org.apache.accumulo.fate.zookeeper.ZooReaderWriter)this.zoo);
        this.metricValues.set(updates);
        this.lastUpdate = now;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public long getCurrentFateOps() {
        this.snapshot();
        return this.metricValues.get().getCurrentFateOps();
    }

    @Override
    public long getZkFateChildOpsTotal() {
        this.snapshot();
        return this.metricValues.get().getZkFateChildOpsTotal();
    }

    @Override
    public long getZKConnectionErrorsTotal() {
        this.snapshot();
        return this.metricValues.get().getZkConnectionErrors();
    }
}

