/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.logging;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.logging.JulToSlf4jInitializer;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MiscTests.class, SmallTests.class})
public class TestJul2Slf4j {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestJul2Slf4j.class);
    private String loggerName = this.getClass().getName();
    private Appender mockAppender;

    @Before
    public void setUp() {
        this.mockAppender = (Appender)Mockito.mock(Appender.class);
        LogManager.getRootLogger().addAppender(this.mockAppender);
    }

    @After
    public void tearDown() {
        LogManager.getRootLogger().removeAppender(this.mockAppender);
    }

    @Test
    public void test() throws IOException {
        Logger logger = Logger.getLogger(this.loggerName);
        logger.info(this.loggerName);
        ArgumentCaptor captor = ArgumentCaptor.forClass(LoggingEvent.class);
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.times((int)1))).doAppend((LoggingEvent)captor.capture());
        LoggingEvent loggingEvent = (LoggingEvent)captor.getValue();
        MatcherAssert.assertThat((Object)loggingEvent.getLevel(), (Matcher)CoreMatchers.is((Object)Level.INFO));
        Assert.assertEquals((Object)this.loggerName, (Object)loggingEvent.getRenderedMessage());
    }

    static {
        System.setProperty("java.util.logging.config.class", JulToSlf4jInitializer.class.getName());
    }
}

