/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class SnapshotWithAclTestBase
extends SecureTestUtil {
    private TableName TEST_TABLE = TableName.valueOf((String)TEST_UTIL.getRandomUUID().toString());
    private static final int ROW_COUNT = 30000;
    private static byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static byte[] TEST_QUALIFIER = Bytes.toBytes((String)"cq");
    private static byte[] TEST_ROW = Bytes.toBytes((int)0);
    protected static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static User USER_OWNER;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_NONE;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SnapshotWithAclTestBase.enableSecurity(conf);
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName());
        SnapshotWithAclTestBase.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitUntilAllRegionsAssigned(PermissionStorage.ACL_TABLE_NAME);
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"usernone", (String[])new String[0]);
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.createTable(TableDescriptorBuilder.newBuilder((TableName)this.TEST_TABLE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])TEST_FAMILY).setMaxVersions(100).build()).setOwner(USER_OWNER).build(), (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE);
        SnapshotWithAclTestBase.grantOnTable(TEST_UTIL, USER_RW.getShortName(), this.TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
        SnapshotWithAclTestBase.grantOnTable(TEST_UTIL, USER_RO.getShortName(), this.TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
    }

    private void loadData() throws IOException {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table t = conn.getTable(this.TEST_TABLE);){
            for (int i = 0; i < 30000; ++i) {
                Put put = new Put(Bytes.toBytes((int)i));
                put.addColumn(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)i));
                t.put(put);
            }
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private void verifyRows(TableName tableName) throws IOException {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Table t = conn.getTable(tableName);
             ResultScanner scanner = t.getScanner(new Scan());){
            Result result;
            int rowCount = 0;
            while ((result = scanner.next()) != null) {
                byte[] value = result.getValue(TEST_FAMILY, TEST_QUALIFIER);
                Assert.assertArrayEquals((byte[])value, (byte[])Bytes.toBytes((int)rowCount++));
            }
            Assert.assertEquals((long)30000L, (long)rowCount);
        }
    }

    protected abstract void snapshot(String var1, TableName var2) throws Exception;

    protected abstract void cloneSnapshot(String var1, TableName var2, boolean var3) throws Exception;

    protected abstract void restoreSnapshot(String var1, boolean var2) throws Exception;

    @Test
    public void testRestoreSnapshot() throws Exception {
        SnapshotWithAclTestBase.verifyAllowed(new AccessReadAction(this.TEST_TABLE), USER_OWNER, USER_RO, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessReadAction(this.TEST_TABLE), USER_NONE);
        SnapshotWithAclTestBase.verifyAllowed(new AccessWriteAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessWriteAction(this.TEST_TABLE), USER_RO, USER_NONE);
        this.loadData();
        this.verifyRows(this.TEST_TABLE);
        String snapshotName1 = TEST_UTIL.getRandomUUID().toString();
        this.snapshot(snapshotName1, this.TEST_TABLE);
        TableName tableName1 = TableName.valueOf((String)TEST_UTIL.getRandomUUID().toString());
        this.cloneSnapshot(snapshotName1, tableName1, true);
        this.verifyRows(tableName1);
        SnapshotWithAclTestBase.verifyAllowed(new AccessReadAction(tableName1), USER_OWNER, USER_RO, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessReadAction(tableName1), USER_NONE);
        SnapshotWithAclTestBase.verifyAllowed(new AccessWriteAction(tableName1), USER_OWNER, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessWriteAction(tableName1), USER_RO, USER_NONE);
        TableName tableName2 = TableName.valueOf((String)TEST_UTIL.getRandomUUID().toString());
        this.cloneSnapshot(snapshotName1, tableName2, false);
        this.verifyRows(tableName2);
        SnapshotWithAclTestBase.verifyAllowed(new AccessReadAction(tableName2), USER_OWNER);
        SnapshotWithAclTestBase.verifyDenied(new AccessReadAction(tableName2), USER_NONE, USER_RO, USER_RW);
        SnapshotWithAclTestBase.verifyAllowed(new AccessWriteAction(tableName2), USER_OWNER);
        SnapshotWithAclTestBase.verifyDenied(new AccessWriteAction(tableName2), USER_RO, USER_RW, USER_NONE);
        SnapshotWithAclTestBase.revokeFromTable(TEST_UTIL, USER_RO.getShortName(), this.TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        SnapshotWithAclTestBase.verifyAllowed(new AccessReadAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessReadAction(this.TEST_TABLE), USER_RO, USER_NONE);
        SnapshotWithAclTestBase.verifyAllowed(new AccessWriteAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessWriteAction(this.TEST_TABLE), USER_RO, USER_NONE);
        TEST_UTIL.getAdmin().disableTable(this.TEST_TABLE);
        this.restoreSnapshot(snapshotName1, false);
        TEST_UTIL.getAdmin().enableTable(this.TEST_TABLE);
        SnapshotWithAclTestBase.verifyAllowed(new AccessReadAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessReadAction(this.TEST_TABLE), USER_RO, USER_NONE);
        SnapshotWithAclTestBase.verifyAllowed(new AccessWriteAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessWriteAction(this.TEST_TABLE), USER_RO, USER_NONE);
        TEST_UTIL.getAdmin().disableTable(this.TEST_TABLE);
        this.restoreSnapshot(snapshotName1, true);
        TEST_UTIL.getAdmin().enableTable(this.TEST_TABLE);
        SnapshotWithAclTestBase.verifyAllowed(new AccessReadAction(this.TEST_TABLE), USER_OWNER, USER_RO, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessReadAction(this.TEST_TABLE), USER_NONE);
        SnapshotWithAclTestBase.verifyAllowed(new AccessWriteAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        SnapshotWithAclTestBase.verifyDenied(new AccessWriteAction(this.TEST_TABLE), USER_RO, USER_NONE);
    }

    @Test
    public void testDeleteSnapshot() throws Exception {
        String testSnapshotName = HBaseCommonTestingUtility.getRandomUUID().toString();
        SnapshotWithAclTestBase.verifyAllowed(new AccessSnapshotAction(testSnapshotName), USER_OWNER);
        SnapshotWithAclTestBase.verifyDenied(new AccessSnapshotAction(HBaseCommonTestingUtility.getRandomUUID().toString()), USER_RO, USER_RW, USER_NONE);
        List snapshotDescriptions = TEST_UTIL.getAdmin().listSnapshots(Pattern.compile(testSnapshotName));
        Assert.assertEquals((long)1L, (long)snapshotDescriptions.size());
        Assert.assertEquals((Object)USER_OWNER.getShortName(), (Object)((SnapshotDescription)snapshotDescriptions.get(0)).getOwner());
        SecureTestUtil.AccessTestAction deleteSnapshotAction = () -> {
            try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                 Admin admin = conn.getAdmin();){
                admin.deleteSnapshot(testSnapshotName);
            }
            return null;
        };
        SnapshotWithAclTestBase.verifyDenied(deleteSnapshotAction, USER_RO, USER_RW, USER_NONE);
        SnapshotWithAclTestBase.verifyAllowed(deleteSnapshotAction, USER_OWNER);
        List snapshotsAfterDelete = TEST_UTIL.getAdmin().listSnapshots(Pattern.compile(testSnapshotName));
        Assert.assertEquals((long)0L, (long)snapshotsAfterDelete.size());
    }

    final class AccessSnapshotAction
    implements SecureTestUtil.AccessTestAction {
        private String snapshotName;

        private AccessSnapshotAction(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public Object run() throws Exception {
            try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                 Admin admin = conn.getAdmin();){
                admin.snapshot(this.snapshotName, SnapshotWithAclTestBase.this.TEST_TABLE);
            }
            return null;
        }
    }

    static class AccessWriteAction
    implements SecureTestUtil.AccessTestAction {
        private TableName tableName;

        public AccessWriteAction(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public Object run() throws Exception {
            Put p = new Put(TEST_ROW);
            p.addColumn(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)0));
            try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                 Table t = conn.getTable(this.tableName);){
                t.put(p);
            }
            return null;
        }
    }

    static class AccessReadAction
    implements SecureTestUtil.AccessTestAction {
        private TableName tableName;

        public AccessReadAction(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public Object run() throws Exception {
            Get g = new Get(TEST_ROW);
            g.addFamily(TEST_FAMILY);
            try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                 Table t = conn.getTable(this.tableName);){
                t.get(g);
            }
            return null;
        }
    }
}

