/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestFailedMetaReplicaAssigment {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFailedMetaReplicaAssigment.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.meta.replica.count", 3);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numAlwaysStandByMasters(1).numMasters(1).numRegionServers(1).masterClass(BrokenMetaReplicaMaster.class).build();
        TEST_UTIL.startMiniCluster(option);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFailedReplicaAssignment() throws InterruptedException {
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        TEST_UTIL.waitFor(30000L, () -> master.isInitialized());
        AssignmentManager am = master.getAssignmentManager();
        RegionInfo metaReplicaHri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)1);
        TEST_UTIL.waitFor(30000L, () -> {
            RegionStateNode metaReplicaRegionNode = am.getRegionStates().getOrCreateRegionStateNode(metaReplicaHri);
            return metaReplicaRegionNode.getRegionLocation() != null;
        });
        RegionInfo metaReplicaHri2 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)2);
        RegionStateNode metaReplicaRegionNode2 = am.getRegionStates().getOrCreateRegionStateNode(metaReplicaHri2);
        for (int i = 0; i < 3; ++i) {
            Thread.sleep(2000L);
            Assert.assertNull((Object)metaReplicaRegionNode2.getRegionLocation());
        }
        Assert.assertFalse((boolean)master.isStopping());
        Assert.assertFalse((boolean)master.isStopped());
        Assert.assertTrue((boolean)master.isActiveMaster());
    }

    public static class BrokenMasterMetaAssignmentManager
    extends AssignmentManager {
        MasterServices master;

        public BrokenMasterMetaAssignmentManager(MasterServices master) {
            super(master);
            this.master = master;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransitRegionStateProcedure[] createAssignProcedures(List<RegionInfo> hris) {
            ArrayList<TransitRegionStateProcedure> procs = new ArrayList<TransitRegionStateProcedure>();
            for (RegionInfo hri : hris) {
                if (hri.isMetaRegion() && hri.getReplicaId() == 2) {
                    RegionStateNode regionNode = this.getRegionStates().getOrCreateRegionStateNode(hri);
                    regionNode.lock();
                    try {
                        procs.add(regionNode.setProcedure((TransitRegionStateProcedure)new BrokenTransitRegionStateProcedure((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), hri)));
                        continue;
                    }
                    finally {
                        regionNode.unlock();
                        continue;
                    }
                }
                procs.add(super.createAssignProcedures(Collections.singletonList(hri))[0]);
            }
            return procs.toArray(new TransitRegionStateProcedure[0]);
        }
    }

    public static class BrokenMetaReplicaMaster
    extends HMaster {
        public BrokenMetaReplicaMaster(Configuration conf) throws IOException {
            super(conf);
        }

        public AssignmentManager createAssignmentManager(MasterServices master) {
            return new BrokenMasterMetaAssignmentManager(master);
        }
    }

    public static class BrokenTransitRegionStateProcedure
    extends TransitRegionStateProcedure {
        public BrokenTransitRegionStateProcedure() {
            super(null, null, null, false, TransitRegionStateProcedure.TransitionType.ASSIGN);
        }

        public BrokenTransitRegionStateProcedure(MasterProcedureEnv env, RegionInfo hri) {
            super(env, hri, null, false, TransitRegionStateProcedure.TransitionType.ASSIGN);
        }

        protected Procedure[] execute(MasterProcedureEnv env) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
            throw new ProcedureSuspendedException("Never end procedure!");
        }
    }
}

