/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionRemoteProcedureBase;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSCPGetRegionsRace {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSCPGetRegionsRace.class);
    private static final List<ServerName> EXCLUDE_SERVERS = new ArrayList<ServerName>();
    private static CountDownLatch ARRIVE_REPORT;
    private static CountDownLatch RESUME_REPORT;
    private static CountDownLatch ARRIVE_GET;
    private static CountDownLatch RESUME_GET;
    private static final HBaseTestingUtility UTIL;
    private static TableName NAME;
    private static byte[] CF;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(StartMiniClusterOption.builder().masterClass(HMasterForTest.class).numMasters(1).numRegionServers(3).build());
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        RegionInfo region = ((HRegion)Iterables.getOnlyElement(UTIL.getMiniHBaseCluster().getRegions(NAME))).getRegionInfo();
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        RegionStateNode rsn = am.getRegionStates().getRegionStateNode(region);
        ServerName source = rsn.getRegionLocation();
        ServerName dest = UTIL.getAdmin().getRegionServers().stream().filter(sn -> !sn.equals((Object)source)).findAny().get();
        ARRIVE_REPORT = new CountDownLatch(1);
        RESUME_REPORT = new CountDownLatch(1);
        Future future = am.moveAsync(new RegionPlan(region, source, dest));
        ARRIVE_REPORT.await();
        ARRIVE_REPORT = null;
        IdLock procExecutionLock = master.getMasterProcedureExecutor().getProcExecutionLock();
        long procId = master.getProcedures().stream().filter(p -> p instanceof RegionRemoteProcedureBase).findAny().get().getProcId();
        IdLock.Entry lockEntry = procExecutionLock.getLockEntry(procId);
        RESUME_REPORT.countDown();
        ARRIVE_GET = new CountDownLatch(1);
        RESUME_GET = new CountDownLatch(1);
        UTIL.getMiniHBaseCluster().killRegionServer(source);
        ARRIVE_GET.await();
        ARRIVE_GET = null;
        procExecutionLock.releaseLockEntry(lockEntry);
        future.get();
        EXCLUDE_SERVERS.add(dest);
        RESUME_GET.countDown();
        UTIL.waitFor(60000L, () -> master.getProcedures().stream().allMatch(p -> p.isFinished() || !(p instanceof ServerCrashProcedure) && !(p instanceof TransitRegionStateProcedure)));
        HRegionServer rs = UTIL.getMiniHBaseCluster().getRegionServer(dest);
        Assert.assertNotNull((Object)rs.getRegion(region.getEncodedName()));
        Assert.assertNull((Object)UTIL.getOtherRegionServer(rs).getRegion(region.getEncodedName()));
    }

    static {
        UTIL = new HBaseTestingUtility();
        NAME = TableName.valueOf((String)"Assign");
        CF = Bytes.toBytes((String)"cf");
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master) {
            return new AssignmentManagerForTest(master);
        }

        protected ServerManager createServerManager(MasterServices master) throws IOException {
            this.setupClusterConnection();
            return new ServerManagerForTest(master);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master) {
            super(master);
        }

        public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
            if (req.getTransition(0).getTransitionCode() == RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED && ARRIVE_REPORT != null) {
                ARRIVE_REPORT.countDown();
                try {
                    RESUME_REPORT.await();
                    RESUME_REPORT = null;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.reportRegionStateTransition(req);
        }

        public List<RegionInfo> getRegionsOnServer(ServerName serverName) {
            List regions = super.getRegionsOnServer(serverName);
            if (ARRIVE_GET != null) {
                ARRIVE_GET.countDown();
                try {
                    RESUME_GET.await();
                    RESUME_GET = null;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return regions;
        }
    }

    private static final class ServerManagerForTest
    extends ServerManager {
        public ServerManagerForTest(MasterServices master) {
            super(master);
        }

        public List<ServerName> createDestinationServersList() {
            return super.createDestinationServersList(EXCLUDE_SERVERS);
        }
    }
}

