/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedure.class);
    ProcedureCoordinator coord;

    @Before
    public void setup() {
        this.coord = (ProcedureCoordinator)Mockito.mock(ProcedureCoordinator.class);
        ProcedureCoordinatorRpcs comms = (ProcedureCoordinatorRpcs)Mockito.mock(ProcedureCoordinatorRpcs.class);
        Mockito.when((Object)this.coord.getRpcs()).thenReturn((Object)comms);
    }

    @Test
    public void testSingleMember() throws Exception {
        ArrayList<String> members = new ArrayList<String>();
        members.add("member");
        LatchedProcedure proc = new LatchedProcedure(this.coord, new ForeignExceptionDispatcher(), 100L, Integer.MAX_VALUE, "op", null, members);
        final LatchedProcedure procspy = (LatchedProcedure)((Object)Mockito.spy((Object)((Object)proc)));
        new Thread(){

            @Override
            public void run() {
                procspy.call();
            }
        }.start();
        proc.startedAcquireBarrier.await();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierStart();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).sendGlobalBarrierReached();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).sendGlobalBarrierComplete();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).barrierAcquiredByMember(Matchers.anyString());
        proc.barrierAcquiredByMember((String)members.get(0));
        proc.acquiredBarrierLatch.await();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierStart();
        proc.barrierReleasedByMember((String)members.get(0), new byte[0]);
        proc.completedProcedure.await();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierReached();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierComplete();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).receive((ForeignException)((Object)Matchers.any()));
    }

    @Test
    public void testMultipleMember() throws Exception {
        ArrayList<String> members = new ArrayList<String>();
        members.add("member1");
        members.add("member2");
        LatchedProcedure proc = new LatchedProcedure(this.coord, new ForeignExceptionDispatcher(), 100L, Integer.MAX_VALUE, "op", null, members);
        final LatchedProcedure procspy = (LatchedProcedure)((Object)Mockito.spy((Object)((Object)proc)));
        new Thread(){

            @Override
            public void run() {
                procspy.call();
            }
        }.start();
        procspy.startedAcquireBarrier.await();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierStart();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).sendGlobalBarrierReached();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).sendGlobalBarrierComplete();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).barrierAcquiredByMember(Matchers.anyString());
        procspy.barrierAcquiredByMember((String)members.get(0));
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierStart();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).sendGlobalBarrierReached();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).sendGlobalBarrierComplete();
        procspy.barrierAcquiredByMember((String)members.get(1));
        procspy.startedDuringBarrier.await();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierStart();
        procspy.barrierReleasedByMember((String)members.get(0), new byte[0]);
        procspy.barrierReleasedByMember((String)members.get(1), new byte[0]);
        procspy.completedProcedure.await();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierReached();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierComplete();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).receive((ForeignException)((Object)Matchers.any()));
    }

    @Test
    public void testErrorPropagation() throws Exception {
        ArrayList<String> members = new ArrayList<String>();
        members.add("member");
        Procedure proc = new Procedure(this.coord, new ForeignExceptionDispatcher(), 100L, Integer.MAX_VALUE, "op", null, members);
        final Procedure procspy = (Procedure)Mockito.spy((Object)proc);
        ForeignException cause = new ForeignException("SRC", "External Exception");
        proc.receive(cause);
        Thread t = new Thread(){

            @Override
            public void run() {
                procspy.call();
            }
        };
        t.start();
        t.join();
        ((Procedure)Mockito.verify((Object)procspy, (VerificationMode)Mockito.never())).sendGlobalBarrierStart();
        ((Procedure)Mockito.verify((Object)procspy, (VerificationMode)Mockito.never())).sendGlobalBarrierReached();
        ((Procedure)Mockito.verify((Object)procspy)).sendGlobalBarrierComplete();
    }

    @Test
    public void testBarrieredErrorPropagation() throws Exception {
        ArrayList<String> members = new ArrayList<String>();
        members.add("member");
        LatchedProcedure proc = new LatchedProcedure(this.coord, new ForeignExceptionDispatcher(), 100L, Integer.MAX_VALUE, "op", null, members);
        final LatchedProcedure procspy = (LatchedProcedure)((Object)Mockito.spy((Object)((Object)proc)));
        Thread t = new Thread(){

            @Override
            public void run() {
                procspy.call();
            }
        };
        t.start();
        procspy.startedAcquireBarrier.await();
        ForeignException cause = new ForeignException("SRC", "External Exception");
        procspy.receive(cause);
        procspy.barrierAcquiredByMember((String)members.get(0));
        t.join();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierStart();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy)))).sendGlobalBarrierComplete();
        ((LatchedProcedure)((Object)Mockito.verify((Object)((Object)procspy), (VerificationMode)Mockito.never()))).sendGlobalBarrierReached();
    }

    static class LatchedProcedure
    extends Procedure {
        CountDownLatch startedAcquireBarrier = new CountDownLatch(1);
        CountDownLatch startedDuringBarrier = new CountDownLatch(1);
        CountDownLatch completedProcedure = new CountDownLatch(1);

        public LatchedProcedure(ProcedureCoordinator coord, ForeignExceptionDispatcher monitor, long wakeFreq, long timeout, String opName, byte[] data, List<String> expectedMembers) {
            super(coord, monitor, wakeFreq, timeout, opName, data, expectedMembers);
        }

        public void sendGlobalBarrierStart() {
            this.startedAcquireBarrier.countDown();
        }

        public void sendGlobalBarrierReached() {
            this.startedDuringBarrier.countDown();
        }

        public void sendGlobalBarrierComplete() {
            this.completedProcedure.countDown();
        }
    }
}

