/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.mock.MockNamespace;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.hadoop.io.Text;

@Deprecated
public class MockTable {
    final SortedMap<Key, Value> table = new ConcurrentSkipListMap<Key, Value>();
    int mutationCount = 0;
    final Map<String, String> settings;
    Map<String, EnumSet<TablePermission>> userPermissions = new HashMap<String, EnumSet<TablePermission>>();
    private TimeType timeType;
    SortedSet<Text> splits = new ConcurrentSkipListSet<Text>();
    Map<String, Set<Text>> localityGroups = new TreeMap<String, Set<Text>>();
    private MockNamespace namespace;
    private String namespaceName;
    private String tableId;

    MockTable(boolean limitVersion, TimeType timeType, String tableId) {
        this.timeType = timeType;
        this.tableId = tableId;
        this.settings = IteratorUtil.generateInitialTableProperties(limitVersion);
        for (Map.Entry<String, String> entry : AccumuloConfiguration.getDefaultConfiguration()) {
            String key = entry.getKey();
            if (!key.startsWith(Property.TABLE_PREFIX.getKey())) continue;
            this.settings.put(key, entry.getValue());
        }
    }

    MockTable(MockNamespace namespace, boolean limitVersion, TimeType timeType, String tableId, Map<String, String> properties) {
        this(limitVersion, timeType, tableId);
        Set<Map.Entry<String, String>> set = namespace.settings.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            if (!key.startsWith(Property.TABLE_PREFIX.getKey())) continue;
            this.settings.put(key, entry.getValue());
        }
        for (Map.Entry<String, String> initialProp : properties.entrySet()) {
            this.settings.put(initialProp.getKey(), initialProp.getValue());
        }
    }

    public MockTable(MockNamespace namespace, TimeType timeType, String tableId, Map<String, String> properties) {
        this.timeType = timeType;
        this.tableId = tableId;
        this.settings = properties;
        for (Map.Entry<String, String> entry : AccumuloConfiguration.getDefaultConfiguration()) {
            String key = entry.getKey();
            if (!key.startsWith(Property.TABLE_PREFIX.getKey())) continue;
            this.settings.put(key, entry.getValue());
        }
        Set<Map.Entry<String, String>> set = namespace.settings.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            if (!key.startsWith(Property.TABLE_PREFIX.getKey())) continue;
            this.settings.put(key, entry.getValue());
        }
    }

    synchronized void addMutation(Mutation m) {
        if (m.size() == 0) {
            throw new IllegalArgumentException("Can not add empty mutations");
        }
        long now = System.currentTimeMillis();
        ++this.mutationCount;
        for (ColumnUpdate u : m.getUpdates()) {
            Key key = new Key(m.getRow(), 0, m.getRow().length, u.getColumnFamily(), 0, u.getColumnFamily().length, u.getColumnQualifier(), 0, u.getColumnQualifier().length, u.getColumnVisibility(), 0, u.getColumnVisibility().length, u.getTimestamp());
            if (u.isDeleted()) {
                key.setDeleted(true);
            }
            if (!u.hasTimestamp()) {
                if (this.timeType.equals((Object)TimeType.LOGICAL)) {
                    key.setTimestamp(this.mutationCount);
                } else {
                    key.setTimestamp(now);
                }
            }
            this.table.put(new MockMemKey(key, this.mutationCount), new Value(u.getValue()));
        }
    }

    public void addSplits(SortedSet<Text> partitionKeys) {
        this.splits.addAll(partitionKeys);
    }

    public Collection<Text> getSplits() {
        return this.splits;
    }

    public void setLocalityGroups(Map<String, Set<Text>> groups) {
        this.localityGroups = groups;
    }

    public Map<String, Set<Text>> getLocalityGroups() {
        return this.localityGroups;
    }

    public void merge(Text start, Text end) {
        boolean reAdd = false;
        if (this.splits.contains(start)) {
            reAdd = true;
        }
        this.splits.removeAll(this.splits.subSet(start, end));
        if (reAdd) {
            this.splits.add(start);
        }
    }

    public void setNamespaceName(String n) {
        this.namespaceName = n;
    }

    public void setNamespace(MockNamespace n) {
        this.namespace = n;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public MockNamespace getNamespace() {
        return this.namespace;
    }

    public String getTableId() {
        return this.tableId;
    }

    static class MockMemKey
    extends Key {
        private int count;

        MockMemKey(Key key, int count) {
            super(key);
            this.count = count;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.count;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof MockMemKey && super.equals(other) && this.count == ((MockMemKey)other).count;
        }

        @Override
        public String toString() {
            return super.toString() + " count=" + this.count;
        }

        @Override
        public int compareTo(Key o) {
            int compare = super.compareTo(o);
            if (compare != 0) {
                return compare;
            }
            if (o instanceof MockMemKey) {
                MockMemKey other = (MockMemKey)o;
                if (this.count < other.count) {
                    return 1;
                }
                if (this.count > other.count) {
                    return -1;
                }
            } else {
                return 1;
            }
            return 0;
        }
    }
}

