/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverter;

public final class FSQueueConverterBuilder {
    FSConfigToCSConfigRuleHandler ruleHandler;
    Configuration capacitySchedulerConfig;
    boolean preemptionEnabled;
    boolean sizeBasedWeight;
    boolean autoCreateChildQueues;
    Resource clusterResource;
    float queueMaxAMShareDefault;
    int queueMaxAppsDefault;
    ConversionOptions conversionOptions;
    boolean drfUsed;

    private FSQueueConverterBuilder() {
    }

    public static FSQueueConverterBuilder create() {
        return new FSQueueConverterBuilder();
    }

    public FSQueueConverterBuilder withRuleHandler(FSConfigToCSConfigRuleHandler ruleHandler) {
        this.ruleHandler = ruleHandler;
        return this;
    }

    public FSQueueConverterBuilder withCapacitySchedulerConfig(Configuration config) {
        this.capacitySchedulerConfig = config;
        return this;
    }

    public FSQueueConverterBuilder withPreemptionEnabled(boolean preemptionEnabled) {
        this.preemptionEnabled = preemptionEnabled;
        return this;
    }

    public FSQueueConverterBuilder withSizeBasedWeight(boolean sizeBasedWeight) {
        this.sizeBasedWeight = sizeBasedWeight;
        return this;
    }

    public FSQueueConverterBuilder withAutoCreateChildQueues(boolean autoCreateChildQueues) {
        this.autoCreateChildQueues = autoCreateChildQueues;
        return this;
    }

    public FSQueueConverterBuilder withClusterResource(Resource resource) {
        this.clusterResource = resource;
        return this;
    }

    public FSQueueConverterBuilder withQueueMaxAMShareDefault(float queueMaxAMShareDefault) {
        this.queueMaxAMShareDefault = queueMaxAMShareDefault;
        return this;
    }

    public FSQueueConverterBuilder withQueueMaxAppsDefault(int queueMaxAppsDefault) {
        this.queueMaxAppsDefault = queueMaxAppsDefault;
        return this;
    }

    public FSQueueConverterBuilder withConversionOptions(ConversionOptions conversionOptions) {
        this.conversionOptions = conversionOptions;
        return this;
    }

    public FSQueueConverterBuilder withDrfUsed(boolean drfUsed) {
        this.drfUsed = drfUsed;
        return this;
    }

    public FSQueueConverter build() {
        return new FSQueueConverter(this);
    }
}

