/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Collection;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.volume.Volume;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public interface VolumeManager {
    public void close() throws IOException;

    public FSDataOutputStream create(Path var1) throws IOException;

    public FSDataOutputStream create(Path var1, boolean var2) throws IOException;

    public FSDataOutputStream create(Path var1, boolean var2, int var3, short var4, long var5) throws IOException;

    public boolean createNewFile(Path var1) throws IOException;

    public FSDataOutputStream createSyncable(Path var1, int var2, short var3, long var4) throws IOException;

    public boolean delete(Path var1) throws IOException;

    public boolean deleteRecursively(Path var1) throws IOException;

    public boolean exists(Path var1) throws IOException;

    public FileStatus getFileStatus(Path var1) throws IOException;

    public Volume getVolumeByPath(Path var1);

    public Path matchingFileSystem(Path var1, String[] var2);

    public FileStatus[] listStatus(Path var1) throws IOException;

    public boolean mkdirs(Path var1) throws IOException;

    public boolean mkdirs(Path var1, FsPermission var2) throws IOException;

    public FSDataInputStream open(Path var1) throws IOException;

    public boolean rename(Path var1, Path var2) throws IOException;

    public boolean moveToTrash(Path var1) throws IOException;

    public short getDefaultReplication(Path var1);

    public boolean isFile(Path var1) throws IOException;

    public boolean isReady() throws IOException;

    public FileStatus[] globStatus(Path var1) throws IOException;

    public Path getFullPath(Key var1);

    public Path getFullPath(String var1, String var2);

    public Path getFullPath(FileType var1, String var2) throws IOException;

    public ContentSummary getContentSummary(Path var1) throws IOException;

    @SuppressModernizer
    public String choose(Optional<String> var1, String[] var2);

    public Volume getDefaultVolume();

    public Collection<Volume> getVolumes();

    public static enum FileType {
        TABLE("tables"),
        WAL("wal"),
        RECOVERY("recovery");

        private String dir;

        private FileType(String dir) {
            this.dir = dir;
        }

        public String getDirectory() {
            return this.dir;
        }

        private static int endOfVolumeIndex(String path, String dir) {
            int dirIndex = path.indexOf('/' + dir);
            if (dirIndex != -1) {
                return dirIndex;
            }
            if (path.contains(":")) {
                throw new IllegalArgumentException(path + " is absolute, but does not contain " + dir);
            }
            return -1;
        }

        public Path getVolume(Path path) {
            String pathString = path.toString();
            int eopi = FileType.endOfVolumeIndex(pathString, this.dir);
            if (eopi != -1) {
                return new Path(pathString.substring(0, eopi + 1));
            }
            return null;
        }

        public Path removeVolume(Path path) {
            String pathString = path.toString();
            int eopi = FileType.endOfVolumeIndex(pathString, this.dir);
            if (eopi != -1) {
                return new Path(pathString.substring(eopi + 1));
            }
            return null;
        }
    }
}

