/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.rpc.UGIAssumingProcessor;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.security.UserImpersonation;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKAuthenticator;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticator
implements Authenticator {
    private static final Logger log = LoggerFactory.getLogger(KerberosAuthenticator.class);
    private static final Set<Class<? extends AuthenticationToken>> SUPPORTED_TOKENS = Sets.newHashSet(Arrays.asList(KerberosToken.class, SystemCredentials.SystemToken.class));
    private static final Set<String> SUPPORTED_TOKEN_NAMES = Sets.newHashSet((Object[])new String[]{KerberosToken.class.getName(), SystemCredentials.SystemToken.class.getName()});
    private final ZKAuthenticator zkAuthenticator = new ZKAuthenticator();
    private String zkUserPath;
    private final ZooCache zooCache;
    private final UserImpersonation impersonation;

    public KerberosAuthenticator() {
        this(new ZooCache(), (AccumuloConfiguration)SiteConfiguration.getInstance());
    }

    public KerberosAuthenticator(ZooCache cache, AccumuloConfiguration conf) {
        this.zooCache = cache;
        this.impersonation = new UserImpersonation(conf);
    }

    @Override
    public void initialize(String instanceId, boolean initialize) {
        this.zkAuthenticator.initialize(instanceId, initialize);
        this.zkUserPath = "/accumulo/" + instanceId + "/users";
    }

    @Override
    public boolean validSecurityHandlers(Authorizor auth, PermissionHandler pm) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createUserNodeInZk(String principal) throws KeeperException, InterruptedException {
        ZooCache zooCache = this.zooCache;
        synchronized (zooCache) {
            this.zooCache.clear();
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            zoo.putPrivatePersistentData(this.zkUserPath + "/" + principal, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSecurity(TCredentials credentials, String principal, byte[] token) throws AccumuloSecurityException, ThriftSecurityException {
        try {
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                if (zoo.exists(this.zkUserPath)) {
                    zoo.recursiveDelete(this.zkUserPath, ZooUtil.NodeMissingPolicy.SKIP);
                    log.info("Removed " + this.zkUserPath + "/ from zookeeper");
                }
                byte[] principalData = principal.getBytes(StandardCharsets.UTF_8);
                zoo.putPersistentData(this.zkUserPath, principalData, ZooUtil.NodeExistsPolicy.FAIL);
                this.createUserNodeInZk(Base64.getEncoder().encodeToString(principalData));
            }
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Failed to initialize security", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean authenticateUser(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        String rpcPrincipal = UGIAssumingProcessor.rpcPrincipal();
        if (!rpcPrincipal.equals(principal)) {
            UserImpersonation.UsersWithHosts usersWithHosts = this.impersonation.get(rpcPrincipal);
            if (null == usersWithHosts) {
                throw new AccumuloSecurityException(principal, SecurityErrorCode.AUTHENTICATOR_FAILED);
            }
            if (!usersWithHosts.getUsers().contains(principal)) {
                throw new AccumuloSecurityException(principal, SecurityErrorCode.AUTHENTICATOR_FAILED);
            }
            log.debug("Allowing impersonation of {} by {}", (Object)principal, (Object)rpcPrincipal);
        }
        return token instanceof KerberosToken || token instanceof DelegationTokenImpl;
    }

    @Override
    public Set<String> listUsers() throws AccumuloSecurityException {
        Set<String> base64Users = this.zkAuthenticator.listUsers();
        HashSet<String> readableUsers = new HashSet<String>();
        for (String base64User : base64Users) {
            readableUsers.add(new String(Base64.getDecoder().decode(base64User), StandardCharsets.UTF_8));
        }
        return readableUsers;
    }

    @Override
    public synchronized void createUser(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        if (!(token instanceof KerberosToken)) {
            throw new UnsupportedOperationException("Expected a KerberosToken but got a " + token.getClass().getSimpleName());
        }
        try {
            this.createUserNodeInZk(Base64.getEncoder().encodeToString(principal.getBytes(StandardCharsets.UTF_8)));
        }
        catch (KeeperException e) {
            if (e.code().equals((Object)KeeperException.Code.NODEEXISTS)) {
                throw new AccumuloSecurityException(principal, SecurityErrorCode.USER_EXISTS, (Throwable)e);
            }
            log.error("Failed to create user in ZooKeeper", (Throwable)e);
            throw new AccumuloSecurityException(principal, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("Interrupted trying to create node for user", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void dropUser(String user) throws AccumuloSecurityException {
        String encodedUser = Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8));
        try {
            this.zkAuthenticator.dropUser(encodedUser);
        }
        catch (AccumuloSecurityException e) {
            throw new AccumuloSecurityException(user, e.asThriftException().getCode(), e.getCause());
        }
    }

    @Override
    public void changePassword(String principal, AuthenticationToken token) throws AccumuloSecurityException {
        throw new UnsupportedOperationException("Cannot change password with Kerberos authenticaton");
    }

    @Override
    public synchronized boolean userExists(String user) throws AccumuloSecurityException {
        user = Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8));
        return this.zkAuthenticator.userExists(user);
    }

    @Override
    public Set<Class<? extends AuthenticationToken>> getSupportedTokenTypes() {
        return SUPPORTED_TOKENS;
    }

    @Override
    public boolean validTokenClass(String tokenClass) {
        return SUPPORTED_TOKEN_NAMES.contains(tokenClass);
    }
}

