/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttleImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExcept;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIntersect;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRelOpMaterializationValidator
extends HiveRelShuttleImpl {
    static final Logger LOG = LoggerFactory.getLogger(HiveRelOpMaterializationValidator.class);
    protected String invalidMaterializationReason;

    public void validateQueryMaterialization(RelNode relNode) {
        try {
            relNode.accept((RelShuttle)this);
        }
        catch (Util.FoundOne foundOne) {
            // empty catch block
        }
    }

    @Override
    public RelNode visit(TableScan scan) {
        if (scan instanceof HiveTableScan) {
            HiveTableScan hiveScan = (HiveTableScan)scan;
            RelOptHiveTable relOptHiveTable = (RelOptHiveTable)hiveScan.getTable();
            Table tab = relOptHiveTable.getHiveTableMD();
            if (tab.isTemporary()) {
                this.fail(tab.getTableName() + " is a temporary table");
            }
            TableType tt = tab.getTableType();
            if (tab.getTableType() == TableType.EXTERNAL_TABLE) {
                this.fail(tab.getFullyQualifiedName() + " is an external table");
            }
            return scan;
        }
        this.fail(scan.getTable().getQualifiedName() + " is a table scan of a non-Hive table.");
        return scan;
    }

    @Override
    public RelNode visit(HiveProject project) {
        for (RexNode expr : project.getProjects()) {
            this.checkExpr(expr);
        }
        return super.visit(project);
    }

    @Override
    public RelNode visit(HiveFilter filter) {
        this.checkExpr(filter.getCondition());
        return super.visit(filter);
    }

    @Override
    public RelNode visit(HiveJoin join) {
        this.checkExpr(join.getCondition());
        return super.visit(join);
    }

    @Override
    public RelNode visit(HiveAggregate aggregate) {
        return super.visit(aggregate);
    }

    @Override
    public RelNode visit(RelNode node) {
        if (node instanceof HiveUnion) {
            return this.visit((HiveUnion)node);
        }
        if (node instanceof HiveSortLimit) {
            return this.visit((HiveSortLimit)node);
        }
        if (node instanceof HiveSemiJoin) {
            return this.visit((HiveSemiJoin)node);
        }
        if (node instanceof HiveExcept) {
            return this.visit((HiveExcept)node);
        }
        if (node instanceof HiveIntersect) {
            return this.visit((HiveIntersect)node);
        }
        return this.fail(node);
    }

    @Override
    public RelNode visit(TableFunctionScan scan) {
        this.checkExpr(scan.getCall());
        return super.visit(scan);
    }

    @Override
    public RelNode visit(LogicalValues values) {
        return this.fail((RelNode)values);
    }

    @Override
    public RelNode visit(LogicalFilter filter) {
        return this.fail((RelNode)filter);
    }

    @Override
    public RelNode visit(LogicalProject project) {
        return this.fail((RelNode)project);
    }

    @Override
    public RelNode visit(LogicalJoin join) {
        return this.fail((RelNode)join);
    }

    @Override
    public RelNode visit(LogicalCorrelate correlate) {
        return this.fail((RelNode)correlate);
    }

    @Override
    public RelNode visit(LogicalUnion union) {
        return this.fail((RelNode)union);
    }

    @Override
    public RelNode visit(LogicalIntersect intersect) {
        return this.fail((RelNode)intersect);
    }

    @Override
    public RelNode visit(LogicalMinus minus) {
        return this.fail((RelNode)minus);
    }

    @Override
    public RelNode visit(LogicalAggregate aggregate) {
        return this.fail((RelNode)aggregate);
    }

    @Override
    public RelNode visit(LogicalMatch match) {
        return this.fail((RelNode)match);
    }

    @Override
    public RelNode visit(LogicalSort sort) {
        return this.fail((RelNode)sort);
    }

    @Override
    public RelNode visit(LogicalExchange exchange) {
        return this.fail((RelNode)exchange);
    }

    private RelNode visit(HiveUnion union) {
        return this.visitChildren(union);
    }

    private RelNode visit(HiveSortLimit sort) {
        this.checkExpr(sort.getFetchExpr());
        this.checkExpr(sort.getOffsetExpr());
        return this.visitChildren(sort);
    }

    private RelNode visit(HiveSemiJoin semiJoin) {
        this.checkExpr(semiJoin.getCondition());
        this.checkExpr(semiJoin.getJoinFilter());
        return this.visitChildren(semiJoin);
    }

    private RelNode visit(HiveExcept except) {
        return this.visitChildren((RelNode)except);
    }

    private RelNode visit(HiveIntersect intersect) {
        return this.visitChildren((RelNode)intersect);
    }

    private void fail(String reason) {
        this.setInvalidMaterializationReason(reason);
        throw Util.FoundOne.NULL;
    }

    private RelNode fail(RelNode node) {
        this.setInvalidMaterializationReason("Unsupported RelNode type " + node.getRelTypeName() + " encountered in the query plan");
        throw Util.FoundOne.NULL;
    }

    private void checkExpr(RexNode expr) {
        RexCall invalidCall = HiveCalciteUtil.checkMaterializable(expr);
        if (invalidCall != null) {
            this.fail(invalidCall.getOperator().getName() + " is not a deterministic function");
        }
    }

    public String getInvalidMaterializationReason() {
        return this.invalidMaterializationReason;
    }

    public void setInvalidMaterializationReason(String invalidMaterializationReason) {
        this.invalidMaterializationReason = invalidMaterializationReason;
    }

    public boolean isValidMaterialization() {
        return this.invalidMaterializationReason == null;
    }
}

