/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="sha1,sha", value="_FUNC_(str or bin) - Calculates the SHA-1 digest for string or binary and returns the value as a hex string.", extended="Example:\n  > SELECT _FUNC_('ABC');\n  '3c01bdbb26f358bab27f267924aa2c9a03fcfdb8'\n  > SELECT _FUNC_(binary('ABC'));\n  '3c01bdbb26f358bab27f267924aa2c9a03fcfdb8'")
public class UDFSha1
extends UDF {
    private final Text result = new Text();
    private final MessageDigest digest;

    public UDFSha1() {
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public Text evaluate(Text n) {
        if (n == null) {
            return null;
        }
        this.digest.reset();
        this.digest.update(n.getBytes(), 0, n.getLength());
        byte[] shaBytes = this.digest.digest();
        String shaHex = Hex.encodeHexString((byte[])shaBytes);
        this.result.set(shaHex);
        return this.result;
    }

    public Text evaluate(BytesWritable b) {
        if (b == null) {
            return null;
        }
        this.digest.reset();
        this.digest.update(b.getBytes(), 0, b.getLength());
        byte[] shaBytes = this.digest.digest();
        String shaHex = Hex.encodeHexString((byte[])shaBytes);
        this.result.set(shaHex);
        return this.result;
    }
}

