/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannelManager;
import org.apache.bookkeeper.clients.impl.internal.ProtocolInternalUtils;
import org.apache.bookkeeper.clients.impl.internal.api.HashStreamRanges;
import org.apache.bookkeeper.clients.impl.internal.api.MetaRangeClient;
import org.apache.bookkeeper.clients.impl.internal.mr.MetaRangeRequestProcessor;
import org.apache.bookkeeper.clients.utils.ClientConstants;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.protocol.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaRangeClientImpl
implements MetaRangeClient {
    private static final Logger log = LoggerFactory.getLogger(MetaRangeClientImpl.class);
    private final StreamProperties streamProps;
    private final ScheduledExecutorService executor;
    private final StorageContainerChannel scClient;
    private final Backoff.Policy backoffPolicy;

    MetaRangeClientImpl(StreamProperties streamProps, OrderedScheduler scheduler, StorageContainerChannelManager channelManager) {
        this(streamProps, scheduler, channelManager, ClientConstants.DEFAULT_INFINIT_BACKOFF_POLICY);
    }

    MetaRangeClientImpl(StreamProperties streamProps, OrderedScheduler scheduler, StorageContainerChannelManager channelManager, Backoff.Policy backoffPolicy) {
        this.streamProps = streamProps;
        this.executor = scheduler.chooseThread(streamProps.getStreamId());
        this.scClient = channelManager.getOrCreate(streamProps.getStorageContainerId());
        this.backoffPolicy = backoffPolicy;
    }

    @Override
    public StreamProperties getStreamProps() {
        return this.streamProps;
    }

    StorageContainerChannel getStorageContainerClient() {
        return this.scClient;
    }

    @Override
    public CompletableFuture<HashStreamRanges> getActiveDataRanges() {
        return MetaRangeRequestProcessor.of(ProtoUtils.createGetActiveRangesRequest((StreamProperties)this.streamProps), response -> ProtocolInternalUtils.createActiveRanges(response), this.scClient, this.executor, this.backoffPolicy).process();
    }
}

