/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.impl.EntryImpl;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherSingleActiveConsumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.impl.RawMessageImpl;
import org.apache.pulsar.common.api.proto.MessageIdData;
import org.apache.pulsar.compaction.CompactedTopic;
import org.apache.pulsar.compaction.CompactedTopicContext;
import org.apache.pulsar.compaction.Compactor;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactedTopicImpl
implements CompactedTopic {
    static final long NEWER_THAN_COMPACTED = -4276948922L;
    static final long COMPACT_LEDGER_EMPTY = -4276948923L;
    static final int DEFAULT_MAX_CACHE_SIZE = 100;
    private final BookKeeper bk;
    private volatile Position compactionHorizon = null;
    private volatile CompletableFuture<CompactedTopicContext> compactedTopicContext = null;
    private static final Logger log = LoggerFactory.getLogger(CompactedTopicImpl.class);

    public CompactedTopicImpl(BookKeeper bk) {
        this.bk = bk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<CompactedTopicContext> newCompactedLedger(Position p, long compactedLedgerId) {
        CompactedTopicImpl compactedTopicImpl = this;
        synchronized (compactedTopicImpl) {
            CompletableFuture<CompactedTopicContext> previousContext = this.compactedTopicContext;
            this.compactedTopicContext = CompactedTopicImpl.openCompactedLedger(this.bk, compactedLedgerId);
            this.compactionHorizon = p;
            return this.compactedTopicContext.thenCompose(ctx -> {
                if (previousContext != null) {
                    previousContext.thenAccept(previousCtx -> {
                        if (previousCtx != null && previousCtx.getLedger() != null && previousCtx.getLedger().getId() == compactedLedgerId) {
                            log.error("[__compaction] Using the same compacted ledger to override the old one, which is not expected and it may cause a ledger lost error. {} -> {}", (Object)compactedLedgerId, (Object)ctx.getLedger().getId());
                        }
                    });
                    return previousContext;
                }
                return CompletableFuture.completedFuture(null);
            });
        }
    }

    @Override
    public CompletableFuture<Void> deleteCompactedLedger(long compactedLedgerId) {
        return CompactedTopicImpl.tryDeleteCompactedLedger(this.bk, compactedLedgerId);
    }

    @Override
    @Deprecated
    public void asyncReadEntriesOrWait(ManagedCursor cursor, int maxEntries, long bytesToRead, Position maxReadPosition, boolean isFirstRead, AsyncCallbacks.ReadEntriesCallback callback, Consumer consumer) {
        boolean readFromEarliest = isFirstRead && MessageId.earliest.equals(consumer.getStartMessageId()) && (!cursor.isDurable() || cursor.getName().equals("__compaction") || cursor.getMarkDeletedPosition() == null || cursor.getMarkDeletedPosition().getEntryId() == -1L);
        Position cursorPosition = readFromEarliest ? PositionFactory.EARLIEST : cursor.getReadPosition();
        PersistentDispatcherSingleActiveConsumer.ReadEntriesCtx readEntriesCtx = PersistentDispatcherSingleActiveConsumer.ReadEntriesCtx.create(consumer, -1L);
        Position currentCompactionHorizon = this.compactionHorizon;
        if (currentCompactionHorizon == null || currentCompactionHorizon.compareTo(cursorPosition) < 0) {
            cursor.asyncReadEntriesOrWait(maxEntries, bytesToRead, callback, (Object)readEntriesCtx, maxReadPosition);
        } else {
            int numberOfEntriesToRead = cursor.applyMaxSizeCap(maxEntries, bytesToRead);
            ((CompletableFuture)this.compactedTopicContext.thenCompose(context -> CompactedTopicImpl.findStartPoint(cursorPosition, context.ledger.getLastAddConfirmed(), context.cache).thenCompose(startPoint -> {
                if (startPoint == -4276948923L || startPoint == -4276948922L) {
                    cursor.seek(currentCompactionHorizon.getNext());
                    callback.readEntriesComplete(Collections.emptyList(), (Object)readEntriesCtx);
                    return CompletableFuture.completedFuture(null);
                }
                long endPoint = Math.min(context.ledger.getLastAddConfirmed(), startPoint + (long)(numberOfEntriesToRead - 1));
                return CompactedTopicImpl.readEntries(context.ledger, startPoint, endPoint).thenAccept(entries -> {
                    long entriesSize = 0L;
                    for (Entry entry : entries) {
                        entriesSize += (long)entry.getLength();
                    }
                    cursor.updateReadStats(entries.size(), entriesSize);
                    Entry lastEntry = (Entry)entries.get(entries.size() - 1);
                    cursor.seek(lastEntry.getPosition().getNext(), true);
                    callback.readEntriesComplete(entries, (Object)readEntriesCtx);
                });
            }))).exceptionally(exception -> {
                if (exception.getCause() instanceof NoSuchElementException) {
                    cursor.seek(currentCompactionHorizon.getNext());
                    callback.readEntriesComplete(Collections.emptyList(), (Object)readEntriesCtx);
                } else {
                    callback.readEntriesFailed(new ManagedLedgerException(exception), (Object)readEntriesCtx);
                }
                return null;
            });
        }
    }

    static CompletableFuture<Long> findStartPoint(Position p, long lastEntryId, AsyncLoadingCache<Long, MessageIdData> cache) {
        CompletableFuture<Long> promise = new CompletableFuture<Long>();
        if (lastEntryId < 0L) {
            promise.complete(-4276948923L);
        } else {
            CompactedTopicImpl.findStartPointLoop(p, 0L, lastEntryId, promise, cache);
        }
        return promise;
    }

    @VisibleForTesting
    static void findStartPointLoop(Position p, long start, long end, CompletableFuture<Long> promise, AsyncLoadingCache<Long, MessageIdData> cache) {
        long midpoint = start + (end - start) / 2L;
        CompletableFuture startEntry = cache.get((Object)start);
        CompletableFuture middleEntry = cache.get((Object)midpoint);
        CompletableFuture endEntry = cache.get((Object)end);
        ((CompletableFuture)CompletableFuture.allOf(startEntry, middleEntry, endEntry).thenRun(() -> {
            if (CompactedTopicImpl.comparePositionAndMessageId(p, (MessageIdData)startEntry.join()) <= 0) {
                promise.complete(start);
            } else if (CompactedTopicImpl.comparePositionAndMessageId(p, (MessageIdData)middleEntry.join()) <= 0) {
                CompactedTopicImpl.findStartPointLoop(p, start + 1L, midpoint, promise, cache);
            } else if (CompactedTopicImpl.comparePositionAndMessageId(p, (MessageIdData)endEntry.join()) <= 0) {
                CompactedTopicImpl.findStartPointLoop(p, midpoint + 1L, end, promise, cache);
            } else {
                promise.complete(-4276948922L);
            }
        })).exceptionally(exception -> {
            promise.completeExceptionally((Throwable)exception);
            return null;
        });
    }

    static AsyncLoadingCache<Long, MessageIdData> createCache(LedgerHandle lh, long maxSize) {
        return Caffeine.newBuilder().maximumSize(maxSize).buildAsync((entryId, executor) -> CompactedTopicImpl.readOneMessageId(lh, entryId));
    }

    private static CompletableFuture<MessageIdData> readOneMessageId(LedgerHandle lh, long entryId) {
        CompletableFuture<MessageIdData> promise = new CompletableFuture<MessageIdData>();
        lh.asyncReadEntries(entryId, entryId, (rc, _lh, seq, ctx) -> {
            if (rc != 0) {
                promise.completeExceptionally(BKException.create((int)rc));
            } else if (seq.hasMoreElements()) {
                LedgerEntry entry = (LedgerEntry)seq.nextElement();
                try (RawMessage m = RawMessageImpl.deserializeFrom(entry.getEntryBuffer());){
                    entry.getEntryBuffer().release();
                    while (seq.hasMoreElements()) {
                        ((LedgerEntry)seq.nextElement()).getEntryBuffer().release();
                    }
                    promise.complete(m.getMessageIdData());
                }
            } else {
                promise.completeExceptionally(new NoSuchElementException(String.format("No such entry %d in ledger %d", entryId, lh.getId())));
            }
        }, null);
        return promise;
    }

    private static CompletableFuture<CompactedTopicContext> openCompactedLedger(BookKeeper bk, long id) {
        CompletableFuture promise = new CompletableFuture();
        bk.asyncOpenLedger(id, Compactor.COMPACTED_TOPIC_LEDGER_DIGEST_TYPE, Compactor.COMPACTED_TOPIC_LEDGER_PASSWORD, (rc, ledger, ctx) -> {
            if (rc != 0) {
                promise.completeExceptionally(BKException.create((int)rc));
            } else {
                promise.complete(ledger);
            }
        }, null);
        return promise.thenApply(ledger -> new CompactedTopicContext((LedgerHandle)ledger, CompactedTopicImpl.createCache(ledger, 100L)));
    }

    private static CompletableFuture<Void> tryDeleteCompactedLedger(BookKeeper bk, long id) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        bk.asyncDeleteLedger(id, (rc, ctx) -> {
            if (rc != 0) {
                log.warn("Error deleting compacted topic ledger {}", (Object)id, (Object)BKException.create((int)rc));
            } else {
                log.debug("Compacted topic ledger deleted successfully");
            }
            promise.complete(null);
        }, null);
        return promise;
    }

    static CompletableFuture<List<Entry>> readEntries(LedgerHandle lh, long from, long to) {
        CompletableFuture promise = new CompletableFuture();
        lh.asyncReadEntries(from, to, (rc, _lh, seq, ctx) -> {
            if (rc != 0) {
                promise.completeExceptionally(BKException.create((int)rc));
            } else {
                promise.complete(seq);
            }
        }, null);
        return promise.thenApply(seq -> {
            ArrayList<EntryImpl> entries = new ArrayList<EntryImpl>();
            while (seq.hasMoreElements()) {
                ByteBuf buf = ((LedgerEntry)seq.nextElement()).getEntryBuffer();
                try {
                    RawMessage m = RawMessageImpl.deserializeFrom(buf);
                    try {
                        entries.add(EntryImpl.create((long)m.getMessageIdData().getLedgerId(), (long)m.getMessageIdData().getEntryId(), (ByteBuf)m.getHeadersAndPayload()));
                    }
                    finally {
                        if (m == null) continue;
                        m.close();
                    }
                }
                finally {
                    buf.release();
                }
            }
            return entries;
        });
    }

    public Optional<CompactedTopicContext> getCompactedTopicContext() throws ExecutionException, InterruptedException, TimeoutException {
        return this.compactedTopicContext == null ? Optional.empty() : Optional.of(this.compactedTopicContext.get(30L, TimeUnit.SECONDS));
    }

    @Override
    public CompletableFuture<Entry> readLastEntryOfCompactedLedger() {
        if (this.compactionHorizon == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.compactedTopicContext.thenCompose(context -> {
            if (context.ledger.getLastAddConfirmed() == -1L) {
                return CompletableFuture.completedFuture(null);
            }
            return CompactedTopicImpl.readEntries(context.ledger, context.ledger.getLastAddConfirmed(), context.ledger.getLastAddConfirmed()).thenCompose(entries -> entries.size() > 0 ? CompletableFuture.completedFuture((Entry)entries.get(0)) : CompletableFuture.completedFuture(null));
        });
    }

    CompletableFuture<Entry> findFirstMatchEntry(Predicate<Entry> predicate) {
        CompletableFuture<CompactedTopicContext> compactedTopicContextFuture = this.getCompactedTopicContextFuture();
        if (compactedTopicContextFuture == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("CompactedTopicContext is not initialized"));
        }
        return compactedTopicContextFuture.thenCompose(compactedTopicContext -> {
            LedgerHandle lh = compactedTopicContext.getLedger();
            CompletableFuture<Long> promise = new CompletableFuture<Long>();
            CompactedTopicImpl.findFirstMatchIndexLoop(predicate, 0L, lh.getLastAddConfirmed(), promise, null, lh);
            return promise.thenCompose(index -> CompactedTopicImpl.readEntries(lh, index, index).thenApply(entries -> {
                if (entries.size() != 1) {
                    for (Entry entry : entries) {
                        entry.release();
                    }
                    throw new IllegalStateException("Read " + entries.size() + " entries from the compacted ledger " + lh + " entry " + index);
                }
                return (Entry)entries.get(0);
            }));
        });
    }

    private static void findFirstMatchIndexLoop(Predicate<Entry> predicate, long start, long end, CompletableFuture<Long> promise, Long lastMatchIndex, LedgerHandle lh) {
        if (start > end) {
            promise.complete(lastMatchIndex);
            return;
        }
        long mid = (start + end) / 2L;
        ((CompletableFuture)CompactedTopicImpl.readEntries(lh, mid, mid).thenAccept(entries -> {
            boolean isMatch;
            Entry entry = (Entry)entries.get(0);
            try {
                isMatch = predicate.test(entry);
            }
            finally {
                entry.release();
            }
            if (isMatch) {
                CompactedTopicImpl.findFirstMatchIndexLoop(predicate, start, mid - 1L, promise, mid, lh);
            } else {
                CompactedTopicImpl.findFirstMatchIndexLoop(predicate, mid + 1L, end, promise, lastMatchIndex, lh);
            }
        })).exceptionally(ex -> {
            promise.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    private static int comparePositionAndMessageId(Position p, MessageIdData m) {
        return ComparisonChain.start().compare(p.getLedgerId(), m.getLedgerId()).compare(p.getEntryId(), m.getEntryId()).result();
    }

    @Override
    public Optional<Position> getCompactionHorizon() {
        return Optional.ofNullable(this.compactionHorizon);
    }

    public void reset() {
        this.compactionHorizon = null;
        this.compactedTopicContext = null;
    }

    public @Nullable CompletableFuture<CompactedTopicContext> getCompactedTopicContextFuture() {
        return this.compactedTopicContext;
    }
}

