/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client;

import java.util.Comparator;
import java.util.function.Predicate;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum CompareWithSlash implements Comparator<String>
{
    INSTANCE{

        @Override
        public int compare(@NonNull String a, @NonNull String b) {
            if (a == null) {
                throw new NullPointerException("a is marked non-null but is null");
            }
            if (b == null) {
                throw new NullPointerException("b is marked non-null but is null");
            }
            while (a.length() > 0 && b.length() > 0) {
                String spanB;
                int idxA = a.indexOf(47);
                int idxB = b.indexOf(47);
                if (idxA < 0 && idxB < 0) {
                    return Integer.compare(a.compareTo(b), 0);
                }
                if (idxA < 0) {
                    return -1;
                }
                if (idxB < 0) {
                    return 1;
                }
                String spanA = a.substring(0, idxA);
                int spanRes = Integer.compare(spanA.compareTo(spanB = b.substring(0, idxB)), 0);
                if (spanRes != 0) {
                    return spanRes;
                }
                a = a.substring(idxA + 1);
                b = b.substring(idxB + 1);
            }
            if (a.length() < b.length()) {
                return -1;
            }
            if (a.length() > 0) {
                return 1;
            }
            return 0;
        }
    };


    static boolean withinRange(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive, @NonNull String key) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return INSTANCE.compare(key, startKeyInclusive) >= 0 && INSTANCE.compare(key, endKeyExclusive) < 0;
    }

    @NonNull
    public static Predicate<String> withinRange(@NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
        if (startKeyInclusive == null) {
            throw new NullPointerException("startKeyInclusive is marked non-null but is null");
        }
        if (endKeyExclusive == null) {
            throw new NullPointerException("endKeyExclusive is marked non-null but is null");
        }
        return k -> CompareWithSlash.withinRange(startKeyInclusive, endKeyExclusive, k);
    }
}

