# PIP-305: Add OpAddEntry and pendingData statistics info in JVM metrics

# Background knowledge

Pulsar client use Netty DNS to resolve hostnames.

# Motivation

Currently Pulsar client levereage on JVM detected DNS servers or on Google DNS servers if nothing was found (as per Netty default). You cannot change which DNS use to resolve hostnames but you are forced to use local server one (like DNS servers configured through resolv.conf or similar ways) or leverage on some Netty "black magic" system properties.

The ability to directly configure which DNS use is strictly necessary in environment with "specialized" DNS servers.

# Goals

## In Scope

Add a new configuration on Pulsar client to explicitly set which DNS use.

## Out of Scope

Fully configure DNS layer, properties, timeouts etcetera.


# High Level Design

A new client configuration will be added to list wich DNS server use. Such configuration will be checked when creating Pulsar clients to instantiate the DNS resolver.
If no configuration is provided the client must use current defaults.


# Detailed Design

## Design & Implementation Details

The new configuration will be read from org.apache.pulsar.client.impl.ConnectionPool to configure a DnsNameResolverBuilder

## Public-facing Changes
Add new dnsServerAddresses method on org.apache.pulsar.client.api.ClientBuilder.

There are no breaking changes, if dnsServerAddresses is not configuret Pulsar will continue to behave like now.


### Public API

NA

### Binary protocol

NA

### Configuration

Add new dnsServerAddresses property on org.apache.pulsar.client.impl.conf.ClientConfigurationData.

### CLI

NA

### Metrics

NA

# Monitoring

NA

# Security Considerations

The client will have the ability to use a different set of DNS servers. It is possible to alter hostnames resolutions however it is expected that this does not pose any security risks.

# Backward & Forward Compatibility

## Revert

Just remove dnsServerAddresses configuration

## Upgrade

Configure a dnsServerAddresses server list. The configuration is not mandatory, Pulsar can run without it just like before.

# Alternatives

Expose an interface builder to fully configure the DNS layer. It has much more impact and conflict with existing configuration properties dnsLookupBindAddress and dnsLookupBindPort.

# General Notes

# Links

* Mailing List discussion thread: https://lists.apache.org/thread/p0870y7o6brv5y1ghn5tz9hvs24bl1k4
* Mailing List voting thread: https://lists.apache.org/thread/7dd0htk0qqkrjxztj445lj3qskxr2dky
