/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.EventLoopGroup;
import io.opentelemetry.api.OpenTelemetry;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.commons.configuration2.Configuration;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.stats.prometheus.metrics.PrometheusMetricsProvider;
import org.apache.pulsar.broker.storage.BookkeeperManagedLedgerStorageClass;
import org.apache.pulsar.broker.storage.ManagedLedgerStorage;
import org.apache.pulsar.broker.storage.ManagedLedgerStorageClass;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.apache.pulsar.common.stats.CacheMetricsCollector;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerClientFactory
implements ManagedLedgerStorage {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerClientFactory.class);
    private static final String DEFAULT_STORAGE_CLASS_NAME = "bookkeeper";
    private BookkeeperManagedLedgerStorageClass defaultStorageClass;
    private ManagedLedgerFactory managedLedgerFactory;
    private BookKeeper defaultBkClient;
    private final AsyncCache<EnsemblePlacementPolicyConfig, BookKeeper> bkEnsemblePolicyToBkClientMap = Caffeine.newBuilder().recordStats().buildAsync();
    private StatsProvider statsProvider = new NullStatsProvider();

    public ManagedLedgerClientFactory() {
        CacheMetricsCollector.CAFFEINE.addCache("managed-ledger-bk-ensemble-client-cache", this.bkEnsemblePolicyToBkClientMap);
    }

    @Override
    public void initialize(ServiceConfiguration conf, MetadataStoreExtended metadataStore, BookKeeperClientFactory bookkeeperProvider, EventLoopGroup eventLoopGroup, OpenTelemetry openTelemetry) throws Exception {
        ManagedLedgerFactoryConfig managedLedgerFactoryConfig = new ManagedLedgerFactoryConfig();
        managedLedgerFactoryConfig.setMaxCacheSize((long)conf.getManagedLedgerCacheSizeMB() * 1024L * 1024L);
        managedLedgerFactoryConfig.setCacheEvictionWatermark(conf.getManagedLedgerCacheEvictionWatermark());
        managedLedgerFactoryConfig.setNumManagedLedgerSchedulerThreads(conf.getManagedLedgerNumSchedulerThreads());
        managedLedgerFactoryConfig.setCacheEvictionIntervalMs(conf.getManagedLedgerCacheEvictionIntervalMs());
        managedLedgerFactoryConfig.setCacheEvictionTimeThresholdMillis(conf.getManagedLedgerCacheEvictionTimeThresholdMillis());
        Long continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis = conf.getManagedLedgerContinueCachingAddedEntriesAfterLastActiveCursorLeavesMillis();
        if (continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis != null) {
            managedLedgerFactoryConfig.setContinueCachingAddedEntriesAfterLastActiveCursorLeavesMillis(continueCachingAddedEntriesAfterLastActiveCursorLeavesMillis.longValue());
        } else {
            managedLedgerFactoryConfig.setContinueCachingAddedEntriesAfterLastActiveCursorLeavesMillis(2L * conf.getManagedLedgerCacheEvictionTimeThresholdMillis());
        }
        managedLedgerFactoryConfig.setCopyEntriesInCache(conf.isManagedLedgerCacheCopyEntries());
        long managedLedgerMaxReadsInFlightSizeBytes = conf.getManagedLedgerMaxReadsInFlightSizeInMB() * 1024L * 1024L;
        if (managedLedgerMaxReadsInFlightSizeBytes > 0L && conf.getDispatcherMaxReadSizeBytes() > 0 && managedLedgerMaxReadsInFlightSizeBytes < (long)conf.getDispatcherMaxReadSizeBytes()) {
            log.warn("Invalid configuration for managedLedgerMaxReadsInFlightSizeInMB: {}, dispatcherMaxReadSizeBytes: {}. managedLedgerMaxReadsInFlightSizeInMB in bytes should be greater than dispatcherMaxReadSizeBytes. You should set managedLedgerMaxReadsInFlightSizeInMB to at least {}", new Object[]{conf.getManagedLedgerMaxReadsInFlightSizeInMB(), conf.getDispatcherMaxReadSizeBytes(), (long)conf.getDispatcherMaxReadSizeBytes() / 0x100000L + 1L});
        }
        managedLedgerFactoryConfig.setManagedLedgerMaxReadsInFlightSize(managedLedgerMaxReadsInFlightSizeBytes);
        managedLedgerFactoryConfig.setManagedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis(conf.getManagedLedgerMaxReadsInFlightPermitsAcquireTimeoutMillis());
        managedLedgerFactoryConfig.setManagedLedgerMaxReadsInFlightPermitsAcquireQueueSize(conf.getManagedLedgerMaxReadsInFlightPermitsAcquireQueueSize());
        managedLedgerFactoryConfig.setPrometheusStatsLatencyRolloverSeconds(conf.getManagedLedgerPrometheusStatsLatencyRolloverSeconds());
        managedLedgerFactoryConfig.setTraceTaskExecution(conf.isManagedLedgerTraceTaskExecution());
        managedLedgerFactoryConfig.setCursorPositionFlushSeconds(conf.getManagedLedgerCursorPositionFlushSeconds());
        managedLedgerFactoryConfig.setManagedLedgerInfoCompressionType(conf.getManagedLedgerInfoCompressionType());
        managedLedgerFactoryConfig.setManagedLedgerInfoCompressionThresholdInBytes(conf.getManagedLedgerInfoCompressionThresholdInBytes());
        managedLedgerFactoryConfig.setStatsPeriodSeconds(conf.getManagedLedgerStatsPeriodSeconds());
        managedLedgerFactoryConfig.setManagedCursorInfoCompressionType(conf.getManagedCursorInfoCompressionType());
        managedLedgerFactoryConfig.setManagedCursorInfoCompressionThresholdInBytes(conf.getManagedCursorInfoCompressionThresholdInBytes());
        ClientConfiguration configuration = new ClientConfiguration();
        if (conf.isBookkeeperClientExposeStatsToPrometheus()) {
            configuration.addProperty("prometheusStatsLatencyRolloverSeconds", (Object)conf.getManagedLedgerPrometheusStatsLatencyRolloverSeconds());
            configuration.addProperty("cluster", (Object)conf.getClusterName());
            this.statsProvider = new PrometheusMetricsProvider();
        }
        this.statsProvider.start((Configuration)configuration);
        StatsLogger statsLogger = this.statsProvider.getStatsLogger("pulsar_managedLedger_client");
        this.defaultBkClient = bookkeeperProvider.create(conf, metadataStore, eventLoopGroup, Optional.empty(), null, statsLogger).get();
        ManagedLedgerFactoryImpl.BookkeeperFactoryForCustomEnsemblePlacementPolicy bkFactory = ensemblePlacementPolicyConfig -> {
            if (ensemblePlacementPolicyConfig == null || ensemblePlacementPolicyConfig.getPolicyClass() == null) {
                return CompletableFuture.completedFuture(this.defaultBkClient);
            }
            return this.bkEnsemblePolicyToBkClientMap.get((Object)ensemblePlacementPolicyConfig, (config, executor) -> bookkeeperProvider.create(conf, metadataStore, eventLoopGroup, Optional.ofNullable(ensemblePlacementPolicyConfig.getPolicyClass()), ensemblePlacementPolicyConfig.getProperties(), statsLogger));
        };
        try {
            this.managedLedgerFactory = this.createManagedLedgerFactory(metadataStore, openTelemetry, bkFactory, managedLedgerFactoryConfig, statsLogger);
        }
        catch (Exception e) {
            this.statsProvider.stop();
            this.defaultBkClient.close();
            throw e;
        }
        this.defaultStorageClass = new BookkeeperManagedLedgerStorageClass(){

            @Override
            public String getName() {
                return ManagedLedgerClientFactory.DEFAULT_STORAGE_CLASS_NAME;
            }

            @Override
            public ManagedLedgerFactory getManagedLedgerFactory() {
                return ManagedLedgerClientFactory.this.managedLedgerFactory;
            }

            @Override
            public StatsProvider getStatsProvider() {
                return ManagedLedgerClientFactory.this.statsProvider;
            }

            @Override
            public BookKeeper getBookKeeperClient() {
                return ManagedLedgerClientFactory.this.defaultBkClient;
            }
        };
    }

    protected ManagedLedgerFactoryImpl createManagedLedgerFactory(MetadataStoreExtended metadataStore, OpenTelemetry openTelemetry, ManagedLedgerFactoryImpl.BookkeeperFactoryForCustomEnsemblePlacementPolicy bkFactory, ManagedLedgerFactoryConfig managedLedgerFactoryConfig, StatsLogger statsLogger) throws Exception {
        return new ManagedLedgerFactoryImpl(metadataStore, bkFactory, managedLedgerFactoryConfig, statsLogger, openTelemetry);
    }

    @Override
    public Collection<ManagedLedgerStorageClass> getStorageClasses() {
        return List.of(this.getDefaultStorageClass());
    }

    @Override
    public Optional<ManagedLedgerStorageClass> getManagedLedgerStorageClass(String name) {
        if (name == null || DEFAULT_STORAGE_CLASS_NAME.equals(name)) {
            return Optional.of(this.getDefaultStorageClass());
        }
        return Optional.empty();
    }

    @Override
    public ManagedLedgerStorageClass getDefaultStorageClass() {
        return this.defaultStorageClass;
    }

    @VisibleForTesting
    public Map<EnsemblePlacementPolicyConfig, BookKeeper> getBkEnsemblePolicyToBookKeeperMap() {
        return this.bkEnsemblePolicyToBkClientMap.synchronous().asMap();
    }

    @Override
    public void close() throws IOException {
        try {
            if (null != this.managedLedgerFactory) {
                this.managedLedgerFactory.shutdown();
                log.info("Closed managed ledger factory");
            }
            if (null != this.statsProvider) {
                this.statsProvider.stop();
            }
            try {
                if (null != this.defaultBkClient) {
                    this.defaultBkClient.close();
                }
            }
            catch (RejectedExecutionException ree) {
                log.warn("Encountered exceptions on closing bookkeeper client", (Throwable)ree);
            }
            this.bkEnsemblePolicyToBkClientMap.synchronous().asMap().forEach((policy, bk) -> {
                try {
                    if (bk != null) {
                        bk.close();
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to close bookkeeper-client for policy {}", policy, (Object)e);
                }
            });
            log.info("Closed BookKeeper client");
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
    }
}

