/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import lombok.Generated;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionBound;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.impl.ManagedCursorContainer;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.Futures;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.delayed.BucketDelayedDeliveryTrackerFactory;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTrackerFactory;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateDataConflictResolver;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateTableViewImpl;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.broker.resources.TopicResources;
import org.apache.pulsar.broker.service.AbstractReplicator;
import org.apache.pulsar.broker.service.AbstractTopic;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.GetStatsOptions;
import org.apache.pulsar.broker.service.PersistentTopicAttributes;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.StreamingStats;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.SubscriptionOption;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TopicPoliciesService;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.broker.service.persistent.AbstractPersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.GeoPersistentReplicator;
import org.apache.pulsar.broker.service.persistent.MessageDeduplication;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.persistent.PersistentMessageFinder;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopicMetrics;
import org.apache.pulsar.broker.service.persistent.PulsarCompactorSubscription;
import org.apache.pulsar.broker.service.persistent.ReplicatedSubscriptionsController;
import org.apache.pulsar.broker.service.persistent.ShadowReplicator;
import org.apache.pulsar.broker.service.persistent.SubscribeRateLimiter;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.service.schema.exceptions.NotExistSchemaException;
import org.apache.pulsar.broker.stats.ClusterReplicationMetrics;
import org.apache.pulsar.broker.stats.NamespaceStats;
import org.apache.pulsar.broker.stats.ReplicationMetrics;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.broker.transaction.buffer.impl.TopicTransactionBuffer;
import org.apache.pulsar.broker.transaction.buffer.impl.TransactionBufferDisable;
import org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckStore;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PolicyHierarchyValue;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionPendingAckStats;
import org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;
import org.apache.pulsar.common.policies.data.stats.PublisherStatsImpl;
import org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import org.apache.pulsar.common.policies.data.stats.SubscriptionStatsImpl;
import org.apache.pulsar.common.policies.data.stats.TopicMetricBean;
import org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.Markers;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaStorage;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.topics.TopicCompactionStrategy;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.compaction.CompactedTopicContext;
import org.apache.pulsar.compaction.CompactedTopicImpl;
import org.apache.pulsar.compaction.Compactor;
import org.apache.pulsar.compaction.CompactorMXBean;
import org.apache.pulsar.compaction.PulsarTopicCompactionService;
import org.apache.pulsar.compaction.TopicCompactionService;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.utils.StatsOutputStream;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentTopic
extends AbstractTopic
implements Topic,
AsyncCallbacks.AddEntryCallback {
    protected final ManagedLedger ledger;
    private final Map<String, PersistentSubscription> subscriptions = new ConcurrentHashMap<String, PersistentSubscription>();
    private final Map<String, Replicator> replicators = new ConcurrentHashMap<String, Replicator>();
    private final Map<String, Replicator> shadowReplicators = new ConcurrentHashMap<String, Replicator>();
    private volatile List<String> shadowTopics;
    private final TopicName shadowSourceTopic;
    public static final String DEDUPLICATION_CURSOR_NAME = "pulsar.dedup";
    private static final String TOPIC_EPOCH_PROPERTY_NAME = "pulsar.topic.epoch";
    private static final double MESSAGE_EXPIRY_THRESHOLD = 1.5;
    private static final long POLICY_UPDATE_FAILURE_RETRY_TIME_SECONDS = 60L;
    private static final String MIGRATION_CLUSTER_NAME = "migration-cluster";
    private volatile boolean migrationSubsCreated = false;
    public boolean msgChunkPublished;
    private Optional<DispatchRateLimiter> dispatchRateLimiter = Optional.empty();
    private final Object dispatchRateLimiterLock = new Object();
    private Optional<SubscribeRateLimiter> subscribeRateLimiter = Optional.empty();
    private final long backloggedCursorThresholdEntries;
    public static final int MESSAGE_RATE_BACKOFF_MS = 1000;
    protected final MessageDeduplication messageDeduplication;
    private static final Long COMPACTION_NEVER_RUN = -4273917950L;
    volatile CompletableFuture<Long> currentCompaction = CompletableFuture.completedFuture(COMPACTION_NEVER_RUN);
    final AtomicBoolean disablingCompaction = new AtomicBoolean(false);
    private TopicCompactionService topicCompactionService;
    private static Map<String, TopicCompactionStrategy> strategicCompactionMap = Map.of(ServiceUnitStateTableViewImpl.TOPIC, new ServiceUnitStateDataConflictResolver());
    private CompletableFuture<MessageIdImpl> currentOffload = CompletableFuture.completedFuture((MessageIdImpl)MessageId.earliest);
    private volatile Optional<ReplicatedSubscriptionsController> replicatedSubscriptionsController = Optional.empty();
    private static final FastThreadLocal<TopicStatsHelper> threadLocalTopicStats = new FastThreadLocal<TopicStatsHelper>(){

        protected TopicStatsHelper initialValue() {
            return new TopicStatsHelper();
        }
    };
    private final AtomicLong pendingWriteOps = new AtomicLong(0L);
    private volatile double lastUpdatedAvgPublishRateInMsg = 0.0;
    private volatile double lastUpdatedAvgPublishRateInByte = 0.0;
    private volatile boolean isClosingOrDeleting = false;
    private ScheduledFuture<?> fencedTopicMonitoringTask = null;
    protected final TransactionBuffer transactionBuffer;
    private final TopicTransactionBuffer.MaxReadPositionCallBack maxReadPositionCallBack = (oldPosition, newPosition) -> this.updateMaxReadPositionMovedForwardTimestamp();
    private volatile long lastMaxReadPositionMovedForwardTimestamp = 0L;
    private final ExecutorService orderedExecutor;
    private volatile CloseFutures closeFutures;
    private final PersistentTopicMetrics persistentTopicMetrics = new PersistentTopicMetrics();
    private volatile PersistentTopicAttributes persistentTopicAttributes = null;
    private static final AtomicReferenceFieldUpdater<PersistentTopic, PersistentTopicAttributes> PERSISTENT_TOPIC_ATTRIBUTES_FIELD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PersistentTopic.class, PersistentTopicAttributes.class, "persistentTopicAttributes");
    private volatile OldestPositionInfo oldestPositionInfo;
    private static final AtomicReferenceFieldUpdater<PersistentTopic, OldestPositionInfo> TIME_BASED_BACKLOG_QUOTA_CHECK_RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PersistentTopic.class, OldestPositionInfo.class, "oldestPositionInfo");
    private volatile Position lastDispatchablePosition;
    private volatile long cachedLastPublishTimestamp;
    private static final Logger log = LoggerFactory.getLogger(PersistentTopic.class);

    public static boolean isDedupCursorName(String name) {
        return DEDUPLICATION_CURSOR_NAME.equals(name);
    }

    public PersistentTopic(String topic, ManagedLedger ledger, BrokerService brokerService) {
        super(topic, brokerService);
        this.orderedExecutor = brokerService.getTopicOrderedExecutor() != null ? brokerService.getTopicOrderedExecutor().chooseThread((Object)topic) : null;
        this.ledger = ledger;
        this.backloggedCursorThresholdEntries = brokerService.pulsar().getConfiguration().getManagedLedgerCursorBackloggedThreshold();
        this.messageDeduplication = new MessageDeduplication(brokerService.pulsar(), this, ledger);
        if (ledger.getProperties().containsKey(TOPIC_EPOCH_PROPERTY_NAME)) {
            this.topicEpoch = Optional.of(Long.parseLong((String)ledger.getProperties().get(TOPIC_EPOCH_PROPERTY_NAME)));
        }
        TopicName topicName = TopicName.get((String)topic);
        this.transactionBuffer = brokerService.getPulsar().getConfiguration().isTransactionCoordinatorEnabled() && !SystemTopicNames.isEventSystemTopic((TopicName)topicName) && !SystemTopicNames.isTransactionInternalName((TopicName)topicName) && !SystemTopicNames.isTransactionBufferOrPendingAckSystemTopicName((TopicName)topicName) && !NamespaceService.isHeartbeatNamespace((ServiceUnitId)topicName.getNamespaceObject()) && !ExtensibleLoadManagerImpl.isInternalTopic(topic) ? brokerService.getPulsar().getTransactionBufferProvider().newTransactionBuffer(this) : new TransactionBufferDisable(this);
        this.transactionBuffer.syncMaxReadPositionForNormalPublish(ledger.getLastConfirmedEntry(), true);
        this.shadowSourceTopic = ledger.getConfig().getShadowSource() != null ? TopicName.get((String)ledger.getConfig().getShadowSource()) : null;
    }

    @VisibleForTesting
    PersistentTopic(String topic, BrokerService brokerService, ManagedLedger ledger, MessageDeduplication messageDeduplication) {
        super(topic, brokerService);
        this.orderedExecutor = brokerService.getTopicOrderedExecutor() != null ? brokerService.getTopicOrderedExecutor().chooseThread((Object)topic) : null;
        this.ledger = ledger;
        this.messageDeduplication = messageDeduplication;
        this.backloggedCursorThresholdEntries = brokerService.pulsar().getConfiguration().getManagedLedgerCursorBackloggedThreshold();
        this.transactionBuffer = brokerService.pulsar().getConfiguration().isTransactionCoordinatorEnabled() ? brokerService.getPulsar().getTransactionBufferProvider().newTransactionBuffer(this) : new TransactionBufferDisable(this);
        this.shadowSourceTopic = null;
    }

    @Override
    public CompletableFuture<Void> initialize() {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        futures.add(this.brokerService.getPulsar().newTopicCompactionService(this.topic).thenAccept(service -> {
            this.topicCompactionService = service;
            this.createPersistentSubscriptions();
        }));
        return FutureUtil.waitForAll(futures).thenCompose(__ -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.brokerService.pulsar().getPulsarResources().getNamespaceResources().getPoliciesAsync(TopicName.get((String)this.topic).getNamespaceObject()).thenAcceptAsync(optPolicies -> {
            if (!optPolicies.isPresent()) {
                this.isEncryptionRequired = false;
                this.updatePublishRateLimiter();
                this.updateResourceGroupLimiter(new Policies());
                this.initializeDispatchRateLimiterIfNeeded();
                this.updateSubscribeRateLimiter();
                return;
            }
            Policies policies = (Policies)optPolicies.get();
            this.updateTopicPolicyByNamespacePolicy(policies);
            this.initializeDispatchRateLimiterIfNeeded();
            this.updateSubscribeRateLimiter();
            this.updatePublishRateLimiter();
            this.updateResourceGroupLimiter(policies);
            this.isEncryptionRequired = policies.encryption_required;
            this.isAllowAutoUpdateSchema = policies.is_allow_auto_update_schema;
        }, (Executor)this.getOrderedExecutor())).thenCompose(ignore -> this.initTopicPolicy())).thenCompose(ignore -> this.removeOrphanReplicationCursors())).exceptionally(ex -> {
            log.warn("[{}] Error getting policies {} and isEncryptionRequired will be set to false", (Object)this.topic, (Object)ex.getMessage());
            this.isEncryptionRequired = false;
            return null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDispatchRateLimiterIfNeeded() {
        Object object = this.dispatchRateLimiterLock;
        synchronized (object) {
            if (!this.dispatchRateLimiter.isPresent() && DispatchRateLimiter.isDispatchRateEnabled((DispatchRate)this.topicPolicies.getDispatchRate().get())) {
                this.dispatchRateLimiter = Optional.of(this.getBrokerService().getDispatchRateLimiterFactory().createTopicDispatchRateLimiter(this));
            }
        }
    }

    @VisibleForTesting
    public AtomicLong getPendingWriteOps() {
        return this.pendingWriteOps;
    }

    private void createPersistentSubscriptions() {
        for (ManagedCursor cursor : this.ledger.getCursors()) {
            if (cursor.getName().equals(DEDUPLICATION_CURSOR_NAME) || cursor.getName().startsWith(this.replicatorPrefix)) continue;
            String subscriptionName = Codec.decode((String)cursor.getName());
            Optional<Boolean> replicatedSubscriptionConfiguration = PersistentSubscription.getReplicatedSubscriptionConfiguration(cursor);
            Boolean replicated = replicatedSubscriptionConfiguration.orElse(null);
            this.subscriptions.put(subscriptionName, this.createPersistentSubscription(subscriptionName, cursor, replicated, cursor.getCursorProperties()));
            this.subscriptions.get(subscriptionName).deactivateCursor();
        }
        this.checkReplicatedSubscriptionControllerState();
    }

    private CompletableFuture<Void> removeOrphanReplicationCursors() {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        List replicationClusters = (List)this.topicPolicies.getReplicationClusters().get();
        for (ManagedCursor cursor : this.ledger.getCursors()) {
            String remoteCluster;
            if (!cursor.getName().startsWith(this.replicatorPrefix) || replicationClusters.contains(remoteCluster = PersistentReplicator.getRemoteCluster(cursor.getName()))) continue;
            log.warn("Remove the orphan replicator because the cluster '{}' does not exist", (Object)remoteCluster);
            futures.add(this.removeReplicator(remoteCluster));
        }
        return FutureUtil.waitForAll(futures);
    }

    public CompletableFuture<Void> unloadSubscription(@NonNull String subName) {
        PersistentSubscription sub = this.subscriptions.get(subName);
        if (sub == null) {
            return CompletableFuture.failedFuture(new BrokerServiceException.SubscriptionNotFoundException(String.format("Subscription %s not found", subName)));
        }
        if ("__compaction".equals(sub.getName())) {
            return CompletableFuture.failedFuture(new BrokerServiceException.UnsupportedSubscriptionException(String.format("Unsupported subscription: %s", subName)));
        }
        return sub.close(true, Optional.empty()).thenCompose(ignore -> {
            if (!this.lock.writeLock().tryLock()) {
                return CompletableFuture.failedFuture(new BrokerServiceException.SubscriptionConflictUnloadException(String.format("Conflict topic-close, topic-delete, another-subscribe-unload, cannot unload subscription %s now", subName)));
            }
            try {
                if (this.isFenced) {
                    CompletableFuture completableFuture = CompletableFuture.failedFuture(new BrokerServiceException.TopicFencedException(String.format("Topic[%s] is fenced, can not unload subscription %s now", this.topic, subName)));
                    return completableFuture;
                }
                if (sub != this.subscriptions.get(subName)) {
                    CompletableFuture completableFuture = CompletableFuture.failedFuture(new BrokerServiceException.SubscriptionConflictUnloadException(String.format("Another unload subscriber[%s] has been finished, do not repeat call.", subName)));
                    return completableFuture;
                }
                sub.getCursor().rewind();
                PersistentSubscription subNew = this.createPersistentSubscription(sub.getName(), sub.getCursor(), sub.isReplicated(), sub.getSubscriptionProperties());
                this.subscriptions.put(subName, subNew);
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    protected PersistentSubscription createPersistentSubscription(String subscriptionName, ManagedCursor cursor, Boolean replicated, Map<String, String> subscriptionProperties) {
        TopicCompactionService topicCompactionService;
        Objects.requireNonNull(this.topicCompactionService);
        if (PersistentTopic.isCompactionSubscription(subscriptionName) && (topicCompactionService = this.topicCompactionService) instanceof PulsarTopicCompactionService) {
            PulsarTopicCompactionService pulsarTopicCompactionService = (PulsarTopicCompactionService)topicCompactionService;
            CompactedTopicImpl compactedTopic = pulsarTopicCompactionService.getCompactedTopic();
            return new PulsarCompactorSubscription(this, compactedTopic, subscriptionName, cursor);
        }
        return new PersistentSubscription(this, subscriptionName, cursor, replicated, subscriptionProperties);
    }

    public static boolean isCompactionSubscription(String subscriptionName) {
        return "__compaction".equals(subscriptionName);
    }

    @Override
    public void publishMessage(ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        this.pendingWriteOps.incrementAndGet();
        if (this.isFenced) {
            publishContext.completed(new BrokerServiceException.TopicFencedException("fenced"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        if (this.isExceedMaximumMessageSize(headersAndPayload.readableBytes(), publishContext)) {
            publishContext.completed(new BrokerServiceException.NotAllowedException("Exceed maximum message size"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        if (this.isExceedMaximumDeliveryDelay(headersAndPayload)) {
            publishContext.completed(new BrokerServiceException.NotAllowedException(String.format("Exceeds max allowed delivery delay of %s milliseconds", this.getDelayedDeliveryMaxDelayInMillis())), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        MessageDeduplication.MessageDupStatus status = this.messageDeduplication.isDuplicate(publishContext, headersAndPayload);
        switch (status) {
            case NotDup: {
                this.asyncAddEntry(headersAndPayload, publishContext);
                break;
            }
            case Dup: {
                publishContext.completed(null, -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
                break;
            }
            default: {
                publishContext.completed(new MessageDeduplication.MessageDupUnknownException(this.topic, publishContext.getProducerName()), -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubscribeRateLimiter() {
        SubscribeRate subscribeRate = this.getSubscribeRate();
        Optional<SubscribeRateLimiter> optional = this.subscribeRateLimiter;
        synchronized (optional) {
            if (SubscribeRateLimiter.isSubscribeRateEnabled(subscribeRate)) {
                if (this.subscribeRateLimiter.isPresent()) {
                    this.subscribeRateLimiter.get().onSubscribeRateUpdate(subscribeRate);
                } else {
                    this.subscribeRateLimiter = Optional.of(new SubscribeRateLimiter(this));
                }
            } else if (this.subscribeRateLimiter.isPresent()) {
                this.subscribeRateLimiter.get().close();
                this.subscribeRateLimiter = Optional.empty();
            }
        }
    }

    private void asyncAddEntry(ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        this.ledger.asyncAddEntry(headersAndPayload, (int)publishContext.getNumberOfMessages(), (AsyncCallbacks.AddEntryCallback)this, (Object)publishContext);
    }

    public void asyncReadEntry(Position position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        this.ledger.asyncReadEntry(position, callback, ctx);
    }

    public Position getPositionAfterN(Position startPosition, long n) throws ManagedLedgerException {
        return this.ledger.getPositionAfterN(startPosition, n, PositionBound.startExcluded);
    }

    public Position getFirstPosition() throws ManagedLedgerException {
        return this.ledger.getFirstPosition();
    }

    public long getNumberOfEntries() {
        return this.ledger.getNumberOfEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementPendingWriteOpsAndCheck() {
        long pending = this.pendingWriteOps.decrementAndGet();
        if (pending == 0L && this.isFenced && !this.isClosingOrDeleting) {
            PersistentTopic persistentTopic = this;
            synchronized (persistentTopic) {
                if (this.isFenced && !this.isClosingOrDeleting) {
                    this.messageDeduplication.resetHighestSequenceIdPushed();
                    log.info("[{}] Un-fencing topic...", (Object)this.topic);
                    this.ledger.readyToCreateNewLedger();
                    this.unfence();
                }
            }
        }
    }

    private void updateMaxReadPositionMovedForwardTimestamp() {
        this.lastMaxReadPositionMovedForwardTimestamp = Clock.systemUTC().millis();
    }

    public void addComplete(Position pos, ByteBuf entryData, Object ctx) {
        Topic.PublishContext publishContext = (Topic.PublishContext)ctx;
        Position position = pos;
        this.messageDeduplication.recordMessagePersisted(publishContext, position);
        this.transactionBuffer.syncMaxReadPositionForNormalPublish(this.ledger.getLastConfirmedEntry(), publishContext.isMarkerMessage());
        publishContext.setMetadataFromEntryData(entryData);
        publishContext.completed(null, position.getLedgerId(), position.getEntryId());
        this.decrementPendingWriteOpsAndCheck();
    }

    public synchronized void addFailed(ManagedLedgerException exception, Object ctx) {
        if (this.transferring) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed to persist msg in store: {} while transferring.", new Object[]{this.topic, exception.getMessage(), exception});
            }
            return;
        }
        Topic.PublishContext callback = (Topic.PublishContext)ctx;
        if (exception instanceof ManagedLedgerException.ManagedLedgerFencedException) {
            this.close();
        } else {
            CompletableFuture disconnectProducersFuture;
            this.fence();
            if (this.producers.size() > 0) {
                ArrayList futures = new ArrayList();
                if (this.isMigrated()) {
                    if (!this.shouldProducerMigrate()) {
                        log.info("Topic {} is migrated but replication-backlog exists or subs not created. Closing producers.", (Object)this.topic);
                    } else {
                        this.producers.forEach((__, producer) -> producer.topicMigrated(this.getMigratedClusterUrl()));
                    }
                }
                this.producers.forEach((__, producer) -> futures.add(producer.disconnect()));
                disconnectProducersFuture = FutureUtil.waitForAll(futures);
            } else {
                disconnectProducersFuture = CompletableFuture.completedFuture(null);
            }
            disconnectProducersFuture.handle((aVoid, throwable) -> {
                this.decrementPendingWriteOpsAndCheck();
                return null;
            });
            if (exception instanceof ManagedLedgerException.ManagedLedgerAlreadyClosedException) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Failed to persist msg in store: {}", (Object)this.topic, (Object)exception.getMessage());
                }
                callback.completed(new BrokerServiceException.TopicClosedException(exception), -1L, -1L);
                return;
            }
            log.warn("[{}] Failed to persist msg in store: {}", (Object)this.topic, (Object)exception.getMessage());
            if (exception instanceof ManagedLedgerException.ManagedLedgerTerminatedException && !this.isMigrated()) {
                callback.completed(new BrokerServiceException.TopicTerminatedException(exception), -1L, -1L);
            } else {
                callback.completed(new BrokerServiceException.PersistenceException(exception), -1L, -1L);
            }
        }
    }

    @Override
    public CompletableFuture<Optional<Long>> addProducer(Producer producer, CompletableFuture<Void> producerQueuedFuture) {
        return super.addProducer(producer, producerQueuedFuture).thenCompose(topicEpoch -> {
            this.messageDeduplication.producerAdded(producer.getProducerName());
            return this.startReplProducers().thenApply(__ -> topicEpoch);
        });
    }

    @Override
    public CompletableFuture<Void> checkIfTransactionBufferRecoverCompletely() {
        return this.getTransactionBuffer().checkIfTBRecoverCompletely();
    }

    @Override
    protected CompletableFuture<Long> incrementTopicEpoch(Optional<Long> currentEpoch) {
        long newEpoch = currentEpoch.orElse(-1L) + 1L;
        return this.setTopicEpoch(newEpoch);
    }

    @Override
    protected CompletableFuture<Long> setTopicEpoch(final long newEpoch) {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.ledger.asyncSetProperty(TOPIC_EPOCH_PROPERTY_NAME, String.valueOf(newEpoch), new AsyncCallbacks.UpdatePropertiesCallback(){

            public void updatePropertiesComplete(Map<String, String> properties, Object ctx) {
                log.info("[{}] Updated topic epoch to {}", (Object)PersistentTopic.this.getName(), (Object)newEpoch);
                future.complete(newEpoch);
            }

            public void updatePropertiesFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Failed to update topic epoch to {}: {}", new Object[]{PersistentTopic.this.getName(), newEpoch, exception.getMessage()});
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    private boolean hasRemoteProducers() {
        if (this.producers.isEmpty()) {
            return false;
        }
        for (Producer producer : this.producers.values()) {
            if (!producer.isRemote()) continue;
            return true;
        }
        return false;
    }

    public CompletableFuture<Void> startReplProducers() {
        return ((CompletableFuture)this.brokerService.pulsar().getPulsarResources().getNamespaceResources().getPoliciesAsync(TopicName.get((String)this.topic).getNamespaceObject()).thenAcceptAsync(optPolicies -> {
            if (optPolicies.isPresent()) {
                if (((Policies)optPolicies.get()).replication_clusters != null) {
                    TreeSet configuredClusters = Sets.newTreeSet((Iterable)((Policies)optPolicies.get()).replication_clusters);
                    this.replicators.forEach((region, replicator) -> {
                        if (configuredClusters.contains(region)) {
                            replicator.startProducer();
                        }
                    });
                }
            } else {
                this.replicators.forEach((region, replicator) -> replicator.startProducer());
            }
        }, (Executor)this.getOrderedExecutor())).exceptionally(ex -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Error getting policies while starting repl-producers {}", (Object)this.topic, (Object)ex.getMessage());
            }
            this.replicators.forEach((region, replicator) -> replicator.startProducer());
            return null;
        });
    }

    public CompletableFuture<Void> stopReplProducers() {
        ArrayList closeFutures = new ArrayList();
        this.replicators.forEach((region, replicator) -> closeFutures.add(replicator.terminate()));
        this.shadowReplicators.forEach((__, replicator) -> closeFutures.add(replicator.terminate()));
        return FutureUtil.waitForAll(closeFutures);
    }

    private synchronized CompletableFuture<Void> closeReplProducersIfNoBacklog() {
        ArrayList closeFutures = new ArrayList();
        this.replicators.forEach((region, replicator) -> closeFutures.add(replicator.disconnect()));
        this.shadowReplicators.forEach((__, replicator) -> closeFutures.add(replicator.disconnect()));
        return FutureUtil.waitForAll(closeFutures);
    }

    @Override
    protected void handleProducerRemoved(Producer producer) {
        super.handleProducerRemoved(producer);
        this.messageDeduplication.producerRemoved(producer.getProducerName());
    }

    @Override
    public CompletableFuture<Consumer> subscribe(SubscriptionOption option) {
        return this.internalSubscribe(option.getCnx(), option.getSubscriptionName(), option.getConsumerId(), option.getSubType(), option.getPriorityLevel(), option.getConsumerName(), option.isDurable(), option.getStartMessageId(), option.getMetadata(), option.isReadCompacted(), option.getInitialPosition(), option.getStartMessageRollbackDurationSec(), option.getReplicatedSubscriptionStateArg(), option.getKeySharedMeta(), option.getSubscriptionProperties().orElse(Collections.emptyMap()), option.getConsumerEpoch(), option.getSchemaType());
    }

    private CompletableFuture<Consumer> internalSubscribe(TransportCnx cnx, String subscriptionName, long consumerId, CommandSubscribe.SubType subType, int priorityLevel, String consumerName, boolean isDurable, MessageId startMessageId, Map<String, String> metadata, boolean readCompacted, CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec, Boolean replicatedSubscriptionStateArg, KeySharedMeta keySharedMeta, Map<String, String> subscriptionProperties, long consumerEpoch, SchemaType schemaType) {
        if (readCompacted && subType != CommandSubscribe.SubType.Failover && subType != CommandSubscribe.SubType.Exclusive) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("readCompacted only allowed on failover or exclusive subscriptions"));
        }
        return this.brokerService.checkTopicNsOwnership(this.getName()).thenCompose(__ -> {
            Object consumer;
            Boolean replicatedSubscriptionState = replicatedSubscriptionStateArg;
            if (replicatedSubscriptionState != null && replicatedSubscriptionState.booleanValue() && !this.brokerService.pulsar().getConfiguration().isEnableReplicatedSubscriptions()) {
                log.warn("[{}] Replicated Subscription is disabled by broker.", (Object)this.getName());
                replicatedSubscriptionState = false;
            }
            if (subType == CommandSubscribe.SubType.Key_Shared && !this.brokerService.pulsar().getConfiguration().isSubscriptionKeySharedEnable()) {
                return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Key_Shared subscription is disabled by broker."));
            }
            try {
                if (!SystemTopicNames.isTopicPoliciesSystemTopic((String)this.topic) && !this.checkSubscriptionTypesEnable(subType)) {
                    return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Topic[{" + this.topic + "}] doesn't support " + subType.name() + " sub type!"));
                }
            }
            catch (Exception e) {
                return FutureUtil.failedFuture((Throwable)e);
            }
            if (StringUtils.isBlank((CharSequence)subscriptionName)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Empty subscription name", (Object)this.topic);
                }
                return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NamingException("Empty subscription name"));
            }
            if (this.hasBatchMessagePublished && !cnx.isBatchMessageCompatibleVersion()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Consumer doesn't support batch-message {}", (Object)this.topic, (Object)subscriptionName);
                }
                return FutureUtil.failedFuture((Throwable)new BrokerServiceException.UnsupportedVersionException("Consumer doesn't support batch-message"));
            }
            if (subscriptionName.startsWith(this.replicatorPrefix) || subscriptionName.equals(DEDUPLICATION_CURSOR_NAME)) {
                log.warn("[{}] Failed to create subscription for {}", (Object)this.topic, (Object)subscriptionName);
                return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NamingException("Subscription with reserved subscription name attempted"));
            }
            if (cnx.clientAddress() != null && cnx.clientAddress().toString().contains(":") && this.subscribeRateLimiter.isPresent()) {
                consumer = new SubscribeRateLimiter.ConsumerIdentifier(cnx.clientAddress().toString().split(":")[0], consumerName, consumerId);
                if (!this.subscribeRateLimiter.get().subscribeAvailable((SubscribeRateLimiter.ConsumerIdentifier)consumer) || !this.subscribeRateLimiter.get().tryAcquire((SubscribeRateLimiter.ConsumerIdentifier)consumer)) {
                    log.warn("[{}] Failed to create subscription for {} {} limited by {}, available {}", new Object[]{this.topic, subscriptionName, consumer, this.subscribeRateLimiter.get().getSubscribeRate(), this.subscribeRateLimiter.get().getAvailableSubscribeRateLimit((SubscribeRateLimiter.ConsumerIdentifier)consumer)});
                    return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Subscribe limited by subscribe rate limit per consumer."));
                }
            }
            this.lock.readLock().lock();
            try {
                if (this.isFenced) {
                    log.warn("[{}] Attempting to subscribe to a fenced topic", (Object)this.topic);
                    consumer = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicFencedException("Topic is temporarily unavailable"));
                    return consumer;
                }
                this.handleConsumerAdded(subscriptionName, consumerName);
            }
            finally {
                this.lock.readLock().unlock();
            }
            CompletableFuture<Subscription> subscriptionFuture = isDurable ? this.getDurableSubscription(subscriptionName, initialPosition, startMessageRollbackDurationSec, replicatedSubscriptionState, subscriptionProperties) : this.getNonDurableSubscription(subscriptionName, startMessageId, initialPosition, startMessageRollbackDurationSec, readCompacted, subscriptionProperties);
            CompletionStage future = subscriptionFuture.thenCompose(subscription -> {
                Consumer consumer = new Consumer((Subscription)subscription, subType, this.topic, consumerId, priorityLevel, consumerName, isDurable, cnx, cnx.getAuthRole(), metadata, readCompacted, keySharedMeta, startMessageId, consumerEpoch, schemaType);
                return this.addConsumerToSubscription((Subscription)subscription, consumer).thenCompose(v -> {
                    if (subscription instanceof PersistentSubscription) {
                        PersistentSubscription persistentSubscription = (PersistentSubscription)subscription;
                        this.checkBackloggedCursor(persistentSubscription);
                    }
                    if (!cnx.isActive()) {
                        try {
                            consumer.close();
                        }
                        catch (BrokerServiceException e) {
                            if (e instanceof BrokerServiceException.ConsumerBusyException) {
                                log.warn("[{}][{}] Consumer {} {} already connected: {}", new Object[]{this.topic, subscriptionName, consumerId, consumerName, e.getMessage()});
                            } else if (e instanceof BrokerServiceException.SubscriptionBusyException) {
                                log.warn("[{}][{}] {}", new Object[]{this.topic, subscriptionName, e.getMessage()});
                            }
                            this.decrementUsageCount();
                            return FutureUtil.failedFuture((Throwable)e);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] [{}] [{}] Subscribe failed -- count: {}", new Object[]{this.topic, subscriptionName, consumer.consumerName(), this.currentUsageCount()});
                        }
                        this.decrementUsageCount();
                        return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConnectionClosedException("Connection was closed while the opening the cursor "));
                    }
                    this.checkReplicatedSubscriptionControllerState();
                    if (log.isDebugEnabled()) {
                        log.debug("[{}][{}] Created new subscription for {}", new Object[]{this.topic, subscriptionName, consumerId});
                    }
                    return CompletableFuture.completedFuture(consumer);
                });
            });
            ((CompletableFuture)future).exceptionally(ex -> {
                this.decrementUsageCount();
                if (ex.getCause() instanceof BrokerServiceException.ConsumerBusyException) {
                    log.warn("[{}][{}] Consumer {} {} already connected: {}", new Object[]{this.topic, subscriptionName, consumerId, consumerName, ex.getCause().getMessage()});
                    Consumer consumer = null;
                    try {
                        Consumer consumer2 = consumer = subscriptionFuture.isDone() ? this.getActiveConsumer((Subscription)subscriptionFuture.get()) : null;
                        if (consumer != null && !consumer.cnx().isActive()) {
                            consumer.close();
                        }
                    }
                    catch (Exception be) {
                        log.error("Failed to clean up consumer on closed connection {}, {}", (Object)consumer, (Object)be.getMessage());
                    }
                } else if (ex.getCause() instanceof BrokerServiceException.SubscriptionBusyException) {
                    log.warn("[{}][{}] {}", new Object[]{this.topic, subscriptionName, ex.getMessage()});
                } else if (ex.getCause() instanceof BrokerServiceException.SubscriptionFencedException && PersistentTopic.isCompactionSubscription(subscriptionName)) {
                    log.warn("[{}] Failed to create compaction subscription: {}", (Object)this.topic, (Object)ex.getMessage());
                } else if (ex.getCause() instanceof ManagedLedgerException.ManagedLedgerFencedException) {
                    log.warn("[{}][{}] has been fenced. closing the topic {}", new Object[]{this.topic, subscriptionName, ex.getMessage()});
                    this.close();
                } else if (ex.getCause() instanceof BrokerServiceException.ConnectionClosedException) {
                    log.warn("[{}][{}] Connection was closed while the opening the cursor", (Object)this.topic, (Object)subscriptionName);
                } else {
                    log.error("[{}] Failed to create subscription: {}", new Object[]{this.topic, subscriptionName, ex});
                }
                return null;
            });
            return future;
        });
    }

    @Override
    public CompletableFuture<Consumer> subscribe(TransportCnx cnx, String subscriptionName, long consumerId, CommandSubscribe.SubType subType, int priorityLevel, String consumerName, boolean isDurable, MessageId startMessageId, Map<String, String> metadata, boolean readCompacted, CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec, boolean replicatedSubscriptionStateArg, KeySharedMeta keySharedMeta) {
        return this.internalSubscribe(cnx, subscriptionName, consumerId, subType, priorityLevel, consumerName, isDurable, startMessageId, metadata, readCompacted, initialPosition, startMessageRollbackDurationSec, replicatedSubscriptionStateArg, keySharedMeta, null, -1L, null);
    }

    private CompletableFuture<Subscription> getDurableSubscription(final String subscriptionName, CommandSubscribe.InitialPosition initialPosition, final long startMessageRollbackDurationSec, final Boolean replicated, final Map<String, String> subscriptionProperties) {
        final CompletableFuture<Subscription> subscriptionFuture = new CompletableFuture<Subscription>();
        if (this.checkMaxSubscriptionsPerTopicExceed(subscriptionName)) {
            subscriptionFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("Exceed the maximum number of subscriptions of the topic: " + this.topic));
            return subscriptionFuture;
        }
        Map<String, Long> properties = PersistentSubscription.getBaseCursorProperties(replicated);
        this.ledger.asyncOpenCursor(Codec.encode((String)subscriptionName), initialPosition, properties, subscriptionProperties, new AsyncCallbacks.OpenCursorCallback(){

            public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                PersistentSubscription subscription;
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Opened cursor", (Object)PersistentTopic.this.topic, (Object)subscriptionName);
                }
                if ((subscription = PersistentTopic.this.subscriptions.get(subscriptionName)) == null) {
                    subscription = PersistentTopic.this.subscriptions.computeIfAbsent(subscriptionName, name -> PersistentTopic.this.createPersistentSubscription(subscriptionName, cursor, replicated, subscriptionProperties));
                } else if (subscription.getCursor() != null && !subscription.getCursor().isDurable()) {
                    subscriptionFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("NonDurable subscription with the same name already exists."));
                    return;
                }
                if (replicated != null && replicated.booleanValue() && !subscription.isReplicated()) {
                    subscription.setReplicated(replicated);
                }
                if (startMessageRollbackDurationSec > 0L) {
                    PersistentTopic.this.resetSubscriptionCursor(subscription, subscriptionFuture, startMessageRollbackDurationSec);
                } else {
                    subscriptionFuture.complete(subscription);
                }
            }

            public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Failed to create subscription for {}: {}", new Object[]{PersistentTopic.this.topic, subscriptionName, exception.getMessage()});
                PersistentTopic.this.decrementUsageCount();
                subscriptionFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                if (exception instanceof ManagedLedgerException.ManagedLedgerFencedException) {
                    PersistentTopic.this.close();
                }
            }
        }, null);
        return subscriptionFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<? extends Subscription> getNonDurableSubscription(String subscriptionName, MessageId startMessageId, CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec, boolean isReadCompacted, Map<String, String> subscriptionProperties) {
        log.info("[{}][{}] Creating non-durable subscription at msg id {} - {}", new Object[]{this.topic, subscriptionName, startMessageId, subscriptionProperties});
        CompletableFuture<Subscription> subscriptionFuture = new CompletableFuture<Subscription>();
        if (this.checkMaxSubscriptionsPerTopicExceed(subscriptionName)) {
            subscriptionFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("Exceed the maximum number of subscriptions of the topic: " + this.topic));
            return subscriptionFuture;
        }
        ManagedLedger managedLedger = this.ledger;
        synchronized (managedLedger) {
            PersistentSubscription subscription = this.subscriptions.get(subscriptionName);
            if (subscription == null) {
                MessageIdImpl msgId = startMessageId != null ? (MessageIdImpl)startMessageId : (MessageIdImpl)MessageId.latest;
                long ledgerId = msgId.getLedgerId();
                long entryId = msgId.getEntryId();
                if (ledgerId >= 0L && entryId >= 0L && msgId instanceof BatchMessageIdImpl) {
                    entryId = msgId.getEntryId() - 1L;
                }
                Position startPosition = PositionFactory.create((long)ledgerId, (long)entryId);
                ManagedCursor cursor = null;
                try {
                    cursor = this.ledger.newNonDurableCursor(startPosition, subscriptionName, initialPosition, isReadCompacted);
                }
                catch (ManagedLedgerException e) {
                    return FutureUtil.failedFuture((Throwable)e);
                }
                subscription = new PersistentSubscription(this, subscriptionName, cursor, false, subscriptionProperties);
                this.subscriptions.put(subscriptionName, subscription);
            } else if (subscription.getCursor() != null && subscription.getCursor().isDurable()) {
                return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Durable subscription with the same name already exists."));
            }
            if (startMessageRollbackDurationSec > 0L) {
                this.resetSubscriptionCursor(subscription, subscriptionFuture, startMessageRollbackDurationSec);
                return subscriptionFuture;
            }
            return CompletableFuture.completedFuture(subscription);
        }
    }

    private void resetSubscriptionCursor(Subscription subscription, CompletableFuture<Subscription> subscriptionFuture, long startMessageRollbackDurationSec) {
        long timestamp = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(startMessageRollbackDurationSec);
        Subscription finalSubscription = subscription;
        subscription.resetCursor(timestamp).handle((s, ex) -> {
            if (ex != null) {
                log.warn("[{}] Failed to reset cursor {} position at timestamp {}, caused by {}", new Object[]{this.topic, subscription.getName(), startMessageRollbackDurationSec, ex.getMessage()});
            }
            subscriptionFuture.complete(finalSubscription);
            return null;
        });
    }

    @Override
    public CompletableFuture<Subscription> createSubscription(String subscriptionName, CommandSubscribe.InitialPosition initialPosition, boolean replicateSubscriptionState, Map<String, String> subscriptionProperties) {
        return this.getDurableSubscription(subscriptionName, initialPosition, 0L, replicateSubscriptionState, subscriptionProperties);
    }

    @Override
    public CompletableFuture<Void> unsubscribe(final String subscriptionName) {
        final CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        TopicName tn = TopicName.get((String)MLPendingAckStore.getTransactionPendingAckStoreSuffix(this.topic, Codec.encode((String)subscriptionName)));
        if (this.brokerService.pulsar().getConfiguration().isTransactionCoordinatorEnabled()) {
            CompletableFuture<ManagedLedgerConfig> managedLedgerConfig = this.getBrokerService().getManagedLedgerConfig(tn);
            ((CompletableFuture)managedLedgerConfig.thenAccept(config -> {
                ManagedLedgerFactory managedLedgerFactory = this.getBrokerService().getManagedLedgerFactoryForTopic(tn, config.getStorageClassName());
                managedLedgerFactory.asyncDelete(tn.getPersistenceNamingEncoding(), managedLedgerConfig, new AsyncCallbacks.DeleteLedgerCallback(){

                    public void deleteLedgerComplete(Object ctx) {
                        PersistentTopic.this.asyncDeleteCursorWithClearDelayedMessage(subscriptionName, unsubscribeFuture);
                    }

                    public void deleteLedgerFailed(ManagedLedgerException exception, Object ctx) {
                        if (exception instanceof ManagedLedgerException.MetadataNotFoundException) {
                            PersistentTopic.this.asyncDeleteCursorWithClearDelayedMessage(subscriptionName, unsubscribeFuture);
                            return;
                        }
                        unsubscribeFuture.completeExceptionally(exception);
                        log.error("[{}][{}] Error deleting subscription pending ack store", new Object[]{PersistentTopic.this.topic, subscriptionName, exception});
                    }
                }, null);
            })).exceptionally(ex -> {
                unsubscribeFuture.completeExceptionally((Throwable)ex);
                return null;
            });
        } else {
            this.asyncDeleteCursorWithClearDelayedMessage(subscriptionName, unsubscribeFuture);
        }
        return unsubscribeFuture;
    }

    private void asyncDeleteCursorWithClearDelayedMessage(String subscriptionName, CompletableFuture<Void> unsubscribeFuture) {
        PersistentSubscription persistentSubscription = this.subscriptions.get(subscriptionName);
        if (persistentSubscription == null) {
            log.warn("[{}][{}] Can't find subscription, skip delete cursor", (Object)this.topic, (Object)subscriptionName);
            unsubscribeFuture.complete(null);
            return;
        }
        if (!this.isDelayedDeliveryEnabled() || !(this.brokerService.getDelayedDeliveryTrackerFactory() instanceof BucketDelayedDeliveryTrackerFactory)) {
            this.asyncDeleteCursorWithCleanCompactionLedger(persistentSubscription, unsubscribeFuture);
            return;
        }
        Dispatcher dispatcher = persistentSubscription.getDispatcher();
        if (dispatcher == null) {
            DelayedDeliveryTrackerFactory delayedDeliveryTrackerFactory = this.brokerService.getDelayedDeliveryTrackerFactory();
            if (delayedDeliveryTrackerFactory instanceof BucketDelayedDeliveryTrackerFactory) {
                BucketDelayedDeliveryTrackerFactory bucketDelayedDeliveryTrackerFactory = (BucketDelayedDeliveryTrackerFactory)delayedDeliveryTrackerFactory;
                ManagedCursor cursor = persistentSubscription.getCursor();
                bucketDelayedDeliveryTrackerFactory.cleanResidualSnapshots(cursor).whenComplete((__, ex) -> {
                    if (ex != null) {
                        unsubscribeFuture.completeExceptionally((Throwable)ex);
                    } else {
                        this.asyncDeleteCursorWithCleanCompactionLedger(persistentSubscription, unsubscribeFuture);
                    }
                });
            }
            return;
        }
        dispatcher.clearDelayedMessages().whenComplete((__, ex) -> {
            if (ex != null) {
                unsubscribeFuture.completeExceptionally((Throwable)ex);
            } else {
                this.asyncDeleteCursorWithCleanCompactionLedger(persistentSubscription, unsubscribeFuture);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncDeleteCursorWithCleanCompactionLedger(PersistentSubscription subscription, CompletableFuture<Void> unsubscribeFuture) {
        String subscriptionName = subscription.getName();
        if (!PersistentTopic.isCompactionSubscription(subscriptionName) || !(subscription instanceof PulsarCompactorSubscription)) {
            this.asyncDeleteCursor(subscriptionName, unsubscribeFuture);
            return;
        }
        PersistentTopic persistentTopic = this;
        synchronized (persistentTopic) {
            if (!this.disablingCompaction.compareAndSet(false, true)) {
                unsubscribeFuture.completeExceptionally(new BrokerServiceException.SubscriptionBusyException("the subscription is deleting by another task"));
                return;
            }
        }
        ((CompletableFuture)((CompletableFuture)this.currentCompaction.thenCompose(__ -> {
            this.asyncDeleteCursor(subscriptionName, unsubscribeFuture);
            return unsubscribeFuture;
        })).thenAccept(__ -> {
            try {
                ((PulsarCompactorSubscription)subscription).cleanCompactedLedger();
            }
            catch (Exception ex) {
                Long compactedLedger = null;
                Optional<CompactedTopicContext> compactedTopicContext = this.getCompactedTopicContext();
                if (compactedTopicContext.isPresent() && compactedTopicContext.get().getLedger() != null) {
                    compactedLedger = compactedTopicContext.get().getLedger().getId();
                }
                log.error("[{}][{}][{}] Error cleaning compacted ledger", new Object[]{this.topic, subscriptionName, compactedLedger, ex});
            }
            finally {
                this.disablingCompaction.compareAndSet(true, false);
            }
        })).exceptionally(ex -> {
            if (this.currentCompaction.isCompletedExceptionally()) {
                log.warn("[{}][{}] Last compaction task failed", (Object)this.topic, (Object)subscriptionName);
            } else {
                log.warn("[{}][{}] Failed to delete cursor task failed", (Object)this.topic, (Object)subscriptionName);
            }
            this.disablingCompaction.compareAndSet(true, false);
            unsubscribeFuture.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    private void asyncDeleteCursor(final String subscriptionName, final CompletableFuture<Void> unsubscribeFuture) {
        this.ledger.asyncDeleteCursor(Codec.encode((String)subscriptionName), new AsyncCallbacks.DeleteCursorCallback(){

            public void deleteCursorComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Cursor deleted successfully", (Object)PersistentTopic.this.topic, (Object)subscriptionName);
                }
                PersistentTopic.this.removeSubscription(subscriptionName);
                unsubscribeFuture.complete(null);
                PersistentTopic.this.lastActive = System.nanoTime();
            }

            public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Error deleting cursor for subscription", new Object[]{PersistentTopic.this.topic, subscriptionName, exception});
                }
                if (exception instanceof ManagedLedgerException.ManagedLedgerNotFoundException || exception instanceof ManagedLedgerException.CursorNotFoundException) {
                    PersistentTopic.this.removeSubscription(subscriptionName);
                    unsubscribeFuture.complete(null);
                    PersistentTopic.this.lastActive = System.nanoTime();
                    return;
                }
                unsubscribeFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null);
    }

    CompletableFuture<Void> removeSubscription(String subscriptionName) {
        PersistentSubscription sub = this.subscriptions.remove(subscriptionName);
        if (sub != null) {
            return sub.getStatsAsync(new GetStatsOptions(false, false, false, false, false)).thenAccept(stats -> {
                this.bytesOutFromRemovedSubscriptions.add(stats.bytesOutCounter);
                this.msgOutFromRemovedSubscriptions.add(stats.msgOutCounter);
                if (this.isSystemCursor(subscriptionName) || subscriptionName.startsWith("__system_reader")) {
                    this.bytesOutFromRemovedSystemSubscriptions.add(stats.bytesOutCounter);
                }
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.delete(false, false, false);
    }

    @Override
    public CompletableFuture<Void> deleteForcefully() {
        return this.delete(false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> delete(boolean failIfHasSubscriptions, boolean failIfHasBacklogs, boolean closeIfClientsConnected) {
        this.lock.writeLock().lock();
        try {
            if (this.isClosingOrDeleting) {
                log.warn("[{}] Topic is already being closed or deleted", (Object)this.topic);
                CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicFencedException("Topic is already fenced"));
                return completableFuture;
            }
            if (!closeIfClientsConnected) {
                if (failIfHasSubscriptions && !this.subscriptions.isEmpty()) {
                    CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBusyException("Topic has subscriptions: " + String.valueOf(this.subscriptions.keySet().stream().toList())));
                    return completableFuture;
                }
                if (failIfHasBacklogs) {
                    if (this.hasBacklogs(false)) {
                        List<String> backlogSubs = this.subscriptions.values().stream().filter(sub -> sub.getNumberOfEntriesInBacklog(false) > 0L).map(PersistentSubscription::getName).toList();
                        CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBusyException("Topic has subscriptions did not catch up: " + String.valueOf(backlogSubs)));
                        return completableFuture;
                    }
                    if (!this.producers.isEmpty()) {
                        CompletableFuture backlogSubs = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBusyException("Topic has " + this.producers.size() + " connected producers"));
                        return backlogSubs;
                    }
                } else if (this.currentUsageCount() > 0L) {
                    CompletableFuture backlogSubs = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBusyException("Topic has " + this.currentUsageCount() + " connected producers/consumers"));
                    return backlogSubs;
                }
            }
            this.fenceTopicToCloseOrDelete();
            this.closeFutures = new CloseFutures(new CompletableFuture<Void>(), new CompletableFuture<Void>(), new CompletableFuture<Void>());
            final AtomicBoolean alreadyUnFenced = new AtomicBoolean();
            CompletionStage res = this.getBrokerService().getPulsar().getPulsarResources().getNamespaceResources().getPartitionedTopicResources().runWithMarkDeleteAsync(TopicName.get((String)this.topic), () -> {
                final CompletableFuture deleteFuture = new CompletableFuture();
                CompletableFuture closeClientFuture = new CompletableFuture();
                ArrayList futures = new ArrayList();
                this.subscriptions.forEach((s, sub) -> futures.add(sub.close(true, Optional.empty())));
                if (closeIfClientsConnected) {
                    this.replicators.forEach((cluster, replicator) -> futures.add(replicator.terminate()));
                    this.shadowReplicators.forEach((__, replicator) -> futures.add(replicator.terminate()));
                    this.producers.values().forEach(producer -> futures.add(producer.disconnect()));
                }
                ((CompletableFuture)FutureUtil.waitForAll(futures).thenRunAsync(() -> closeClientFuture.complete(null), command -> {
                    try {
                        this.getOrderedExecutor().execute(command);
                    }
                    catch (RejectedExecutionException e) {
                        command.run();
                    }
                })).exceptionally(ex -> {
                    log.error("[{}] Error closing clients", (Object)this.topic, ex);
                    alreadyUnFenced.set(true);
                    this.unfenceTopicToResume();
                    closeClientFuture.completeExceptionally((Throwable)ex);
                    return null;
                });
                ((CompletableFuture)closeClientFuture.thenAccept(__ -> {
                    CompletableFuture<Void> deleteTopicAuthenticationFuture = new CompletableFuture<Void>();
                    this.brokerService.deleteTopicAuthenticationWithRetry(this.topic, deleteTopicAuthenticationFuture, 5);
                    ((CompletableFuture)((CompletableFuture)((CompletableFuture)deleteTopicAuthenticationFuture.thenCompose(ignore -> this.deleteSchema())).thenCompose(ignore -> this.deleteTopicPolicies())).thenCompose(ignore -> this.transactionBufferCleanupAndClose())).whenComplete((v, ex) -> {
                        if (ex != null) {
                            log.error("[{}] Error deleting topic", (Object)this.topic, ex);
                            alreadyUnFenced.set(true);
                            this.unfenceTopicToResume();
                            deleteFuture.completeExceptionally((Throwable)ex);
                        } else {
                            ArrayList subsDeleteFutures = new ArrayList();
                            this.subscriptions.forEach((sub, p) -> subsDeleteFutures.add(this.unsubscribe((String)sub)));
                            FutureUtil.waitForAll(subsDeleteFutures).whenComplete((f, e) -> {
                                if (e != null) {
                                    log.error("[{}] Error deleting topic", (Object)this.topic, e);
                                    alreadyUnFenced.set(true);
                                    this.unfenceTopicToResume();
                                    deleteFuture.completeExceptionally((Throwable)e);
                                } else {
                                    this.ledger.asyncDelete(new AsyncCallbacks.DeleteLedgerCallback(){

                                        public void deleteLedgerComplete(Object ctx) {
                                            PersistentTopic.this.brokerService.removeTopicFromCache(PersistentTopic.this);
                                            PersistentTopic.this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::close);
                                            PersistentTopic.this.subscribeRateLimiter.ifPresent(SubscribeRateLimiter::close);
                                            PersistentTopic.this.unregisterTopicPolicyListener();
                                            log.info("[{}] Topic deleted", (Object)PersistentTopic.this.topic);
                                            deleteFuture.complete(null);
                                        }

                                        public void deleteLedgerFailed(ManagedLedgerException exception, Object ctx) {
                                            if (exception.getCause() instanceof MetadataStoreException.NotFoundException) {
                                                log.info("[{}] Topic is already deleted {}", (Object)PersistentTopic.this.topic, (Object)exception.getMessage());
                                                this.deleteLedgerComplete(ctx);
                                            } else {
                                                log.error("[{}] Error deleting topic", (Object)PersistentTopic.this.topic, (Object)exception);
                                                alreadyUnFenced.set(true);
                                                PersistentTopic.this.unfenceTopicToResume();
                                                deleteFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                                            }
                                        }
                                    }, null);
                                }
                            });
                        }
                    });
                })).exceptionally(ex -> {
                    alreadyUnFenced.set(true);
                    this.unfenceTopicToResume();
                    deleteFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Failed to close clients before deleting topic.", FutureUtil.unwrapCompletionException((Throwable)ex)));
                    return null;
                });
                return deleteFuture;
            }).whenComplete((value, ex) -> {
                if (ex != null) {
                    log.error("[{}] Error deleting topic", (Object)this.topic, ex);
                    if (!alreadyUnFenced.get()) {
                        this.unfenceTopicToResume();
                    }
                }
            });
            FutureUtil.completeAfter(this.closeFutures.transferring, (CompletableFuture)res);
            FutureUtil.completeAfter(this.closeFutures.notWaitDisconnectClients, (CompletableFuture)res);
            FutureUtil.completeAfter(this.closeFutures.waitDisconnectClients, (CompletableFuture)res);
            CompletionStage completionStage = res;
            return completionStage;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public CompletableFuture<Void> close() {
        return this.close(true, false);
    }

    @Override
    public CompletableFuture<Void> close(boolean closeWithoutWaitingClientDisconnect) {
        return this.close(true, closeWithoutWaitingClientDisconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close(boolean disconnectClients, boolean closeWithoutWaitingClientDisconnect) {
        this.lock.writeLock().lock();
        final CloseTypes closeType = !disconnectClients ? CloseTypes.transferring : (closeWithoutWaitingClientDisconnect ? CloseTypes.notWaitDisconnectClients : CloseTypes.waitDisconnectClients);
        CompletableFuture<Void> inProgressTransferCloseTask = null;
        try {
            if (this.isClosingOrDeleting) {
                if (closeType == CloseTypes.transferring) {
                    CompletableFuture<Void> completableFuture = this.closeFutures.transferring;
                    return completableFuture;
                }
                if (closeType == CloseTypes.notWaitDisconnectClients && this.closeFutures.notWaitDisconnectClients != null) {
                    CompletableFuture<Void> completableFuture = this.closeFutures.notWaitDisconnectClients;
                    return completableFuture;
                }
                if (closeType == CloseTypes.waitDisconnectClients && this.closeFutures.waitDisconnectClients != null) {
                    CompletableFuture<Void> completableFuture = this.closeFutures.waitDisconnectClients;
                    return completableFuture;
                }
                if (this.transferring) {
                    inProgressTransferCloseTask = this.closeFutures.transferring;
                }
            }
            this.fenceTopicToCloseOrDelete();
            if (closeType == CloseTypes.transferring) {
                this.transferring = true;
                this.closeFutures = new CloseFutures(new CompletableFuture<Void>(), null, null);
            } else {
                this.closeFutures = new CloseFutures(new CompletableFuture<Void>(), new CompletableFuture<Void>(), new CompletableFuture<Void>());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        if (inProgressTransferCloseTask != null) {
            futures.add(inProgressTransferCloseTask);
        }
        futures.add(this.transactionBuffer.closeAsync());
        this.replicators.forEach((cluster, replicator) -> futures.add(replicator.terminate()));
        this.shadowReplicators.forEach((__, replicator) -> futures.add(replicator.terminate()));
        if (closeType != CloseTypes.transferring) {
            futures.add(ExtensibleLoadManagerImpl.getAssignedBrokerLookupData(this.brokerService.getPulsar(), this.topic).thenAccept(lookupData -> {
                this.producers.values().forEach(producer -> futures.add(producer.disconnect((Optional<BrokerLookupData>)lookupData)));
                if (this.isTransferring()) {
                    this.subscriptions.forEach((s, sub) -> futures.add(sub.disconnect((Optional<BrokerLookupData>)lookupData)));
                } else {
                    this.subscriptions.forEach((s, sub) -> futures.add(sub.close(true, (Optional<BrokerLookupData>)lookupData)));
                }
            }));
        } else {
            this.subscriptions.forEach((s, sub) -> futures.add(sub.close(false, Optional.empty())));
        }
        if (this.entryFilters != null) {
            ((List)this.entryFilters.getRight()).forEach(filter -> {
                try {
                    filter.close();
                }
                catch (Throwable e) {
                    log.warn("Error shutting down entry filter {}", filter, (Object)e);
                }
            });
        }
        if (this.topicCompactionService != null) {
            try {
                this.topicCompactionService.close();
            }
            catch (Exception e) {
                log.warn("Error close topicCompactionService ", (Throwable)e);
            }
        }
        CompletableFuture disconnectClientsInCurrentCall = null;
        AtomicReference<CompletableFuture> disconnectClientsToCache = new AtomicReference<CompletableFuture>();
        switch (closeType.ordinal()) {
            case 0: {
                disconnectClientsInCurrentCall = FutureUtil.waitForAll(futures);
                break;
            }
            case 1: {
                disconnectClientsInCurrentCall = CompletableFuture.completedFuture(null);
                disconnectClientsToCache.set(FutureUtil.waitForAll(futures));
                break;
            }
            case 2: {
                disconnectClientsInCurrentCall = FutureUtil.waitForAll(futures);
                disconnectClientsToCache.set(disconnectClientsInCurrentCall);
            }
        }
        final CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        Runnable closeLedgerAfterCloseClients = () -> this.ledger.asyncClose(new AsyncCallbacks.CloseCallback(){

            public void closeComplete(Object ctx) {
                if (closeType != CloseTypes.transferring) {
                    PersistentTopic.this.disposeTopic(closeFuture);
                } else {
                    closeFuture.complete(null);
                }
            }

            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to close managed ledger, proceeding anyway.", (Object)PersistentTopic.this.topic, (Object)exception);
                if (closeType != CloseTypes.transferring) {
                    PersistentTopic.this.disposeTopic(closeFuture);
                } else {
                    closeFuture.complete(null);
                }
            }
        }, null);
        ((CompletableFuture)disconnectClientsInCurrentCall.thenRun(closeLedgerAfterCloseClients)).exceptionally(exception -> {
            log.error("[{}] Error closing topic", (Object)this.topic, exception);
            this.unfenceTopicToResume();
            closeFuture.completeExceptionally((Throwable)exception);
            return null;
        });
        switch (closeType.ordinal()) {
            case 0: {
                FutureUtil.completeAfterAll(this.closeFutures.transferring, (CompletableFuture[])new CompletableFuture[]{closeFuture});
                break;
            }
            case 1: {
                FutureUtil.completeAfterAll(this.closeFutures.transferring, (CompletableFuture[])new CompletableFuture[]{closeFuture});
                FutureUtil.completeAfter(this.closeFutures.notWaitDisconnectClients, closeFuture);
                FutureUtil.completeAfterAll(this.closeFutures.waitDisconnectClients, (CompletableFuture[])new CompletableFuture[]{closeFuture.thenCompose(ignore -> ((CompletableFuture)disconnectClientsToCache.get()).exceptionally(ex -> {
                    log.error("[{}] Closed managed ledger, but disconnect clients failed, this topic will be marked closed", (Object)this.topic, ex);
                    return null;
                }))});
                break;
            }
            case 2: {
                FutureUtil.completeAfterAll(this.closeFutures.transferring, (CompletableFuture[])new CompletableFuture[]{closeFuture});
                FutureUtil.completeAfter(this.closeFutures.notWaitDisconnectClients, closeFuture);
                FutureUtil.completeAfterAll(this.closeFutures.waitDisconnectClients, (CompletableFuture[])new CompletableFuture[]{closeFuture});
            }
        }
        return closeFuture;
    }

    private boolean isClosed() {
        if (this.closeFutures == null) {
            return false;
        }
        if (this.closeFutures.transferring != null && this.closeFutures.transferring.isDone() && !this.closeFutures.transferring.isCompletedExceptionally()) {
            return true;
        }
        if (this.closeFutures.notWaitDisconnectClients != null && this.closeFutures.notWaitDisconnectClients.isDone() && !this.closeFutures.notWaitDisconnectClients.isCompletedExceptionally()) {
            return true;
        }
        return this.closeFutures.waitDisconnectClients != null && this.closeFutures.waitDisconnectClients.isDone() && !this.closeFutures.waitDisconnectClients.isCompletedExceptionally();
    }

    private void disposeTopic(CompletableFuture<?> closeFuture) {
        ((CompletableFuture)this.brokerService.removeTopicFromCache(this).thenRun(() -> {
            this.replicatedSubscriptionsController.ifPresent(ReplicatedSubscriptionsController::close);
            this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::close);
            this.subscribeRateLimiter.ifPresent(SubscribeRateLimiter::close);
            this.unregisterTopicPolicyListener();
            log.info("[{}] Topic closed", (Object)this.topic);
            this.cancelFencedTopicMonitoringTask();
            closeFuture.complete(null);
        })).exceptionally(ex -> {
            closeFuture.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    @VisibleForTesting
    CompletableFuture<Void> checkReplicationAndRetryOnFailure() {
        if (this.isClosed()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.checkReplication().thenAccept(res -> result.complete(null))).exceptionally(th -> {
            log.error("[{}] Policies update failed {}, scheduled retry in {} seconds", new Object[]{this.topic, th.getMessage(), 60L, th});
            if (!(th.getCause() instanceof BrokerServiceException.TopicFencedException)) {
                this.brokerService.executor().schedule(this::checkReplicationAndRetryOnFailure, 60L, TimeUnit.SECONDS);
            }
            result.completeExceptionally((Throwable)th);
            return null;
        });
        return result;
    }

    public CompletableFuture<Void> checkDeduplicationStatus() {
        return this.messageDeduplication.checkStatus();
    }

    @VisibleForTesting
    CompletableFuture<Void> checkPersistencePolicies() {
        TopicName topicName = TopicName.get((String)this.topic);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ((CompletableFuture)this.brokerService.getManagedLedgerConfig(topicName).thenAccept(config -> {
            this.ledger.setConfig(config);
            future.complete(null);
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to update persistence-policies {}", (Object)this.topic, (Object)ex.getMessage());
            future.completeExceptionally((Throwable)ex);
            return null;
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> checkReplication() {
        List configuredClusters;
        TopicName name = TopicName.get((String)this.topic);
        if (!name.isGlobal() || NamespaceService.isHeartbeatNamespace((ServiceUnitId)name) || ExtensibleLoadManagerImpl.isInternalTopic(this.topic)) {
            return CompletableFuture.completedFuture(null);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Checking replication status", (Object)name);
        }
        if (CollectionUtils.isEmpty((Collection)(configuredClusters = (List)this.topicPolicies.getReplicationClusters().get()))) {
            log.warn("[{}] No replication clusters configured", (Object)name);
            return CompletableFuture.completedFuture(null);
        }
        String localCluster = this.brokerService.pulsar().getConfiguration().getClusterName();
        return this.removeTopicIfLocalClusterNotAllowed().thenCompose(topicRemoved -> {
            if (topicRemoved.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            int newMessageTTLInSeconds = (Integer)this.topicPolicies.getMessageTTLInSeconds().get();
            this.removeTerminatedReplicators(this.replicators);
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            if (configuredClusters.size() != 1 || !this.replicators.isEmpty()) {
                for (String cluster2 : configuredClusters) {
                    if (cluster2.equals(localCluster) || this.replicators.containsKey(cluster2)) continue;
                    futures.add(this.startReplicator(cluster2));
                }
                this.replicators.forEach((cluster, replicator) -> {
                    ((PersistentReplicator)replicator).updateMessageTTL(newMessageTTLInSeconds);
                    if (!cluster.equals(localCluster) && !configuredClusters.contains(cluster)) {
                        futures.add(this.removeReplicator((String)cluster));
                    }
                });
            }
            futures.add(this.checkShadowReplication());
            return FutureUtil.waitForAll(futures);
        });
    }

    CompletableFuture<Void> deleteSchemaAndPoliciesIfClusterRemoved() {
        String localCluster = this.brokerService.pulsar().getConfiguration().getClusterName();
        TopicName tName = TopicName.get((String)this.topic);
        if (!tName.isPartitioned()) {
            return CompletableFuture.completedFuture(null);
        }
        TopicName partitionedName = TopicName.get((String)tName.getPartitionedTopicName());
        return this.brokerService.getPulsar().getPulsarResources().getNamespaceResources().getPartitionedTopicResources().getPartitionedTopicMetadataAsync(partitionedName).thenApply(metadataOp -> {
            if (metadataOp.isEmpty()) {
                return null;
            }
            AtomicInteger checkedCounter = new AtomicInteger(((PartitionedTopicMetadata)metadataOp.get()).partitions);
            for (int i = 0; i < ((PartitionedTopicMetadata)metadataOp.get()).partitions; ++i) {
                this.brokerService.getPulsar().getPulsarResources().getTopicResources().persistentTopicExists(partitionedName.getPartition(i)).thenAccept(b -> {
                    if (!b.booleanValue()) {
                        int leftPartitions = checkedCounter.decrementAndGet();
                        log.info("[{}] partitions: {}, left: {}", new Object[]{tName, ((PartitionedTopicMetadata)metadataOp.get()).partitions, leftPartitions});
                        if (leftPartitions == 0) {
                            boolean changeEventsAlsoBeingDeleted;
                            this.brokerService.getPulsar().getSchemaStorage().delete(partitionedName.getSchemaName()).whenComplete((schemaVersion, ex) -> {
                                if (ex == null) {
                                    log.info("Deleted schema[{}] after all partitions[{}] were removed because the current cluster has bee removed from topic/namespace policies", (Object)partitionedName, (Object)((PartitionedTopicMetadata)metadataOp.get()).partitions);
                                } else {
                                    log.error("Failed to delete schema[{}] after all partitions[{}] were removed,  when the current cluster has bee removed from topic/namespace policies", new Object[]{partitionedName, ((PartitionedTopicMetadata)metadataOp.get()).partitions, ex});
                                }
                            });
                            boolean bl = changeEventsAlsoBeingDeleted = !((List)this.topicPolicies.getReplicationClusters().getNamespaceValue()).contains(localCluster);
                            if (changeEventsAlsoBeingDeleted) {
                                log.info("Skip to deleted topic policies[{}] after all partitions[{}] were removed because the system topic __change_events will be removed.", (Object)partitionedName, (Object)((PartitionedTopicMetadata)metadataOp.get()).partitions);
                                return;
                            }
                            this.brokerService.getPulsar().getTopicPoliciesService().deleteTopicPoliciesAsync(partitionedName, true).whenComplete((__, ex) -> {
                                if (ex == null) {
                                    log.info("Deleted topic policies[{}] after all partitions[{}] were removed because the current cluster has bee removed from topic policies. Global policies will not be deleted.", (Object)partitionedName, (Object)((PartitionedTopicMetadata)metadataOp.get()).partitions);
                                } else {
                                    log.error("Failed to delete topic policies[{}] after all partitions[{}] were removed,  when the current cluster has bee removed from topic policies", new Object[]{partitionedName, ((PartitionedTopicMetadata)metadataOp.get()).partitions, ex});
                                }
                            });
                        }
                    }
                });
            }
            return null;
        });
    }

    protected CompletableFuture<Boolean> removeTopicIfLocalClusterNotAllowed() {
        String localCluster = this.brokerService.pulsar().getConfiguration().getClusterName();
        return this.checkAllowedCluster(localCluster).thenCompose(isAllowed -> {
            if (!isAllowed.booleanValue()) {
                return this.deleteForcefully().thenCompose(ignore -> this.deleteSchemaAndPoliciesIfClusterRemoved().thenApply(__ -> true));
            }
            return CompletableFuture.completedFuture(false);
        });
    }

    protected CompletableFuture<Boolean> checkAllowedCluster(String localCluster) {
        List topicRepls = (List)this.topicPolicies.getReplicationClusters().get();
        return this.brokerService.pulsar().getPulsarResources().getNamespaceResources().getPoliciesAsync(TopicName.get((String)this.topic).getNamespaceObject()).thenCompose(nsPolicies -> {
            Set allowedClusters = Set.of();
            if (nsPolicies.isPresent()) {
                allowedClusters = ((Policies)nsPolicies.get()).allowed_clusters;
            }
            if (TopicName.get((String)this.topic).isGlobal() && !topicRepls.contains(localCluster) && !allowedClusters.contains(localCluster)) {
                log.warn("Local cluster {} is not part of global namespace repl list {} and allowed list {}", new Object[]{localCluster, topicRepls, allowedClusters});
                return CompletableFuture.completedFuture(false);
            }
            return CompletableFuture.completedFuture(true);
        });
    }

    private CompletableFuture<Void> checkShadowReplication() {
        if (CollectionUtils.isEmpty(this.shadowTopics)) {
            return CompletableFuture.completedFuture(null);
        }
        List<String> configuredShadowTopics = this.shadowTopics;
        int newMessageTTLInSeconds = (Integer)this.topicPolicies.getMessageTTLInSeconds().get();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Checking shadow replication status, shadowTopics={}", (Object)this.topic, configuredShadowTopics);
        }
        this.removeTerminatedReplicators(this.shadowReplicators);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (String shadowTopic2 : configuredShadowTopics) {
            if (this.shadowReplicators.containsKey(shadowTopic2)) continue;
            futures.add(this.startShadowReplicator(shadowTopic2));
        }
        this.shadowReplicators.forEach((shadowTopic, replicator) -> {
            ((PersistentReplicator)replicator).updateMessageTTL(newMessageTTLInSeconds);
            if (!configuredShadowTopics.contains(shadowTopic)) {
                futures.add(this.removeShadowReplicator((String)shadowTopic));
            }
        });
        return FutureUtil.waitForAll(futures);
    }

    @Override
    public void checkMessageExpiry() {
        int messageTtlInSeconds = (Integer)this.topicPolicies.getMessageTTLInSeconds().get();
        if (messageTtlInSeconds <= 0) {
            return;
        }
        ManagedLedger managedLedger = this.getManagedLedger();
        if (managedLedger instanceof ManagedLedgerImpl) {
            ManagedLedgerImpl ml = (ManagedLedgerImpl)managedLedger;
            this.checkMessageExpiryWithSharedPosition(ml, messageTtlInSeconds);
        } else {
            this.checkMessageExpiryWithoutSharedPosition(messageTtlInSeconds);
        }
    }

    private void checkMessageExpiryWithoutSharedPosition(int messageTtlInSeconds) {
        this.subscriptions.forEach((__, sub) -> {
            if (!(PersistentTopic.isCompactionSubscription(sub.getName()) || !this.additionalSystemCursorNames.isEmpty() && this.additionalSystemCursorNames.contains(sub.getName()))) {
                sub.expireMessagesAsync(messageTtlInSeconds);
            }
        });
        this.replicators.forEach((__, replicator) -> ((PersistentReplicator)replicator).expireMessagesAsync(messageTtlInSeconds));
        this.shadowReplicators.forEach((__, replicator) -> ((PersistentReplicator)replicator).expireMessagesAsync(messageTtlInSeconds));
    }

    private void checkMessageExpiryWithSharedPosition(ManagedLedgerImpl ml, int messageTtlInSeconds) {
        ManagedCursorContainer.CursorInfo cursorWithOldestPosition = ml.getCursors().getCursorWithOldestPosition();
        if (cursorWithOldestPosition == null) {
            return;
        }
        ManagedCursor cursor = cursorWithOldestPosition.getCursor();
        PersistentMessageFinder finder = new PersistentMessageFinder(this.topic, cursor, this.brokerService.getPulsar().getConfig().getManagedLedgerCursorResetLedgerCloseTimestampMaxClockSkewMillis());
        long expiredMessageTimestamp = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(messageTtlInSeconds);
        final CompletableFuture positionToMarkDelete = new CompletableFuture();
        finder.findMessages(expiredMessageTimestamp, new AsyncCallbacks.FindEntryCallback(){

            public void findEntryComplete(Position position, Object ctx) {
                positionToMarkDelete.complete(position);
            }

            public void findEntryFailed(ManagedLedgerException exception, Optional<Position> failedReadPosition, Object ctx) {
                log.error("[{}] Error finding expired position, failed reading position is {}", new Object[]{PersistentTopic.this.topic, failedReadPosition.orElse(null), exception});
                positionToMarkDelete.complete(null);
            }
        });
        ((CompletableFuture)positionToMarkDelete.thenAccept(position -> {
            if (position == null) {
                return;
            }
            this.subscriptions.forEach((__, sub) -> {
                if (!(PersistentTopic.isCompactionSubscription(sub.getName()) || !this.additionalSystemCursorNames.isEmpty() && this.additionalSystemCursorNames.contains(sub.getName()))) {
                    sub.expireMessages((Position)position);
                }
            });
            this.replicators.forEach((__, replicator) -> ((PersistentReplicator)replicator).expireMessages((Position)position));
            this.shadowReplicators.forEach((__, replicator) -> ((PersistentReplicator)replicator).expireMessages((Position)position));
        })).exceptionally(ex -> {
            log.error("[{}] Failed to expire messages by position", (Object)this.topic, ex);
            return null;
        });
    }

    @Override
    public void checkMessageDeduplicationInfo() {
        this.messageDeduplication.purgeInactiveProducers();
    }

    public boolean isCompactionEnabled() {
        Long compactionThreshold = (Long)this.topicPolicies.getCompactionThreshold().get();
        return compactionThreshold != null && compactionThreshold > 0L;
    }

    public void checkCompaction() {
        TopicName name = TopicName.get((String)this.topic);
        try {
            long compactionThreshold = (Long)this.topicPolicies.getCompactionThreshold().get();
            if (this.isCompactionEnabled() && this.currentCompaction.isDone()) {
                long backlogEstimate = 0L;
                PersistentSubscription compactionSub = this.subscriptions.get("__compaction");
                if (compactionSub != null) {
                    backlogEstimate = compactionSub.estimateBacklogSize();
                } else {
                    long l = backlogEstimate = this.subscriptions.isEmpty() || this.subscriptions.values().stream().noneMatch(sub -> sub.getCursor().isDurable()) ? this.ledger.getTotalSize() : this.ledger.getEstimatedBacklogSize();
                }
                if (backlogEstimate > compactionThreshold) {
                    if (log.isDebugEnabled()) {
                        log.debug("topic:{} backlogEstimate:{} is bigger than compactionThreshold:{}. Triggering compaction", new Object[]{this.topic, backlogEstimate, compactionThreshold});
                    }
                    this.triggerCompactionWithCheckHasMoreMessages();
                }
            }
        }
        catch (Exception e) {
            log.warn("[{}] Error getting policies and skipping compaction check", (Object)this.topic, (Object)e);
        }
    }

    public CompletableFuture<Void> preCreateSubscriptionForCompactionIfNeeded() {
        if (this.subscriptions.containsKey("__compaction")) {
            return CompletableFuture.completedFuture(null);
        }
        return this.isCompactionEnabled() ? this.createSubscription("__compaction", CommandSubscribe.InitialPosition.Earliest, false, null).thenCompose(__ -> CompletableFuture.completedFuture(null)) : CompletableFuture.completedFuture(null);
    }

    CompletableFuture<Void> startReplicator(final String remoteCluster) {
        log.info("[{}] Starting replicator to remote: {}", (Object)this.topic, (Object)remoteCluster);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        String name = PersistentReplicator.getReplicatorName(this.replicatorPrefix, remoteCluster);
        String replicationStartAt = this.getBrokerService().getPulsar().getConfiguration().getReplicationStartAt();
        CommandSubscribe.InitialPosition initialPosition = MessageId.earliest.toString().equalsIgnoreCase(replicationStartAt) || CommandSubscribe.InitialPosition.Earliest.name().equalsIgnoreCase(replicationStartAt) ? CommandSubscribe.InitialPosition.Earliest : CommandSubscribe.InitialPosition.Latest;
        this.ledger.asyncOpenCursor(name, initialPosition, new AsyncCallbacks.OpenCursorCallback(){

            public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                String localCluster = PersistentTopic.this.brokerService.pulsar().getConfiguration().getClusterName();
                PersistentTopic.this.addReplicationCluster(remoteCluster, cursor, localCluster).whenComplete((__, ex) -> {
                    if (ex == null) {
                        future.complete(null);
                    } else {
                        future.completeExceptionally((Throwable)ex);
                    }
                });
            }

            public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null);
        return future;
    }

    protected CompletableFuture<Void> addReplicationCluster(String remoteCluster, ManagedCursor cursor, String localCluster) {
        return ((CompletableFuture)AbstractReplicator.validatePartitionedTopicAsync(this.getName(), this.brokerService).thenCompose(__ -> this.brokerService.pulsar().getPulsarResources().getClusterResources().getClusterAsync(remoteCluster).thenApply(clusterData -> this.brokerService.getReplicationClient(remoteCluster, (Optional<ClusterData>)clusterData)))).thenAccept(replicationClient -> {
            if (replicationClient == null) {
                log.error("[{}] Can not create replicator because the remote client can not be created. remote cluster: {}. State of transferring : {}", new Object[]{this.topic, remoteCluster, this.transferring});
                return;
            }
            this.lock.readLock().lock();
            try {
                if (this.isClosingOrDeleting) {
                    log.info("[{}] Skip to create replicator because this topic is closing. remote cluster: {}. State of transferring : {}", new Object[]{this.topic, remoteCluster, this.transferring});
                    return;
                }
                Replicator replicator = this.replicators.computeIfAbsent(remoteCluster, r -> {
                    try {
                        return new GeoPersistentReplicator(this, cursor, localCluster, remoteCluster, this.brokerService, (PulsarClientImpl)replicationClient);
                    }
                    catch (PulsarServerException e) {
                        log.error("[{}] Replicator startup failed {}", new Object[]{this.topic, remoteCluster, e});
                        return null;
                    }
                });
            }
            finally {
                this.lock.readLock().unlock();
            }
        });
    }

    CompletableFuture<Void> removeReplicator(final String remoteCluster) {
        log.info("[{}] Removing replicator to {}", (Object)this.topic, (Object)remoteCluster);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        final String name = PersistentReplicator.getReplicatorName(this.replicatorPrefix, remoteCluster);
        ((CompletableFuture)Optional.ofNullable(this.replicators.get(remoteCluster)).map(Replicator::terminate).orElse(CompletableFuture.completedFuture(null)).thenRun(() -> this.ledger.asyncDeleteCursor(name, new AsyncCallbacks.DeleteCursorCallback(){

            public void deleteCursorComplete(Object ctx) {
                PersistentTopic.this.replicators.remove(remoteCluster);
                future.complete(null);
            }

            public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to delete cursor {} {}", new Object[]{PersistentTopic.this.topic, name, exception.getMessage(), exception});
                future.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null))).exceptionally(e -> {
            log.error("[{}] Failed to close replication producer {} {}", new Object[]{this.topic, name, e.getMessage(), e});
            future.completeExceptionally((Throwable)e);
            return null;
        });
        return future;
    }

    CompletableFuture<Void> startShadowReplicator(String shadowTopic) {
        ManagedCursor cursor;
        log.info("[{}] Starting shadow topic replicator to remote: {}", (Object)this.topic, (Object)shadowTopic);
        String name = ShadowReplicator.getShadowReplicatorName(this.replicatorPrefix, shadowTopic);
        try {
            cursor = this.ledger.newNonDurableCursor(PositionFactory.LATEST, name);
        }
        catch (ManagedLedgerException e) {
            log.error("[{}]Open non-durable cursor for shadow replicator failed, name={}", new Object[]{this.topic, name, e});
            return FutureUtil.failedFuture((Throwable)e);
        }
        CompletableFuture<Void> future = this.addShadowReplicationCluster(shadowTopic, cursor);
        future.exceptionally(ex -> {
            log.error("[{}] Add shadow replication cluster failed, shadowTopic={}", new Object[]{this.topic, shadowTopic, ex});
            return null;
        });
        return future;
    }

    protected CompletableFuture<Void> addShadowReplicationCluster(String shadowTopic, ManagedCursor cursor) {
        String localCluster = this.brokerService.pulsar().getConfiguration().getClusterName();
        return ((CompletableFuture)AbstractReplicator.validatePartitionedTopicAsync(this.getName(), this.brokerService).thenCompose(__ -> this.brokerService.pulsar().getPulsarResources().getClusterResources().getClusterAsync(localCluster).thenApply(clusterData -> this.brokerService.getReplicationClient(localCluster, (Optional<ClusterData>)clusterData)))).thenAccept(replicationClient -> {
            Replicator replicator = this.shadowReplicators.computeIfAbsent(shadowTopic, r -> {
                try {
                    TopicName sourceTopicName = TopicName.get((String)this.getName());
                    Object shadowPartitionTopic = shadowTopic;
                    if (sourceTopicName.isPartitioned()) {
                        shadowPartitionTopic = (String)shadowPartitionTopic + "-partition-" + sourceTopicName.getPartitionIndex();
                    }
                    return new ShadowReplicator((String)shadowPartitionTopic, this, cursor, this.brokerService, (PulsarClientImpl)replicationClient);
                }
                catch (PulsarServerException e) {
                    log.error("[{}] ShadowReplicator startup failed {}", new Object[]{this.topic, shadowTopic, e});
                    return null;
                }
            });
        });
    }

    CompletableFuture<Void> removeShadowReplicator(final String shadowTopic) {
        log.info("[{}] Removing shadow topic replicator to {}", (Object)this.topic, (Object)shadowTopic);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        final String name = ShadowReplicator.getShadowReplicatorName(this.replicatorPrefix, shadowTopic);
        ((CompletableFuture)this.shadowReplicators.get(shadowTopic).terminate().thenRun(() -> this.ledger.asyncDeleteCursor(name, new AsyncCallbacks.DeleteCursorCallback(){

            public void deleteCursorComplete(Object ctx) {
                PersistentTopic.this.shadowReplicators.remove(shadowTopic);
                future.complete(null);
            }

            public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to delete shadow topic replication cursor {} {}", new Object[]{PersistentTopic.this.topic, name, exception.getMessage(), exception});
                future.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null))).exceptionally(e -> {
            log.error("[{}] Failed to close shadow topic replication producer {} {}", new Object[]{this.topic, name, e.getMessage(), e});
            future.completeExceptionally((Throwable)e);
            return null;
        });
        return future;
    }

    @Override
    public int getNumberOfConsumers() {
        return this.getNumberOfConsumers(this.subscriptions.values());
    }

    @Override
    public int getNumberOfSameAddressConsumers(String clientAddress) {
        return this.getNumberOfSameAddressConsumers(clientAddress, this.subscriptions.values());
    }

    @Override
    protected String getSchemaId() {
        if (this.shadowSourceTopic == null) {
            return super.getSchemaId();
        }
        String base = this.shadowSourceTopic.getPartitionedTopicName();
        return TopicName.get((String)base).getSchemaName();
    }

    public Map<String, PersistentSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public PersistentSubscription getSubscription(String subscriptionName) {
        return this.subscriptions.get(subscriptionName);
    }

    public Map<String, Replicator> getReplicators() {
        return this.replicators;
    }

    public Map<String, Replicator> getShadowReplicators() {
        return this.shadowReplicators;
    }

    public Replicator getPersistentReplicator(String remoteCluster) {
        return this.replicators.get(remoteCluster);
    }

    public ManagedLedger getManagedLedger() {
        return this.ledger;
    }

    @Override
    public void updateRates(NamespaceStats nsStats, NamespaceBundleStats bundleStats, StatsOutputStream topicStatsStream, ClusterReplicationMetrics replStats, String namespace, boolean hydratePublishers) {
        this.publishRateLimitedTimes = 0L;
        TopicStatsHelper topicStatsHelper = (TopicStatsHelper)threadLocalTopicStats.get();
        topicStatsHelper.reset();
        this.replicators.forEach((region, replicator) -> replicator.updateRates());
        MutableInt producerCount = new MutableInt();
        topicStatsStream.startObject(this.topic);
        topicStatsStream.startList("publishers");
        this.producers.values().forEach(producer -> {
            producer.updateRates();
            PublisherStatsImpl publisherStats = producer.getStats();
            topicStatsHelper.aggMsgRateIn += publisherStats.msgRateIn;
            topicStatsHelper.aggMsgThroughputIn += publisherStats.msgThroughputIn;
            if (producer.isRemote()) {
                topicStatsHelper.remotePublishersStats.put((Object)producer.getRemoteCluster(), (Object)publisherStats);
            } else {
                producerCount.increment();
                if (hydratePublishers) {
                    StreamingStats.writePublisherStats(topicStatsStream, publisherStats);
                }
            }
        });
        topicStatsStream.endList();
        nsStats.producerCount += producerCount.intValue();
        bundleStats.producerCount += producerCount.intValue();
        this.lastUpdatedAvgPublishRateInMsg = topicStatsHelper.aggMsgRateIn > this.lastUpdatedAvgPublishRateInMsg ? topicStatsHelper.aggMsgRateIn : (topicStatsHelper.aggMsgRateIn + this.lastUpdatedAvgPublishRateInMsg) / 2.0;
        this.lastUpdatedAvgPublishRateInByte = topicStatsHelper.aggMsgThroughputIn > this.lastUpdatedAvgPublishRateInByte ? topicStatsHelper.aggMsgThroughputIn : (topicStatsHelper.aggMsgThroughputIn + this.lastUpdatedAvgPublishRateInByte) / 2.0;
        topicStatsStream.startObject("replication");
        nsStats.replicatorCount += topicStatsHelper.remotePublishersStats.size();
        this.replicators.forEach((cluster, replicator) -> {
            try {
                ((PersistentReplicator)replicator).updateCursorState();
            }
            catch (Exception e) {
                log.warn("[{}] Failed to update cursor state ", (Object)this.topic, (Object)e);
            }
            ReplicatorStatsImpl rStat = replicator.computeStats();
            PublisherStatsImpl pubStats = (PublisherStatsImpl)topicStatsHelper.remotePublishersStats.get((Object)replicator.getRemoteCluster());
            rStat.msgRateIn = pubStats != null ? pubStats.msgRateIn : 0.0;
            rStat.msgThroughputIn = pubStats != null ? pubStats.msgThroughputIn : 0.0;
            rStat.inboundConnection = pubStats != null ? pubStats.getAddress() : null;
            rStat.inboundConnectedSince = pubStats != null ? pubStats.getConnectedSince() : null;
            topicStatsHelper.aggMsgRateOut += rStat.msgRateOut;
            topicStatsHelper.aggMsgThroughputOut += rStat.msgThroughputOut;
            topicStatsStream.startObject((String)cluster);
            topicStatsStream.writePair("connected", rStat.connected);
            topicStatsStream.writePair("msgRateExpired", rStat.msgRateExpired);
            topicStatsStream.writePair("msgRateIn", rStat.msgRateIn);
            topicStatsStream.writePair("msgRateOut", rStat.msgRateOut);
            topicStatsStream.writePair("msgThroughputIn", rStat.msgThroughputIn);
            topicStatsStream.writePair("msgThroughputOut", rStat.msgThroughputOut);
            topicStatsStream.writePair("replicationBacklog", rStat.replicationBacklog);
            topicStatsStream.writePair("replicationDelayInSeconds", rStat.replicationDelayInSeconds);
            topicStatsStream.writePair("inboundConnection", rStat.inboundConnection);
            topicStatsStream.writePair("inboundConnectedSince", rStat.inboundConnectedSince);
            topicStatsStream.writePair("outboundConnection", rStat.outboundConnection);
            topicStatsStream.writePair("outboundConnectedSince", rStat.outboundConnectedSince);
            topicStatsStream.endObject();
            nsStats.msgReplBacklog += (double)rStat.replicationBacklog;
            if (replStats.isMetricsEnabled()) {
                String namespaceClusterKey = replStats.getKeyName(namespace, (String)cluster);
                ReplicationMetrics replicationMetrics = replStats.get(namespaceClusterKey);
                boolean update = false;
                if (replicationMetrics == null) {
                    replicationMetrics = ReplicationMetrics.get();
                    update = true;
                }
                replicationMetrics.connected = replicationMetrics.connected + (rStat.connected ? 1 : 0);
                replicationMetrics.msgRateOut += rStat.msgRateOut;
                replicationMetrics.msgThroughputOut += rStat.msgThroughputOut;
                replicationMetrics.msgReplBacklog += (double)rStat.replicationBacklog;
                if (update) {
                    replStats.put(namespaceClusterKey, replicationMetrics);
                }
                if ((double)rStat.replicationDelayInSeconds > replicationMetrics.maxMsgReplDelayInSeconds) {
                    replicationMetrics.maxMsgReplDelayInSeconds = rStat.replicationDelayInSeconds;
                }
            }
        });
        topicStatsStream.endObject();
        topicStatsStream.startObject("subscriptions");
        nsStats.subsCount += (long)this.subscriptions.size();
        this.subscriptions.forEach((subscriptionName, subscription) -> {
            double subMsgRateOut = 0.0;
            double subMsgThroughputOut = 0.0;
            double subMsgRateRedeliver = 0.0;
            double subMsgAckRate = 0.0;
            try {
                topicStatsStream.startObject((String)subscriptionName);
                topicStatsStream.startList("consumers");
                for (Consumer consumer : subscription.getConsumers()) {
                    ++nsStats.consumerCount;
                    ++bundleStats.consumerCount;
                    consumer.updateRates();
                    ConsumerStatsImpl consumerStats = consumer.getStats();
                    subMsgRateOut += consumerStats.msgRateOut;
                    subMsgAckRate += consumerStats.messageAckRate;
                    subMsgThroughputOut += consumerStats.msgThroughputOut;
                    subMsgRateRedeliver += consumerStats.msgRateRedeliver;
                    StreamingStats.writeConsumerStats(topicStatsStream, subscription.getType(), consumerStats);
                }
                topicStatsStream.endList();
                topicStatsStream.writePair("msgBacklog", subscription.getNumberOfEntriesInBacklog(true));
                subscription.getExpiryMonitor().updateRates();
                topicStatsStream.writePair("msgRateExpired", subscription.getExpiredMessageRate());
                topicStatsStream.writePair("msgRateOut", subMsgRateOut);
                topicStatsStream.writePair("messageAckRate", subMsgAckRate);
                topicStatsStream.writePair("msgThroughputOut", subMsgThroughputOut);
                topicStatsStream.writePair("msgRateRedeliver", subMsgRateRedeliver);
                topicStatsStream.writePair("numberOfEntriesSinceFirstNotAckedMessage", subscription.getNumberOfEntriesSinceFirstNotAckedMessage());
                topicStatsStream.writePair("totalNonContiguousDeletedMessagesRange", subscription.getTotalNonContiguousDeletedMessagesRange());
                topicStatsStream.writePair("type", subscription.getTypeString());
                Dispatcher dispatcher0 = subscription.getDispatcher();
                if (null != dispatcher0) {
                    topicStatsStream.writePair("filterProcessedMsgCount", dispatcher0.getFilterProcessedMsgCount());
                    topicStatsStream.writePair("filterAcceptedMsgCount", dispatcher0.getFilterAcceptedMsgCount());
                    topicStatsStream.writePair("filterRejectedMsgCount", dispatcher0.getFilterRejectedMsgCount());
                    topicStatsStream.writePair("filterRescheduledMsgCount", dispatcher0.getFilterRescheduledMsgCount());
                }
                if (Subscription.isIndividualAckMode(subscription.getType()) && subscription.getDispatcher() instanceof AbstractPersistentDispatcherMultipleConsumers) {
                    AbstractPersistentDispatcherMultipleConsumers dispatcher = (AbstractPersistentDispatcherMultipleConsumers)subscription.getDispatcher();
                    topicStatsStream.writePair("blockedSubscriptionOnUnackedMsgs", dispatcher.isBlockedDispatcherOnUnackedMsgs());
                    topicStatsStream.writePair("unackedMessages", dispatcher.getTotalUnackedMessages());
                }
                topicStatsStream.endObject();
                topicStatsHelper.aggMsgRateOut += subMsgRateOut;
                topicStatsHelper.aggMsgThroughputOut += subMsgThroughputOut;
                nsStats.msgBacklog += (double)subscription.getNumberOfEntriesInBacklog(false);
                if (this.brokerService.getPulsar().getConfig().isUnblockStuckSubscriptionEnabled()) {
                    subscription.checkAndUnblockIfStuck();
                }
            }
            catch (Exception e) {
                log.error("Got exception when creating consumer stats for subscription {}: {}", new Object[]{subscriptionName, e.getMessage(), e});
            }
        });
        topicStatsStream.endObject();
        topicStatsHelper.averageMsgSize = topicStatsHelper.aggMsgRateIn == 0.0 ? 0.0 : topicStatsHelper.aggMsgThroughputIn / topicStatsHelper.aggMsgRateIn;
        topicStatsStream.writePair("producerCount", producerCount.intValue());
        topicStatsStream.writePair("averageMsgSize", topicStatsHelper.averageMsgSize);
        topicStatsStream.writePair("msgRateIn", topicStatsHelper.aggMsgRateIn);
        topicStatsStream.writePair("msgRateOut", topicStatsHelper.aggMsgRateOut);
        topicStatsStream.writePair("msgInCount", this.getMsgInCounter());
        topicStatsStream.writePair("bytesInCount", this.getBytesInCounter());
        topicStatsStream.writePair("msgOutCount", this.getMsgOutCounter());
        topicStatsStream.writePair("bytesOutCount", this.getBytesOutCounter());
        topicStatsStream.writePair("msgThroughputIn", topicStatsHelper.aggMsgThroughputIn);
        topicStatsStream.writePair("msgThroughputOut", topicStatsHelper.aggMsgThroughputOut);
        topicStatsStream.writePair("storageSize", this.ledger.getTotalSize());
        topicStatsStream.writePair("backlogSize", this.ledger.getEstimatedBacklogSize());
        topicStatsStream.writePair("pendingAddEntriesCount", this.ledger.getPendingAddEntriesCount());
        topicStatsStream.writePair("filteredEntriesCount", this.getFilteredEntriesCount());
        nsStats.msgRateIn += topicStatsHelper.aggMsgRateIn;
        nsStats.msgRateOut += topicStatsHelper.aggMsgRateOut;
        nsStats.msgThroughputIn += topicStatsHelper.aggMsgThroughputIn;
        nsStats.msgThroughputOut += topicStatsHelper.aggMsgThroughputOut;
        nsStats.storageSize += (double)this.ledger.getEstimatedBacklogSize();
        bundleStats.msgRateIn += topicStatsHelper.aggMsgRateIn;
        bundleStats.msgRateOut += topicStatsHelper.aggMsgRateOut;
        bundleStats.msgThroughputIn += topicStatsHelper.aggMsgThroughputIn;
        bundleStats.msgThroughputOut += topicStatsHelper.aggMsgThroughputOut;
        bundleStats.cacheSize += this.ledger.getCacheSize();
        topicStatsStream.endObject();
        this.addEntryLatencyStatsUsec.refresh();
        NamespaceStats.add(this.addEntryLatencyStatsUsec.getBuckets(), nsStats.addLatencyBucket);
        this.addEntryLatencyStatsUsec.reset();
    }

    public double getLastUpdatedAvgPublishRateInMsg() {
        return this.lastUpdatedAvgPublishRateInMsg;
    }

    public double getLastUpdatedAvgPublishRateInByte() {
        return this.lastUpdatedAvgPublishRateInByte;
    }

    @Override
    public TopicStatsImpl getStats(boolean getPreciseBacklog, boolean subscriptionBacklogSize, boolean getEarliestTimeInBacklog) {
        try {
            return this.asyncGetStats(getPreciseBacklog, subscriptionBacklogSize, getEarliestTimeInBacklog).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("[{}] Fail to get stats", (Object)this.topic, (Object)e);
            return null;
        }
    }

    @Override
    public TopicStatsImpl getStats(GetStatsOptions getStatsOptions) {
        try {
            return this.asyncGetStats(getStatsOptions).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("[{}] Fail to get stats", (Object)this.topic, (Object)e);
            return null;
        }
    }

    public CompletableFuture<TopicStatsImpl> asyncGetStats(boolean getPreciseBacklog, boolean subscriptionBacklogSize, boolean getEarliestTimeInBacklog) {
        GetStatsOptions getStatsOptions = new GetStatsOptions(getPreciseBacklog, subscriptionBacklogSize, getEarliestTimeInBacklog, false, false);
        return this.asyncGetStats(getStatsOptions);
    }

    @Override
    public CompletableFuture<? extends TopicStatsImpl> asyncGetStats(GetStatsOptions getStatsOptions) {
        CompletableFuture<Long> lastPublishTimeFuture;
        TopicStatsImpl stats = new TopicStatsImpl();
        ObjectObjectHashMap remotePublishersStats = new ObjectObjectHashMap();
        this.producers.values().forEach(producer -> {
            PublisherStatsImpl publisherStats = producer.getStats();
            stats.msgRateIn += publisherStats.msgRateIn;
            stats.msgThroughputIn += publisherStats.msgThroughputIn;
            if (producer.isRemote()) {
                remotePublishersStats.put((Object)producer.getRemoteCluster(), (Object)publisherStats);
            } else if (!getStatsOptions.isExcludePublishers()) {
                stats.addPublisher(publisherStats);
            }
        });
        stats.averageMsgSize = stats.msgRateIn == 0.0 ? 0.0 : stats.msgThroughputIn / stats.msgRateIn;
        stats.msgInCounter = this.getMsgInCounter();
        stats.bytesInCounter = this.getBytesInCounter();
        stats.systemTopicBytesInCounter = this.getSystemTopicBytesInCounter();
        stats.msgChunkPublished = this.msgChunkPublished;
        stats.waitingPublishers = this.getWaitingProducersCount();
        stats.bytesOutCounter = this.bytesOutFromRemovedSubscriptions.longValue();
        stats.msgOutCounter = this.msgOutFromRemovedSubscriptions.longValue();
        stats.bytesOutInternalCounter = this.bytesOutFromRemovedSystemSubscriptions.longValue();
        stats.publishRateLimitedTimes = this.publishRateLimitedTimes;
        TransactionBuffer txnBuffer = this.getTransactionBuffer();
        stats.ongoingTxnCount = txnBuffer.getOngoingTxnCount();
        stats.abortedTxnCount = txnBuffer.getAbortedTxnCount();
        stats.committedTxnCount = txnBuffer.getCommittedTxnCount();
        this.replicators.forEach((cluster, replicator) -> {
            ReplicatorStatsImpl replicatorStats = replicator.computeStats();
            PublisherStatsImpl pubStats = (PublisherStatsImpl)remotePublishersStats.get((Object)replicator.getRemoteCluster());
            if (pubStats != null) {
                replicatorStats.msgRateIn = pubStats.msgRateIn;
                replicatorStats.msgThroughputIn = pubStats.msgThroughputIn;
                replicatorStats.inboundConnection = pubStats.getAddress();
                replicatorStats.inboundConnectedSince = pubStats.getConnectedSince();
            }
            stats.msgRateOut += replicatorStats.msgRateOut;
            stats.msgThroughputOut += replicatorStats.msgThroughputOut;
            stats.replication.put(replicator.getRemoteCluster(), replicatorStats);
        });
        stats.storageSize = this.ledger.getTotalSize();
        stats.backlogSize = this.ledger.getEstimatedBacklogSize();
        stats.deduplicationStatus = this.messageDeduplication.getStatus().toString();
        stats.topicEpoch = this.topicEpoch.orElse(null);
        stats.ownerBroker = this.brokerService.pulsar().getBrokerId();
        stats.offloadedStorageSize = this.ledger.getOffloadedSize();
        stats.lastOffloadLedgerId = this.ledger.getLastOffloadedLedgerId();
        stats.lastOffloadSuccessTimeStamp = this.ledger.getLastOffloadedSuccessTimestamp();
        stats.lastOffloadFailureTimeStamp = this.ledger.getLastOffloadedFailureTimestamp();
        Optional<CompactorMXBean> mxBean = this.getCompactorMXBean();
        stats.backlogQuotaLimitSize = this.getBacklogQuota(BacklogQuota.BacklogQuotaType.destination_storage).getLimitSize();
        stats.backlogQuotaLimitTime = this.getBacklogQuota(BacklogQuota.BacklogQuotaType.message_age).getLimitTime();
        stats.oldestBacklogMessageAgeSeconds = this.getBestEffortOldestUnacknowledgedMessageAgeSeconds();
        stats.oldestBacklogMessageSubscriptionName = this.oldestPositionInfo == null ? null : this.oldestPositionInfo.getCursorName();
        long ledgerLastAddTime = this.ledger.getLastAddEntryTime();
        boolean usedLedgerValue = false;
        if (ledgerLastAddTime > 0L) {
            this.cachedLastPublishTimestamp = 0L;
            stats.lastPublishTimeStamp = ledgerLastAddTime;
            lastPublishTimeFuture = CompletableFuture.completedFuture(ledgerLastAddTime);
            usedLedgerValue = true;
        } else if (this.cachedLastPublishTimestamp > 0L) {
            lastPublishTimeFuture = CompletableFuture.completedFuture(this.cachedLastPublishTimestamp);
        } else {
            stats.lastPublishTimeStamp = 0L;
            lastPublishTimeFuture = this.getLastMessagePublishTime();
        }
        boolean finalUsedLedgerValue = usedLedgerValue;
        stats.topicCreationTimeStamp = this.getTopicCreationTimeStamp();
        stats.compaction.reset();
        mxBean.flatMap(bean -> bean.getCompactionRecordForTopic(this.topic)).map(compactionRecord -> {
            stats.compaction.lastCompactionRemovedEventCount = compactionRecord.getLastCompactionRemovedEventCount();
            stats.compaction.lastCompactionSucceedTimestamp = compactionRecord.getLastCompactionSucceedTimestamp();
            stats.compaction.lastCompactionFailedTimestamp = compactionRecord.getLastCompactionFailedTimestamp();
            stats.compaction.lastCompactionDurationTimeInMills = compactionRecord.getLastCompactionDurationTimeInMills();
            return compactionRecord;
        });
        HashMap subscriptionFutures = new HashMap();
        this.subscriptions.forEach((name, subscription) -> subscriptionFutures.put(name, subscription.getStatsAsync(getStatsOptions)));
        CompletableFuture<Void> combinedFutures = CompletableFuture.allOf(new CompletableFuture[]{lastPublishTimeFuture.thenAccept(time -> {
            if (!finalUsedLedgerValue) {
                this.cachedLastPublishTimestamp = time;
            }
            stats.lastPublishTimeStamp = time;
        })});
        return combinedFutures.thenCompose(ignore -> FutureUtil.waitForAll(subscriptionFutures.values()).thenCompose(ignore2 -> {
            for (Map.Entry e : subscriptionFutures.entrySet()) {
                String name = (String)e.getKey();
                SubscriptionStatsImpl subStats = (SubscriptionStatsImpl)((CompletableFuture)e.getValue()).join();
                stats.msgRateOut += subStats.msgRateOut;
                stats.msgThroughputOut += subStats.msgThroughputOut;
                stats.bytesOutCounter += subStats.bytesOutCounter;
                stats.msgOutCounter += subStats.msgOutCounter;
                stats.subscriptions.put(name, subStats);
                stats.nonContiguousDeletedMessagesRanges += subStats.nonContiguousDeletedMessagesRanges;
                stats.nonContiguousDeletedMessagesRangesSerializedSize += subStats.nonContiguousDeletedMessagesRangesSerializedSize;
                stats.delayedMessageIndexSizeInBytes += subStats.delayedMessageIndexSizeInBytes;
                subStats.bucketDelayedIndexStats.forEach((k, v) -> {
                    TopicMetricBean topicMetricBean = stats.bucketDelayedIndexStats.computeIfAbsent(k, key -> new TopicMetricBean());
                    topicMetricBean.name = v.name;
                    topicMetricBean.labelsAndValues = v.labelsAndValues;
                    topicMetricBean.value += v.value;
                });
                if (!this.isSystemCursor(name) && !name.startsWith("__system_reader")) continue;
                stats.bytesOutInternalCounter += subStats.bytesOutCounter;
            }
            if (getStatsOptions.isGetEarliestTimeInBacklog() && stats.backlogSize != 0L) {
                CompletionStage finalRes = this.ledger.getEarliestMessagePublishTimeInBacklog().thenApply(earliestTime -> {
                    stats.earliestMsgPublishTimeInBacklogs = earliestTime;
                    return stats;
                });
                ((CompletableFuture)finalRes).exceptionally(ex -> {
                    log.error("[{}] Failed to get earliest message publish time in backlog", (Object)this.topic, ex);
                    return null;
                });
                return finalRes;
            }
            return CompletableFuture.completedFuture(stats);
        }));
    }

    private Optional<CompactorMXBean> getCompactorMXBean() {
        Compactor compactor = this.brokerService.pulsar().getNullableCompactor();
        return Optional.ofNullable(compactor).map(c -> c.getStats());
    }

    @Override
    public CompletableFuture<SchemaVersion> deleteSchema() {
        if (TopicName.get((String)this.getName()).isPartitioned()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.brokerService.deleteSchema(TopicName.get((String)this.getName()));
    }

    @Override
    public CompletableFuture<PersistentTopicInternalStats> getInternalStats(boolean includeLedgerMetadata) {
        CompletableFuture<PersistentTopicInternalStats> statFuture = new CompletableFuture<PersistentTopicInternalStats>();
        ((CompletableFuture)this.ledger.getManagedLedgerInternalStats(includeLedgerMetadata).thenCombine(this.getCompactedTopicContextAsync(), (ledgerInternalStats, compactedTopicContext) -> {
            String schemaId;
            PersistentTopicInternalStats stats = new PersistentTopicInternalStats();
            stats.entriesAddedCounter = ledgerInternalStats.getEntriesAddedCounter();
            stats.numberOfEntries = ledgerInternalStats.getNumberOfEntries();
            stats.totalSize = ledgerInternalStats.getTotalSize();
            stats.currentLedgerEntries = ledgerInternalStats.getCurrentLedgerEntries();
            stats.currentLedgerSize = ledgerInternalStats.getCurrentLedgerSize();
            stats.lastLedgerCreatedTimestamp = ledgerInternalStats.getLastLedgerCreatedTimestamp();
            stats.lastLedgerCreationFailureTimestamp = ledgerInternalStats.getLastLedgerCreationFailureTimestamp();
            stats.waitingCursorsCount = ledgerInternalStats.getWaitingCursorsCount();
            stats.pendingAddEntriesCount = ledgerInternalStats.getPendingAddEntriesCount();
            stats.lastConfirmedEntry = ledgerInternalStats.getLastConfirmedEntry();
            stats.state = ledgerInternalStats.getState();
            stats.ledgers = ledgerInternalStats.ledgers;
            ManagedLedgerInternalStats.LedgerInfo info = new ManagedLedgerInternalStats.LedgerInfo();
            info.ledgerId = -1L;
            info.entries = -1L;
            info.size = -1L;
            if (compactedTopicContext != null) {
                info.ledgerId = compactedTopicContext.getLedger().getId();
                info.entries = compactedTopicContext.getLedger().getLastAddConfirmed() + 1L;
                info.size = compactedTopicContext.getLedger().getLength();
            }
            stats.compactedLedger = info;
            stats.cursors = new HashMap();
            this.ledger.getCursors().forEach(c -> {
                ManagedLedgerInternalStats.CursorStats cs = new ManagedLedgerInternalStats.CursorStats();
                ManagedLedgerInternalStats.CursorStats cursorInternalStats = c.getCursorStats();
                cs.markDeletePosition = cursorInternalStats.getMarkDeletePosition();
                cs.readPosition = cursorInternalStats.getReadPosition();
                cs.waitingReadOp = cursorInternalStats.isWaitingReadOp();
                cs.pendingReadOps = cursorInternalStats.getPendingReadOps();
                cs.messagesConsumedCounter = cursorInternalStats.getMessagesConsumedCounter();
                cs.cursorLedger = cursorInternalStats.getCursorLedger();
                cs.cursorLedgerLastEntry = cursorInternalStats.getCursorLedgerLastEntry();
                cs.individuallyDeletedMessages = cursorInternalStats.getIndividuallyDeletedMessages();
                cs.lastLedgerSwitchTimestamp = cursorInternalStats.getLastLedgerSwitchTimestamp();
                cs.state = cursorInternalStats.getState();
                cs.active = cursorInternalStats.isActive();
                cs.numberOfEntriesSinceFirstNotAckedMessage = cursorInternalStats.getNumberOfEntriesSinceFirstNotAckedMessage();
                cs.totalNonContiguousDeletedMessagesRange = cursorInternalStats.getTotalNonContiguousDeletedMessagesRange();
                cs.properties = cursorInternalStats.getProperties();
                PersistentSubscription sub = this.subscriptions.get(Codec.decode((String)c.getName()));
                if (sub != null) {
                    if (sub.getDispatcher() instanceof AbstractPersistentDispatcherMultipleConsumers) {
                        AbstractPersistentDispatcherMultipleConsumers dispatcher = (AbstractPersistentDispatcherMultipleConsumers)sub.getDispatcher();
                        cs.subscriptionHavePendingRead = dispatcher.isHavePendingRead();
                        cs.subscriptionHavePendingReplayRead = dispatcher.isHavePendingReplayRead();
                    } else if (sub.getDispatcher() instanceof PersistentDispatcherSingleActiveConsumer) {
                        PersistentDispatcherSingleActiveConsumer dispatcher = (PersistentDispatcherSingleActiveConsumer)sub.getDispatcher();
                        cs.subscriptionHavePendingRead = dispatcher.havePendingRead;
                    }
                }
                stats.cursors.put(c.getName(), cs);
            });
            try {
                schemaId = TopicName.get((String)this.topic).getSchemaName();
            }
            catch (Throwable t) {
                statFuture.completeExceptionally(t);
                return null;
            }
            CompletableFuture schemaStoreLedgersFuture = new CompletableFuture();
            stats.schemaLedgers = Collections.synchronizedList(new ArrayList());
            if (this.brokerService.getPulsar().getSchemaStorage() != null && this.brokerService.getPulsar().getSchemaStorage() instanceof BookkeeperSchemaStorage) {
                ((CompletableFuture)((BookkeeperSchemaStorage)this.brokerService.getPulsar().getSchemaStorage()).getStoreLedgerIdsBySchemaId(schemaId).thenAccept(ledgers -> {
                    ArrayList getLedgerMetadataFutures = new ArrayList();
                    ledgers.forEach(ledgerId -> {
                        CompletableFuture metadataFuture;
                        CompletableFuture<Object> completableFuture;
                        block4: {
                            completableFuture = new CompletableFuture<Object>();
                            getLedgerMetadataFutures.add(completableFuture);
                            metadataFuture = null;
                            try {
                                metadataFuture = this.brokerService.getPulsar().getBookKeeperClient().getLedgerMetadata(ledgerId.longValue());
                            }
                            catch (NullPointerException e2) {
                                if (!log.isDebugEnabled()) break block4;
                                log.debug("{{}} Failed to get ledger metadata for the schema ledger {}", new Object[]{this.topic, ledgerId, e2});
                            }
                        }
                        if (metadataFuture != null) {
                            ((CompletableFuture)metadataFuture.thenAccept(metadata -> {
                                ManagedLedgerInternalStats.LedgerInfo schemaLedgerInfo = new ManagedLedgerInternalStats.LedgerInfo();
                                schemaLedgerInfo.ledgerId = metadata.getLedgerId();
                                schemaLedgerInfo.entries = metadata.getLastEntryId() + 1L;
                                schemaLedgerInfo.size = metadata.getLength();
                                if (includeLedgerMetadata) {
                                    info.metadata = metadata.toSafeString();
                                }
                                stats.schemaLedgers.add(schemaLedgerInfo);
                                completableFuture.complete(null);
                            })).exceptionally(e -> {
                                log.error("[{}] Failed to get ledger metadata for the schema ledger {}", new Object[]{this.topic, ledgerId, e});
                                if (e.getCause() instanceof BKException.BKNoSuchLedgerExistsOnMetadataServerException || e.getCause() instanceof BKException.BKNoSuchLedgerExistsException) {
                                    completableFuture.complete(null);
                                    return null;
                                }
                                completableFuture.completeExceptionally((Throwable)e);
                                return null;
                            });
                        } else {
                            completableFuture.complete(null);
                        }
                    });
                    ((CompletableFuture)FutureUtil.waitForAll(getLedgerMetadataFutures).thenRun(() -> schemaStoreLedgersFuture.complete(null))).exceptionally(e -> {
                        schemaStoreLedgersFuture.completeExceptionally((Throwable)e);
                        return null;
                    });
                })).exceptionally(e -> {
                    schemaStoreLedgersFuture.completeExceptionally((Throwable)e);
                    return null;
                });
            } else {
                schemaStoreLedgersFuture.complete(null);
            }
            schemaStoreLedgersFuture.whenComplete((r, ex) -> {
                if (ex != null) {
                    statFuture.completeExceptionally((Throwable)ex);
                } else {
                    statFuture.complete(stats);
                }
            });
            return null;
        })).exceptionally(ex -> {
            statFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return statFuture;
    }

    public Optional<CompactedTopicContext> getCompactedTopicContext() {
        try {
            TopicCompactionService topicCompactionService = this.topicCompactionService;
            if (topicCompactionService instanceof PulsarTopicCompactionService) {
                PulsarTopicCompactionService pulsarCompactedService = (PulsarTopicCompactionService)topicCompactionService;
                return pulsarCompactedService.getCompactedTopic().getCompactedTopicContext();
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.warn("[{}]Fail to get ledger information for compacted topic.", (Object)this.topic);
        }
        return Optional.empty();
    }

    public CompletableFuture<CompactedTopicContext> getCompactedTopicContextAsync() {
        TopicCompactionService topicCompactionService = this.topicCompactionService;
        if (topicCompactionService instanceof PulsarTopicCompactionService) {
            PulsarTopicCompactionService pulsarCompactedService = (PulsarTopicCompactionService)topicCompactionService;
            CompletableFuture<CompactedTopicContext> res = pulsarCompactedService.getCompactedTopic().getCompactedTopicContextFuture();
            if (res == null) {
                return CompletableFuture.completedFuture(null);
            }
            return res;
        }
        return CompletableFuture.completedFuture(null);
    }

    public long getBacklogSize() {
        return this.ledger.getEstimatedBacklogSize();
    }

    public boolean isActive(InactiveTopicDeleteMode deleteMode) {
        switch (deleteMode) {
            case delete_when_no_subscriptions: {
                if (this.subscriptions.isEmpty()) break;
                return true;
            }
            case delete_when_subscriptions_caught_up: {
                if (!this.hasBacklogs(false)) break;
                return true;
            }
        }
        if (TopicName.get((String)this.topic).isGlobal()) {
            return this.hasLocalProducers();
        }
        return this.currentUsageCount() != 0L;
    }

    private boolean hasBacklogs(boolean getPreciseBacklog) {
        return this.subscriptions.values().stream().anyMatch(sub -> sub.getNumberOfEntriesInBacklog(getPreciseBacklog) > 0L);
    }

    @Override
    public CompletableFuture<Void> checkClusterMigration() {
        TopicName topicName = TopicName.get((String)this.topic);
        if (ExtensibleLoadManagerImpl.isInternalTopic(this.topic) || SystemTopicNames.isEventSystemTopic((TopicName)topicName) || NamespaceService.isHeartbeatNamespace((ServiceUnitId)topicName.getNamespaceObject())) {
            return CompletableFuture.completedFuture(null);
        }
        Optional<ClusterPolicies.ClusterUrl> clusterUrl = this.getMigratedClusterUrl();
        if (!clusterUrl.isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.isReplicated() && this.isReplicationBacklogExist()) {
            if (!this.ledger.isMigrated()) {
                log.info("{} applying migration with replication backlog", (Object)this.topic);
                this.ledger.asyncMigrate();
            }
            if (log.isDebugEnabled()) {
                log.debug("{} has replication backlog and applied migration", (Object)this.topic);
            }
            return CompletableFuture.completedFuture(null);
        }
        return this.initMigration().thenCompose(subCreated -> {
            this.migrationSubsCreated = true;
            CompletableFuture migrated = !this.isMigrated() ? this.ledger.asyncMigrate() : CompletableFuture.completedFuture(null);
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)migrated.thenApply(__ -> {
                this.subscriptions.forEach((name, sub) -> {
                    if (sub.isSubscriptionMigrated()) {
                        sub.getConsumers().forEach(Consumer::checkAndApplyTopicMigration);
                    }
                });
                return null;
            })).thenCompose(__ -> this.checkAndDisconnectReplicators())).thenCompose(__ -> this.checkAndUnsubscribeSubscriptions())).thenCompose(__ -> this.checkAndDisconnectProducers());
        });
    }

    private CompletableFuture<Void> initMigration() {
        if (this.migrationSubsCreated) {
            return CompletableFuture.completedFuture(null);
        }
        log.info("{} initializing subscription created at migration cluster", (Object)this.topic);
        return PersistentTopic.getMigratedClusterUrlAsync(this.getBrokerService().getPulsar(), this.topic).thenCompose(clusterUrl -> {
            if (!this.brokerService.getPulsar().getConfig().isClusterMigrationAutoResourceCreation()) {
                return CompletableFuture.completedFuture(null);
            }
            if (!clusterUrl.isPresent()) {
                return FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicMigratedException("cluster migration service-url is not configured"));
            }
            ClusterPolicies.ClusterUrl url = (ClusterPolicies.ClusterUrl)clusterUrl.get();
            ClusterData clusterData = ClusterData.builder().serviceUrl(url.getServiceUrl()).serviceUrlTls(url.getServiceUrlTls()).brokerServiceUrl(url.getBrokerServiceUrl()).brokerServiceUrlTls(url.getBrokerServiceUrlTls()).build();
            PulsarAdmin admin = this.getBrokerService().getClusterPulsarAdmin(MIGRATION_CLUSTER_NAME, Optional.of(clusterData));
            String tenant = TopicName.get((String)this.topic).getTenant();
            NamespaceName ns = TopicName.get((String)this.topic).getNamespaceObject();
            ArrayList subResults = new ArrayList();
            return ((CompletableFuture)this.brokerService.getPulsar().getPulsarResources().getTenantResources().getTenantAsync(tenant).thenCompose(tenantInfo -> {
                if (!tenantInfo.isPresent()) {
                    return CompletableFuture.completedFuture(null);
                }
                CompletableFuture ts = new CompletableFuture();
                admin.tenants().createTenantAsync(tenant, (TenantInfo)tenantInfo.get()).handle((__, ex) -> {
                    if (ex == null || ex instanceof PulsarAdminException.ConflictException) {
                        log.info("[{}] successfully created tenant {} for migration", (Object)this.topic, (Object)tenant);
                        ts.complete(null);
                        return null;
                    }
                    log.warn("[{}] Failed to create tenant {} on migration cluster {}", new Object[]{this.topic, tenant, ex.getCause().getMessage()});
                    ts.completeExceptionally(ex.getCause());
                    return null;
                });
                return ts;
            })).thenCompose(t -> ((CompletableFuture)this.brokerService.getPulsar().getPulsarResources().getNamespaceResources().getPoliciesAsync(ns).thenCompose(policies -> {
                if (!policies.isPresent()) {
                    return CompletableFuture.completedFuture(null);
                }
                CompletableFuture nsFuture = new CompletableFuture();
                admin.namespaces().createNamespaceAsync(ns.toString(), (Policies)policies.get()).handle((__, ex) -> {
                    if (ex == null || ex instanceof PulsarAdminException.ConflictException) {
                        log.info("[{}] successfully created namespace {} for migration", (Object)this.topic, (Object)ns);
                        nsFuture.complete(null);
                        return null;
                    }
                    log.warn("[{}] Failed to create namespace {} on migration cluster {}", new Object[]{this.topic, ns, ex.getCause().getMessage()});
                    nsFuture.completeExceptionally(ex.getCause());
                    return null;
                });
                return nsFuture;
            })).thenCompose(p -> {
                this.subscriptions.forEach((subName, sub) -> {
                    CompletableFuture subResult = new CompletableFuture();
                    subResults.add(subResult);
                    admin.topics().createSubscriptionAsync(this.topic, subName, MessageId.earliest).handle((__, ex) -> {
                        if (ex == null || ex instanceof PulsarAdminException.ConflictException) {
                            log.info("[{}] successfully created sub {} for migration", (Object)this.topic, subName);
                            subResult.complete(null);
                            return null;
                        }
                        log.warn("[{}] Failed to create sub {} on migration cluster, {}", new Object[]{this.topic, subName, ex.getCause().getMessage()});
                        subResult.completeExceptionally(ex.getCause());
                        return null;
                    });
                });
                return Futures.waitForAll((List)subResults);
            }));
        });
    }

    private CompletableFuture<Void> checkAndUnsubscribeSubscriptions() {
        ArrayList futures = new ArrayList();
        this.subscriptions.forEach((s, subscription) -> {
            if (subscription.getNumberOfEntriesInBacklog(true) == 0L && subscription.getConsumers().isEmpty()) {
                futures.add(subscription.delete());
            }
        });
        return FutureUtil.waitForAll(futures);
    }

    private CompletableFuture<Void> checkAndDisconnectProducers() {
        ArrayList futures = new ArrayList();
        this.producers.forEach((name, producer) -> futures.add(producer.disconnect()));
        return FutureUtil.waitForAll(futures);
    }

    private CompletableFuture<Void> checkAndDisconnectReplicators() {
        ArrayList futures = new ArrayList();
        this.replicators.forEach((r, replicator) -> {
            if (replicator.getNumberOfEntriesInBacklog() <= 0L) {
                futures.add(replicator.terminate());
            }
        });
        return FutureUtil.waitForAll(futures);
    }

    @Override
    public boolean shouldProducerMigrate() {
        return !this.isReplicationBacklogExist() && this.migrationSubsCreated;
    }

    @Override
    public boolean isReplicationBacklogExist() {
        for (Replicator replicator : this.replicators.values()) {
            if (replicator.getNumberOfEntriesInBacklog() <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkGC() {
        if (!this.isDeleteWhileInactive()) {
            return;
        }
        InactiveTopicDeleteMode deleteMode = ((InactiveTopicPolicies)this.topicPolicies.getInactiveTopicPolicies().get()).getInactiveTopicDeleteMode();
        int maxInactiveDurationInSec = ((InactiveTopicPolicies)this.topicPolicies.getInactiveTopicPolicies().get()).getMaxInactiveDurationSeconds();
        if (this.isActive(deleteMode)) {
            this.lastActive = System.nanoTime();
        } else {
            if (System.nanoTime() - this.lastActive < TimeUnit.SECONDS.toNanos(maxInactiveDurationInSec)) {
                return;
            }
            if (this.shouldTopicBeRetained()) {
                return;
            }
            CompletableFuture replCloseFuture = new CompletableFuture();
            if (TopicName.get((String)this.topic).isGlobal()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Global topic inactive for {} seconds, closing repl producers.", (Object)this.topic, (Object)maxInactiveDurationInSec);
                }
                ((CompletableFuture)this.closeReplProducersIfNoBacklog().thenRun(() -> {
                    if (this.hasRemoteProducers()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Global topic has connected remote producers. Not a candidate for GC", (Object)this.topic);
                        }
                        replCloseFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Topic has connected remote producers"));
                    } else {
                        log.info("[{}] Global topic inactive for {} seconds, closed repl producers", (Object)this.topic, (Object)maxInactiveDurationInSec);
                        replCloseFuture.complete(null);
                    }
                })).exceptionally(e -> {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Global topic has replication backlog. Not a candidate for GC", (Object)this.topic);
                    }
                    replCloseFuture.completeExceptionally(e.getCause());
                    return null;
                });
            } else {
                replCloseFuture.complete(null);
            }
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)replCloseFuture.thenCompose(v -> this.delete(deleteMode == InactiveTopicDeleteMode.delete_when_no_subscriptions, deleteMode == InactiveTopicDeleteMode.delete_when_subscriptions_caught_up, false))).thenCompose(res -> this.tryToDeletePartitionedMetadata())).thenRun(() -> log.info("[{}] Topic deleted successfully due to inactivity", (Object)this.topic))).exceptionally(e -> {
                if (e.getCause() instanceof BrokerServiceException.TopicBusyException) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Did not delete busy topic: {}", (Object)this.topic, (Object)e.getCause().getMessage());
                    }
                } else if (e.getCause() instanceof UnsupportedOperationException) {
                    log.info("[{}] Skip to delete partitioned topic: {}", (Object)this.topic, (Object)e.getCause().getMessage());
                } else {
                    log.warn("[{}] Inactive topic deletion failed", (Object)this.topic, e);
                }
                return null;
            });
        }
    }

    private CompletableFuture<Void> deleteSchemaAndPoliciesIfAllPartitionsDeleted() {
        if (!TopicName.get((String)this.topic).isPartitioned()) {
            return CompletableFuture.completedFuture(null);
        }
        TopicName pTopicName = TopicName.get((String)TopicName.get((String)this.topic).getPartitionedTopicName());
        BrokerService broker = this.getBrokerService();
        PulsarResources pulsarResources = broker.pulsar().getPulsarResources();
        TopicResources topicResources = pulsarResources.getTopicResources();
        TopicPoliciesService topicPoliciesService = broker.getPulsar().getTopicPoliciesService();
        SchemaStorage schemaStorage = broker.getPulsar().getSchemaStorage();
        return ((CompletableFuture)topicResources.listPersistentTopicsAsync(pTopicName.getNamespaceObject()).thenApply(list -> {
            for (String s : list) {
                TopicName item = TopicName.get((String)s);
                if (!item.isPartitioned() || !item.getPartitionedTopicName().equals(pTopicName.toString())) continue;
                return true;
            }
            return false;
        })).thenCompose(partitionExists -> {
            if (partitionExists.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            return schemaStorage.delete(pTopicName.getSchemaName()).thenCompose(__ -> topicPoliciesService.deleteTopicPoliciesAsync(pTopicName, false));
        });
    }

    private CompletableFuture<Void> tryToDeletePartitionedMetadata() {
        if (TopicName.get((String)this.topic).isPartitioned() && !this.deletePartitionedTopicMetadataWhileInactive()) {
            return CompletableFuture.completedFuture(null);
        }
        TopicName topicName = TopicName.get((String)TopicName.get((String)this.topic).getPartitionedTopicName());
        NamespaceResources.PartitionedTopicResources partitionedTopicResources = this.getBrokerService().pulsar().getPulsarResources().getNamespaceResources().getPartitionedTopicResources();
        return partitionedTopicResources.partitionedTopicExistsAsync(topicName).thenCompose(partitionedTopicExist -> {
            if (!partitionedTopicExist.booleanValue()) {
                return this.deleteSchemaAndPoliciesIfAllPartitionsDeleted();
            }
            return this.getBrokerService().pulsar().getPulsarResources().getNamespaceResources().getPartitionedTopicResources().runWithMarkDeleteAsync(topicName, () -> this.getBrokerService().fetchPartitionedTopicMetadataAsync(topicName).thenCompose(metadata -> {
                ArrayList<CompletableFuture> persistentTopicExists = new ArrayList<CompletableFuture>(metadata.partitions);
                for (int i = 0; i < metadata.partitions; ++i) {
                    persistentTopicExists.add(this.brokerService.getPulsar().getPulsarResources().getTopicResources().persistentTopicExists(topicName.getPartition(i)));
                }
                List unmodifiablePersistentTopicExists = Collections.unmodifiableList(persistentTopicExists);
                return FutureUtil.waitForAll(unmodifiablePersistentTopicExists).thenCompose(unused -> {
                    Optional<Boolean> anyExistPartition = unmodifiablePersistentTopicExists.stream().map(CompletableFuture::join).filter(topicExist -> topicExist).findAny();
                    if (anyExistPartition.isPresent()) {
                        log.info("[{}] Delete topic metadata failed because another partition exist.", (Object)topicName);
                        throw new UnsupportedOperationException(String.format("Another partition exists for [%s].", topicName));
                    }
                    try {
                        return this.brokerService.getPulsar().getAdminClient().topics().deletePartitionedTopicAsync(topicName.toString());
                    }
                    catch (PulsarServerException e) {
                        log.info("[{}] Delete topic metadata failed due to failed to get internal admin client.", (Object)topicName, (Object)e);
                        return CompletableFuture.failedFuture(e);
                    }
                });
            }));
        });
    }

    @Override
    public void checkInactiveSubscriptions() {
        block2: {
            TopicName name = TopicName.get((String)this.topic);
            try {
                Policies policies = (Policies)this.brokerService.pulsar().getPulsarResources().getNamespaceResources().getPolicies(name.getNamespaceObject()).orElseThrow(() -> new MetadataStoreException.NotFoundException());
                int defaultExpirationTime = this.brokerService.pulsar().getConfiguration().getSubscriptionExpirationTimeMinutes();
                Integer nsExpirationTime = policies.subscription_expiration_time_minutes;
                long expirationTimeMillis = TimeUnit.MINUTES.toMillis(nsExpirationTime == null ? (long)defaultExpirationTime : (long)nsExpirationTime.intValue());
                this.checkInactiveSubscriptions(expirationTimeMillis);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("[{}] Error getting policies", (Object)this.topic);
            }
        }
    }

    @VisibleForTesting
    public void checkInactiveSubscriptions(long expirationTimeMillis) {
        if (expirationTimeMillis > 0L) {
            this.subscriptions.forEach((subName, sub) -> {
                if (sub.dispatcher != null && sub.dispatcher.isConsumerConnected() || sub.isReplicated() || PersistentTopic.isCompactionSubscription(subName)) {
                    return;
                }
                if (System.currentTimeMillis() - sub.cursor.getLastActive() > expirationTimeMillis) {
                    sub.delete().thenAccept(v -> log.info("[{}][{}] The subscription was deleted due to expiration with last active [{}]", new Object[]{this.topic, subName, sub.cursor.getLastActive()}));
                }
            });
        }
    }

    @Override
    public void checkBackloggedCursors() {
        this.subscriptions.forEach((subName, subscription) -> this.checkBackloggedCursor((PersistentSubscription)subscription));
    }

    private void checkBackloggedCursor(PersistentSubscription subscription) {
        if (this.getManagedLedger().getConfig().isCacheEvictionByExpectedReadCount()) {
            return;
        }
        if (!(subscription.getConsumers().isEmpty() || this.backloggedCursorThresholdEntries >= 0L && subscription.getCursor().getNumberOfEntries() > this.backloggedCursorThresholdEntries)) {
            subscription.getCursor().setActive();
        } else {
            subscription.getCursor().setInactive();
        }
    }

    public void checkInactiveLedgers() {
        this.ledger.checkInactiveLedgerAndRollOver();
    }

    @Override
    public void checkCursorsToCacheEntries() {
        try {
            this.ledger.checkCursorsToCacheEntries();
        }
        catch (Exception e) {
            log.warn("Failed to check cursors to cache entries", (Throwable)e);
        }
    }

    @Override
    public void checkDeduplicationSnapshot() {
        this.messageDeduplication.takeSnapshot();
    }

    private boolean shouldTopicBeRetained() {
        if (this.getNumberOfEntries() == 0L) {
            return false;
        }
        RetentionPolicies retentionPolicies = (RetentionPolicies)this.topicPolicies.getRetentionPolicies().get();
        long retentionTime = TimeUnit.MINUTES.toNanos(retentionPolicies.getRetentionTimeInMinutes());
        return retentionTime < 0L || System.nanoTime() - this.lastActive < retentionTime;
    }

    public CompletableFuture<Void> onLocalPoliciesUpdate() {
        return this.checkPersistencePolicies();
    }

    @Override
    public void updateDispatchRateLimiter() {
        this.initializeDispatchRateLimiterIfNeeded();
        this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::updateDispatchRate);
    }

    @Override
    public CompletableFuture<Void> onPoliciesUpdate(@NonNull Policies data) {
        Objects.requireNonNull(data);
        if (log.isDebugEnabled()) {
            log.debug("[{}] isEncryptionRequired changes: {} -> {}", new Object[]{this.topic, this.isEncryptionRequired, data.encryption_required});
        }
        if (data.deleted) {
            log.debug("Ignore the update because it has been deleted : {}", (Object)data);
            return CompletableFuture.completedFuture(null);
        }
        this.updateTopicPolicyByNamespacePolicy(data);
        this.checkReplicatedSubscriptionControllerState();
        this.isEncryptionRequired = data.encryption_required;
        this.isAllowAutoUpdateSchema = data.is_allow_auto_update_schema;
        List<CompletableFuture<Void>> applyPolicyTasks = this.applyUpdatedTopicPolicies();
        applyPolicyTasks.add(this.applyUpdatedNamespacePolicies(data));
        return ((CompletableFuture)FutureUtil.waitForAll(applyPolicyTasks).thenAccept(__ -> log.info("[{}] namespace-level policies updated successfully", (Object)this.topic))).exceptionally(ex -> {
            log.error("[{}] update namespace polices : {} error", new Object[]{this.getName(), data, ex});
            throw FutureUtil.wrapToCompletionException((Throwable)ex);
        });
    }

    private CompletableFuture<Void> applyUpdatedNamespacePolicies(Policies namespaceLevelPolicies) {
        return FutureUtil.runWithCurrentThread(() -> this.updateResourceGroupLimiter(namespaceLevelPolicies));
    }

    private List<CompletableFuture<Void>> applyUpdatedTopicPolicies() {
        ArrayList<CompletableFuture<Void>> applyPoliciesFutureList = new ArrayList<CompletableFuture<Void>>();
        this.subscriptions.forEach((subName, sub) -> sub.getConsumers().forEach(consumer -> applyPoliciesFutureList.add(consumer.checkPermissionsAsync())));
        this.producers.values().forEach(producer -> applyPoliciesFutureList.add((CompletableFuture<Void>)producer.checkPermissionsAsync().thenRun(producer::checkEncryption)));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.checkMessageExpiry()));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.updateDispatchRateLimiter()));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.updateSubscribeRateLimiter()));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.updatePublishRateLimiter()));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.updateSubscriptionsDispatcherRateLimiter()));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.replicators.forEach((name, replicator) -> replicator.updateRateLimiter())));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.shadowReplicators.forEach((name, replicator) -> replicator.updateRateLimiter())));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.checkReplicationAndRetryOnFailure()));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.checkDeduplicationStatus()));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.checkPersistencePolicies()));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.preCreateSubscriptionForCompactionIfNeeded()));
        applyPoliciesFutureList.add(FutureUtil.runWithCurrentThread(() -> this.updateBrokerDispatchPauseOnAckStatePersistentEnabled()));
        return applyPoliciesFutureList;
    }

    @Override
    public BacklogQuota getBacklogQuota(BacklogQuota.BacklogQuotaType backlogQuotaType) {
        return (BacklogQuota)((PolicyHierarchyValue)this.topicPolicies.getBackLogQuotaMap().get(backlogQuotaType)).get();
    }

    @Override
    public CompletableFuture<Void> checkBacklogQuotaExceeded(String producerName, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        BacklogQuota backlogQuota = this.getBacklogQuota(backlogQuotaType);
        if (backlogQuota != null) {
            BacklogQuota.RetentionPolicy retentionPolicy = backlogQuota.getPolicy();
            if (retentionPolicy == BacklogQuota.RetentionPolicy.producer_request_hold || retentionPolicy == BacklogQuota.RetentionPolicy.producer_exception) {
                if (backlogQuotaType == BacklogQuota.BacklogQuotaType.destination_storage && this.isSizeBacklogExceeded()) {
                    log.debug("[{}] Size backlog quota exceeded. Cannot create producer [{}]", (Object)this.getName(), (Object)producerName);
                    return FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBacklogQuotaExceededException(retentionPolicy));
                }
                if (backlogQuotaType == BacklogQuota.BacklogQuotaType.message_age) {
                    return this.checkTimeBacklogExceeded(true).thenCompose(isExceeded -> {
                        if (isExceeded.booleanValue()) {
                            log.debug("[{}] Time backlog quota exceeded. Cannot create producer [{}]", (Object)this.getName(), (Object)producerName);
                            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBacklogQuotaExceededException(retentionPolicy));
                        }
                        return CompletableFuture.completedFuture(null);
                    });
                }
            } else {
                return CompletableFuture.completedFuture(null);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isSizeBacklogExceeded() {
        long backlogQuotaLimitInBytes = this.getBacklogQuota(BacklogQuota.BacklogQuotaType.destination_storage).getLimitSize();
        if (backlogQuotaLimitInBytes < 0L) {
            return false;
        }
        long storageSize = this.getBacklogSize();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Storage size = [{}], backlog quota limit [{}]", new Object[]{this.getName(), storageSize, backlogQuotaLimitInBytes});
        }
        return storageSize >= backlogQuotaLimitInBytes;
    }

    @Override
    public long getBestEffortOldestUnacknowledgedMessageAgeSeconds() {
        if (this.oldestPositionInfo == null) {
            return -1L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(Clock.systemUTC().millis() - this.oldestPositionInfo.getPositionPublishTimestampInMillis());
    }

    private void updateResultIfNewer(OldestPositionInfo updatedResult) {
        TIME_BASED_BACKLOG_QUOTA_CHECK_RESULT_UPDATER.updateAndGet(this, existingResult -> {
            if (existingResult == null || ManagedCursorContainer.DataVersion.compareVersions((long)updatedResult.getDataVersion(), (long)existingResult.getDataVersion()) > 0) {
                return updatedResult;
            }
            return existingResult;
        });
    }

    public CompletableFuture<Void> updateOldPositionInfo() {
        final TopicName topicName = TopicName.get((String)this.getName());
        Iterable iterable = this.ledger.getCursors();
        if (!(iterable instanceof ManagedCursorContainer)) {
            return CompletableFuture.completedFuture(null);
        }
        ManagedCursorContainer managedCursorContainer = (ManagedCursorContainer)iterable;
        if (!this.hasBacklogs(this.brokerService.pulsar().getConfiguration().isPreciseTimeBasedBacklogQuotaCheck())) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] No backlog. Update old position info is null", (Object)topicName);
            }
            TIME_BASED_BACKLOG_QUOTA_CHECK_RESULT_UPDATER.set(this, null);
            return CompletableFuture.completedFuture(null);
        }
        final ManagedCursorContainer.CursorInfo oldestMarkDeleteCursorInfo = managedCursorContainer.getCursorWithOldestPosition();
        if (oldestMarkDeleteCursorInfo == null || oldestMarkDeleteCursorInfo.getPosition() == null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] No durable cursor found. Update old position info is null", (Object)topicName);
            }
            TIME_BASED_BACKLOG_QUOTA_CHECK_RESULT_UPDATER.set(this, null);
            return CompletableFuture.completedFuture(null);
        }
        final Position oldestMarkDeletePosition = oldestMarkDeleteCursorInfo.getPosition();
        OldestPositionInfo lastOldestPositionInfo = this.oldestPositionInfo;
        if (lastOldestPositionInfo != null && oldestMarkDeletePosition.compareTo(lastOldestPositionInfo.getOldestCursorMarkDeletePosition()) == 0 && oldestMarkDeletePosition.compareTo(this.ledger.getFirstPosition()) >= 0) {
            if (!lastOldestPositionInfo.getCursorName().equals(oldestMarkDeleteCursorInfo.getCursor().getName())) {
                this.updateResultIfNewer(new OldestPositionInfo(lastOldestPositionInfo.getOldestCursorMarkDeletePosition(), oldestMarkDeleteCursorInfo.getCursor().getName(), lastOldestPositionInfo.getPositionPublishTimestampInMillis(), oldestMarkDeleteCursorInfo.getVersion()));
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Updating cached old position info {}, since cursor causing it has changed from {} to {}", new Object[]{topicName, oldestMarkDeletePosition, lastOldestPositionInfo.getCursorName(), oldestMarkDeleteCursorInfo.getCursor().getName()});
                }
            }
            return CompletableFuture.completedFuture(null);
        }
        if (this.brokerService.pulsar().getConfiguration().isPreciseTimeBasedBacklogQuotaCheck()) {
            final CompletableFuture<Void> future = new CompletableFuture<Void>();
            final Position position = this.ledger.getNextValidPosition(oldestMarkDeletePosition);
            this.ledger.asyncReadEntry(position, new AsyncCallbacks.ReadEntryCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void readEntryComplete(Entry entry, Object ctx) {
                    try {
                        long entryTimestamp = entry.getEntryTimestamp();
                        PersistentTopic.this.updateResultIfNewer(new OldestPositionInfo(oldestMarkDeleteCursorInfo.getPosition(), oldestMarkDeleteCursorInfo.getCursor().getName(), entryTimestamp, oldestMarkDeleteCursorInfo.getVersion()));
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Precise based update oldest position info. Oldest unacked entry read from BK. Oldest entry in cursor {}'s backlog: {}. Oldest mark-delete position: {}. EntryTimestamp: {}", new Object[]{topicName, oldestMarkDeleteCursorInfo.getCursor().getName(), position, oldestMarkDeletePosition, entryTimestamp});
                        }
                        future.complete(null);
                    }
                    catch (Exception e) {
                        log.error("[{}][{}] Error deserializing message for update old position", (Object)topicName, (Object)e);
                        future.completeExceptionally(e);
                    }
                    finally {
                        entry.release();
                    }
                }

                public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                    log.error("[{}][{}] Error reading entry for precise update old position", (Object)topicName, (Object)exception);
                    future.completeExceptionally(exception);
                }
            }, null);
            return future;
        }
        try {
            EstimateTimeBasedBacklogQuotaCheckResult checkResult = this.estimatedTimeBasedBacklogQuotaCheck(oldestMarkDeletePosition);
            if (checkResult.getEstimatedOldestUnacknowledgedMessageTimestamp() != null) {
                this.updateResultIfNewer(new OldestPositionInfo(oldestMarkDeleteCursorInfo.getPosition(), oldestMarkDeleteCursorInfo.getCursor().getName(), checkResult.getEstimatedOldestUnacknowledgedMessageTimestamp(), oldestMarkDeleteCursorInfo.getVersion()));
            } else {
                TIME_BASED_BACKLOG_QUOTA_CHECK_RESULT_UPDATER.set(this, null);
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            log.error("[{}][{}] Error reading entry for update old position", (Object)topicName, (Object)e);
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<Boolean> checkTimeBacklogExceeded(boolean shouldUpdateOldPositionInfo) {
        TopicName topicName = TopicName.get((String)this.getName());
        int backlogQuotaLimitInSecond = this.getBacklogQuota(BacklogQuota.BacklogQuotaType.message_age).getLimitTime();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Time backlog quota = [{}]. Checking if exceeded.", (Object)topicName, (Object)backlogQuotaLimitInSecond);
        }
        CompletableFuture<Void> updateFuture = shouldUpdateOldPositionInfo ? this.updateOldPositionInfo() : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)updateFuture.thenCompose(__ -> {
            if (backlogQuotaLimitInSecond <= 0) {
                return CompletableFuture.completedFuture(false);
            }
            if (this.oldestPositionInfo == null) {
                return CompletableFuture.completedFuture(false);
            }
            long entryTimestamp = this.oldestPositionInfo.getPositionPublishTimestampInMillis();
            boolean expired = MessageImpl.isEntryExpired((int)backlogQuotaLimitInSecond, (long)entryTimestamp);
            return CompletableFuture.completedFuture(expired);
        })).exceptionally(e -> {
            log.error("[{}][{}] Error checking time backlog exceeded", (Object)topicName, e);
            return false;
        });
    }

    @VisibleForTesting
    EstimateTimeBasedBacklogQuotaCheckResult estimatedTimeBasedBacklogQuotaCheck(Position markDeletePosition) throws ExecutionException, InterruptedException {
        int backlogQuotaLimitInSecond = this.getBacklogQuota(BacklogQuota.BacklogQuotaType.message_age).getLimitTime();
        if (((Long)this.ledger.getLedgersInfo().lastKey()).equals(markDeletePosition.getLedgerId())) {
            return new EstimateTimeBasedBacklogQuotaCheckResult(false, null);
        }
        MLDataFormats.ManagedLedgerInfo.LedgerInfo markDeletePositionLedgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledger.getLedgerInfo(markDeletePosition.getLedgerId()).get();
        if (markDeletePositionLedgerInfo == null) {
            Position nextValidPosition = this.ledger.getNextValidPosition(markDeletePosition);
            markDeletePositionLedgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledger.getLedgerInfo(nextValidPosition.getLedgerId()).get();
            markDeletePosition = nextValidPosition;
        }
        MLDataFormats.ManagedLedgerInfo.LedgerInfo positionToCheckLedgerInfo = markDeletePositionLedgerInfo;
        if (markDeletePositionLedgerInfo != null && markDeletePosition.getEntryId() == markDeletePositionLedgerInfo.getEntries() - 1L) {
            Position positionToCheck = this.ledger.getNextValidPosition(markDeletePosition);
            positionToCheckLedgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledger.getLedgerInfo(positionToCheck.getLedgerId()).get();
        }
        if (positionToCheckLedgerInfo != null && positionToCheckLedgerInfo.hasTimestamp() && positionToCheckLedgerInfo.getTimestamp() > 0L) {
            boolean shouldTruncateBacklog;
            long estimateMsgAgeMs = this.clock.millis() - positionToCheckLedgerInfo.getTimestamp();
            boolean bl = shouldTruncateBacklog = estimateMsgAgeMs > TimeUnit.SECONDS.toMillis(backlogQuotaLimitInSecond);
            if (log.isDebugEnabled()) {
                log.debug("Time based backlog quota exceeded, quota {}[ms], age of ledger slowest cursor currently on {}[ms]", (Object)(backlogQuotaLimitInSecond * 1000), (Object)estimateMsgAgeMs);
            }
            return new EstimateTimeBasedBacklogQuotaCheckResult(shouldTruncateBacklog, positionToCheckLedgerInfo.getTimestamp());
        }
        return new EstimateTimeBasedBacklogQuotaCheckResult(false, null);
    }

    @Override
    public boolean isReplicated() {
        return !this.replicators.isEmpty();
    }

    @Override
    public boolean isShadowReplicated() {
        return !this.shadowReplicators.isEmpty();
    }

    public CompletableFuture<MessageId> terminate() {
        final CompletableFuture<MessageId> future = new CompletableFuture<MessageId>();
        this.ledger.asyncTerminate(new AsyncCallbacks.TerminateCallback(){

            public void terminateComplete(Position lastCommittedPosition, Object ctx) {
                PersistentTopic.this.producers.values().forEach(Producer::disconnect);
                PersistentTopic.this.subscriptions.forEach((name, sub) -> sub.topicTerminated());
                Position lastPosition = lastCommittedPosition;
                MessageIdImpl messageId = new MessageIdImpl(lastPosition.getLedgerId(), lastPosition.getEntryId(), -1);
                log.info("[{}] Topic terminated at {}", (Object)PersistentTopic.this.getName(), (Object)messageId);
                future.complete(messageId);
            }

            public void terminateFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOldestMessageExpired(ManagedCursor cursor, int messageTTLInSeconds) {
        Entry entry = null;
        boolean isOldestMessageExpired = false;
        try {
            entry = cursor.getNthEntry(1, ManagedCursor.IndividualDeletedEntries.Include);
            if (entry != null) {
                long entryTimestamp = entry.getEntryTimestamp();
                isOldestMessageExpired = MessageImpl.isEntryExpired((int)((int)((double)messageTTLInSeconds * 1.5)), (long)entryTimestamp);
            }
        }
        catch (Exception e) {
            if (this.brokerService.pulsar().getConfiguration().isAutoSkipNonRecoverableData() && e instanceof ManagedLedgerException.NonRecoverableLedgerException) {
                boolean bl = true;
                return bl;
            }
            log.warn("[{}] [{}] Error while getting the oldest message", new Object[]{this.topic, cursor.toString(), e});
        }
        finally {
            if (entry != null) {
                entry.release();
            }
        }
        return isOldestMessageExpired;
    }

    public CompletableFuture<Boolean> isOldestMessageExpiredAsync(final ManagedCursor cursor, final int messageTTLInSeconds) {
        final CompletableFuture<Boolean> res = new CompletableFuture<Boolean>();
        cursor.asyncGetNthEntry(1, ManagedCursor.IndividualDeletedEntries.Include, new AsyncCallbacks.ReadEntryCallback(){

            public void readEntryComplete(Entry entry, Object ctx) {
                long entryTimestamp = 0L;
                try {
                    entryTimestamp = entry.getEntryTimestamp();
                    res.complete(MessageImpl.isEntryExpired((int)((int)((double)messageTTLInSeconds * 1.5)), (long)entryTimestamp));
                }
                catch (Exception e) {
                    log.warn("[{}] [{}] Error while getting the oldest message", new Object[]{PersistentTopic.this.topic, cursor.toString(), e});
                    res.complete(false);
                }
            }

            public void readEntryFailed(ManagedLedgerException e, Object ctx) {
                if (PersistentTopic.this.brokerService.pulsar().getConfiguration().isAutoSkipNonRecoverableData() && e instanceof ManagedLedgerException.NonRecoverableLedgerException) {
                    res.complete(true);
                } else {
                    log.warn("[{}] [{}] Error while getting the oldest message", new Object[]{PersistentTopic.this.topic, cursor.toString(), e});
                    res.complete(false);
                }
            }
        }, null);
        return res;
    }

    public CompletableFuture<Void> clearBacklog() {
        log.info("[{}] Clearing backlog on all cursors in the topic.", (Object)this.topic);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        ArrayList<String> cursors = new ArrayList<String>(this.getSubscriptions().keySet());
        cursors.addAll(this.getReplicators().keySet());
        cursors.addAll(this.getShadowReplicators().keySet());
        for (String cursor : cursors) {
            futures.add(this.clearBacklog(cursor));
        }
        return FutureUtil.waitForAll(futures);
    }

    public CompletableFuture<Void> clearBacklog(String cursorName) {
        log.info("[{}] Clearing backlog for cursor {} in the topic.", (Object)this.topic, (Object)cursorName);
        PersistentSubscription sub = this.getSubscription(cursorName);
        if (sub != null) {
            return sub.clearBacklog();
        }
        PersistentReplicator repl = (PersistentReplicator)this.getPersistentReplicator(cursorName);
        if (repl != null) {
            return repl.clearBacklog();
        }
        repl = (PersistentReplicator)this.shadowReplicators.get(cursorName);
        if (repl != null) {
            return repl.clearBacklog();
        }
        return FutureUtil.failedFuture((Throwable)new BrokerServiceException("Cursor not found"));
    }

    @Override
    public Optional<DispatchRateLimiter> getDispatchRateLimiter() {
        return this.dispatchRateLimiter;
    }

    @Override
    public Optional<DispatchRateLimiter> getBrokerDispatchRateLimiter() {
        return Optional.ofNullable(this.brokerService.getBrokerDispatchRateLimiter());
    }

    @Override
    public Optional<SubscribeRateLimiter> getSubscribeRateLimiter() {
        return this.subscribeRateLimiter;
    }

    public long getLastPublishedSequenceId(String producerName) {
        return this.messageDeduplication.getLastPublishedSequenceId(producerName);
    }

    @Override
    public Position getLastPosition() {
        return this.ledger.getLastConfirmedEntry();
    }

    @Override
    public CompletableFuture<Position> getLastDispatchablePosition() {
        if (this.lastDispatchablePosition != null) {
            return CompletableFuture.completedFuture(this.lastDispatchablePosition);
        }
        Position lastPosition = this.transactionBuffer instanceof TransactionBufferDisable ? this.getLastPosition() : this.getMaxReadPosition();
        return this.ledger.getLastDispatchablePosition(entry -> {
            MessageMetadata md = entry.getMessageMetadata();
            if (md == null) {
                md = Commands.parseMessageMetadata((ByteBuf)entry.getDataBuffer());
            }
            if (Markers.isServerOnlyMarker((MessageMetadata)md)) {
                return false;
            }
            if (md.hasTxnidMostBits() && md.hasTxnidLeastBits()) {
                TxnID txnID = new TxnID(md.getTxnidMostBits(), md.getTxnidLeastBits());
                return !this.isTxnAborted(txnID, entry.getPosition());
            }
            return true;
        }, lastPosition).thenApply(position -> {
            this.updateLastDispatchablePosition((Position)position);
            return position;
        });
    }

    public synchronized void updateLastDispatchablePosition(Position position) {
        if (position == null) {
            this.lastDispatchablePosition = null;
            return;
        }
        if (position.compareTo(this.getMaxReadPosition()) > 0) {
            return;
        }
        if (this.lastDispatchablePosition == null) {
            this.lastDispatchablePosition = position;
            return;
        }
        if (position.compareTo(this.lastDispatchablePosition) > 0) {
            this.lastDispatchablePosition = position;
        }
    }

    @Override
    public CompletableFuture<MessageId> getLastMessageId() {
        final CompletableFuture<MessageId> completableFuture = new CompletableFuture<MessageId>();
        final Position position = this.ledger.getLastConfirmedEntry();
        String name = this.getName();
        final int partitionIndex = TopicName.getPartitionIndex((String)name);
        if (log.isDebugEnabled()) {
            log.debug("getLastMessageId {}, partitionIndex{}, position {}", new Object[]{name, partitionIndex, position});
        }
        if (position.getEntryId() == -1L) {
            completableFuture.complete((MessageId)new MessageIdImpl(position.getLedgerId(), position.getEntryId(), partitionIndex));
            return completableFuture;
        }
        if (!this.ledger.getLedgersInfo().containsKey(position.getLedgerId())) {
            completableFuture.complete(MessageId.earliest);
            return completableFuture;
        }
        this.ledger.asyncReadEntry(position, new AsyncCallbacks.ReadEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void readEntryComplete(Entry entry, Object ctx) {
                try {
                    MessageMetadata metadata = entry.getMessageMetadata();
                    if (metadata == null) {
                        metadata = Commands.parseMessageMetadata((ByteBuf)entry.getDataBuffer());
                    }
                    if (metadata.hasNumMessagesInBatch()) {
                        completableFuture.complete(new BatchMessageIdImpl(position.getLedgerId(), position.getEntryId(), partitionIndex, metadata.getNumMessagesInBatch() - 1));
                    } else {
                        completableFuture.complete(new MessageIdImpl(position.getLedgerId(), position.getEntryId(), partitionIndex));
                    }
                }
                finally {
                    entry.release();
                }
            }

            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    public synchronized CompletableFuture<Void> triggerCompactionWithCheckHasMoreMessages() {
        return ((CompletableFuture)((CompletableFuture)this.getLastDispatchablePosition().thenCombine(this.topicCompactionService.getLastCompactedPosition(), (lastDispatchablePosition, lastCompactedPosition) -> {
            if (lastDispatchablePosition == null) {
                lastDispatchablePosition = PositionFactory.EARLIEST;
            }
            return lastCompactedPosition == null || lastDispatchablePosition.compareTo(lastCompactedPosition) > 0;
        })).thenAccept(hasMoreMessagesToBeCompacted -> {
            if (!hasMoreMessagesToBeCompacted.booleanValue()) {
                log.info("[{}] No more messages to compact, skip triggering compaction", (Object)this.topic);
                return;
            }
            try {
                this.triggerCompaction();
            }
            catch (PulsarServerException | BrokerServiceException.AlreadyRunningException e) {
                throw new CompletionException(e);
            }
        })).whenComplete((__, ex) -> {
            if (ex != null) {
                ex = FutureUtil.unwrapCompletionException((Throwable)ex);
                log.error("[{}] Trigger Compaction failure.", (Object)this.topic, ex);
            }
        });
    }

    public synchronized void triggerCompaction() throws PulsarServerException, BrokerServiceException.AlreadyRunningException {
        if (this.currentCompaction.isDone()) {
            if (!this.lock.readLock().tryLock()) {
                log.info("[{}] Conflict topic-close, topic-delete, skip triggering compaction", (Object)this.topic);
                return;
            }
            try {
                if (this.isClosingOrDeleting) {
                    log.info("[{}] Topic is closing or deleting, skip triggering compaction", (Object)this.topic);
                    return;
                }
                if (this.disablingCompaction.get()) {
                    log.info("[{}] Compaction is disabling, skip triggering compaction", (Object)this.topic);
                    return;
                }
                if (strategicCompactionMap.containsKey(this.topic)) {
                    this.currentCompaction = this.brokerService.pulsar().getStrategicCompactor().compact(this.topic, strategicCompactionMap.get(this.topic));
                }
                this.currentCompaction = this.topicCompactionService.compact().thenApply(x -> null);
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            throw new BrokerServiceException.AlreadyRunningException("Compaction already in progress");
        }
        this.currentCompaction.whenComplete((ignore, ex) -> {
            if (ex != null) {
                log.warn("[{}] Compaction failure.", (Object)this.topic, ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LongRunningProcessStatus compactionStatus() {
        CompletableFuture<Long> current;
        PersistentTopic persistentTopic = this;
        synchronized (persistentTopic) {
            current = this.currentCompaction;
        }
        if (!current.isDone()) {
            return LongRunningProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.RUNNING);
        }
        try {
            if (Objects.equals(current.join(), COMPACTION_NEVER_RUN)) {
                return LongRunningProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.NOT_RUN);
            }
            return LongRunningProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.SUCCESS);
        }
        catch (CancellationException | CompletionException e) {
            return LongRunningProcessStatus.forError((String)e.getMessage());
        }
    }

    public synchronized void triggerOffload(final MessageIdImpl messageId) throws BrokerServiceException.AlreadyRunningException {
        if (!this.currentOffload.isDone()) {
            throw new BrokerServiceException.AlreadyRunningException("Offload already in progress");
        }
        this.currentOffload = new CompletableFuture();
        final CompletableFuture promise = this.currentOffload;
        log.info("[{}] Starting offload operation at messageId {}", (Object)this.topic, (Object)messageId);
        this.getManagedLedger().asyncOffloadPrefix(PositionFactory.create((long)messageId.getLedgerId(), (long)messageId.getEntryId()), new AsyncCallbacks.OffloadCallback(){

            public void offloadComplete(Position pos, Object ctx) {
                Position impl = pos;
                log.info("[{}] Completed successfully offload operation at messageId {}", (Object)PersistentTopic.this.topic, (Object)messageId);
                promise.complete(new MessageIdImpl(impl.getLedgerId(), impl.getEntryId(), -1));
            }

            public void offloadFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Failed offload operation at messageId {}", new Object[]{PersistentTopic.this.topic, messageId, exception});
                promise.completeExceptionally(exception);
            }
        }, null);
    }

    public synchronized OffloadProcessStatus offloadStatus() {
        if (!this.currentOffload.isDone()) {
            return OffloadProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.RUNNING);
        }
        try {
            if (this.currentOffload.join() == MessageId.earliest) {
                return OffloadProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.NOT_RUN);
            }
            return OffloadProcessStatus.forSuccess((MessageId)((MessageId)this.currentOffload.join()));
        }
        catch (CancellationException | CompletionException e) {
            log.warn("Failed to offload", e.getCause());
            return OffloadProcessStatus.forError((String)e.getMessage());
        }
    }

    @Override
    public CompletableFuture<Void> addSchemaIfIdleOrCheckCompatible(SchemaData schema) {
        return this.hasSchema().thenCompose(hasSchema -> {
            int numActiveConsumersWithoutAutoSchema = this.subscriptions.values().stream().mapToInt(subscription -> subscription.getConsumers().stream().filter(consumer -> consumer.getSchemaType() != SchemaType.AUTO_CONSUME).toList().size()).sum();
            if (hasSchema.booleanValue() || this.userCreatedProducerCount > 0 || numActiveConsumersWithoutAutoSchema != 0 || this.ledger.getTotalSize() != 0L) {
                return this.checkSchemaCompatibleForConsumer(schema).exceptionally(ex -> {
                    Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
                    if (realCause instanceof NotExistSchemaException) {
                        throw FutureUtil.wrapToCompletionException((Throwable)new IncompatibleSchemaException("Failed to add schema to an active topic with empty(BYTES) schema: new schema type " + String.valueOf(schema.getType())));
                    }
                    throw FutureUtil.wrapToCompletionException((Throwable)realCause);
                });
            }
            return this.addSchema(schema).thenCompose(schemaVersion -> CompletableFuture.completedFuture(null));
        });
    }

    public synchronized void checkReplicatedSubscriptionControllerState() {
        AtomicBoolean shouldBeEnabled = new AtomicBoolean(false);
        this.subscriptions.forEach((name, subscription) -> {
            if (subscription.isReplicated()) {
                shouldBeEnabled.set(true);
            }
        });
        if (!shouldBeEnabled.get() && log.isDebugEnabled()) {
            log.debug("[{}] There are no replicated subscriptions on the topic", (Object)this.topic);
        }
        this.checkReplicatedSubscriptionControllerState(shouldBeEnabled.get());
    }

    private synchronized void checkReplicatedSubscriptionControllerState(boolean shouldBeEnabled) {
        boolean replicationEnabled;
        boolean isCurrentlyEnabled = this.replicatedSubscriptionsController.isPresent();
        boolean isEnableReplicatedSubscriptions = this.brokerService.pulsar().getConfiguration().isEnableReplicatedSubscriptions();
        boolean bl = replicationEnabled = ((List)this.topicPolicies.getReplicationClusters().get()).size() > 1;
        if (shouldBeEnabled && !isCurrentlyEnabled && isEnableReplicatedSubscriptions && replicationEnabled) {
            log.info("[{}] Enabling replicated subscriptions controller", (Object)this.topic);
            this.replicatedSubscriptionsController = Optional.of(new ReplicatedSubscriptionsController(this, this.brokerService.pulsar().getConfiguration().getClusterName()));
        } else if (!(!isCurrentlyEnabled || shouldBeEnabled && isEnableReplicatedSubscriptions && replicationEnabled)) {
            log.info("[{}] Disabled replicated subscriptions controller", (Object)this.topic);
            this.replicatedSubscriptionsController.ifPresent(ReplicatedSubscriptionsController::close);
            this.replicatedSubscriptionsController = Optional.empty();
        }
    }

    void receivedReplicatedSubscriptionMarker(Position position, int markerType, ByteBuf payload) {
        ReplicatedSubscriptionsController ctrl = this.replicatedSubscriptionsController.orElse(null);
        if (ctrl == null) {
            this.checkReplicatedSubscriptionControllerState(true);
            ctrl = this.replicatedSubscriptionsController.get();
        }
        ctrl.receivedReplicatedSubscriptionMarker(position, markerType, payload);
    }

    public Optional<ReplicatedSubscriptionsController> getReplicatedSubscriptionController() {
        return this.replicatedSubscriptionsController;
    }

    public TopicCompactionService getTopicCompactionService() {
        return this.topicCompactionService;
    }

    @Override
    public boolean isSystemTopic() {
        return false;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    private synchronized void cancelFencedTopicMonitoringTask() {
        ScheduledFuture<?> monitoringTask = this.fencedTopicMonitoringTask;
        if (monitoringTask != null && !monitoringTask.isDone()) {
            monitoringTask.cancel(false);
        }
    }

    private synchronized void fence() {
        int timeout;
        this.isFenced = true;
        ScheduledFuture<?> monitoringTask = this.fencedTopicMonitoringTask;
        if ((monitoringTask == null || monitoringTask.isDone()) && (timeout = this.brokerService.pulsar().getConfiguration().getTopicFencingTimeoutSeconds()) > 0) {
            this.fencedTopicMonitoringTask = this.brokerService.executor().schedule(this::closeFencedTopicForcefully, (long)timeout, TimeUnit.SECONDS);
        }
    }

    private synchronized void unfence() {
        this.isFenced = false;
        this.ledger.unfenceForInterceptorException();
        this.cancelFencedTopicMonitoringTask();
    }

    private void closeFencedTopicForcefully() {
        if (this.isFenced) {
            int timeout = this.brokerService.pulsar().getConfiguration().getTopicFencingTimeoutSeconds();
            if (this.isClosingOrDeleting) {
                log.warn("[{}] Topic remained fenced for {} seconds and is already closed (pendingWriteOps: {})", new Object[]{this.topic, timeout, this.pendingWriteOps.get()});
            } else {
                log.error("[{}] Topic remained fenced for {} seconds, so close it (pendingWriteOps: {})", new Object[]{this.topic, timeout, this.pendingWriteOps.get()});
                this.close();
            }
        }
    }

    private void fenceTopicToCloseOrDelete() {
        this.isClosingOrDeleting = true;
        this.isFenced = true;
    }

    private void unfenceTopicToResume() {
        this.isFenced = false;
        this.isClosingOrDeleting = false;
        this.subscriptions.values().forEach(sub -> sub.resumeAfterFence());
        this.unfenceReplicatorsToResume();
    }

    private void unfenceReplicatorsToResume() {
        this.checkReplication();
        this.checkShadowReplication();
    }

    private void removeTerminatedReplicators(Map<String, Replicator> replicators) {
        HashMap terminatedReplicators = new HashMap();
        replicators.forEach((cluster, replicator) -> {
            if (replicator.isTerminated()) {
                terminatedReplicators.put(cluster, replicator);
            }
        });
        terminatedReplicators.entrySet().forEach(entry -> replicators.remove(entry.getKey(), entry.getValue()));
    }

    @Override
    public void publishTxnMessage(TxnID txnID, ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        this.pendingWriteOps.incrementAndGet();
        if (this.isFenced) {
            publishContext.completed(new BrokerServiceException.TopicFencedException("fenced"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        if (this.isExceedMaximumMessageSize(headersAndPayload.readableBytes(), publishContext)) {
            publishContext.completed(new BrokerServiceException.NotAllowedException("Exceed maximum message size"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        if (this.isExceedMaximumDeliveryDelay(headersAndPayload)) {
            publishContext.completed(new BrokerServiceException.NotAllowedException(String.format("Exceeds max allowed delivery delay of %s milliseconds", this.getDelayedDeliveryMaxDelayInMillis())), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        MessageDeduplication.MessageDupStatus status = this.messageDeduplication.isDuplicate(publishContext, headersAndPayload);
        switch (status) {
            case NotDup: {
                ((CompletableFuture)this.transactionBuffer.appendBufferToTxn(txnID, publishContext.getSequenceId(), headersAndPayload).thenAccept(position -> {
                    this.messageDeduplication.recordMessagePersisted(publishContext, (Position)position);
                    publishContext.setProperty("txn_id", txnID.toString());
                    publishContext.completed(null, position.getLedgerId(), position.getEntryId());
                    this.decrementPendingWriteOpsAndCheck();
                })).exceptionally(throwable -> {
                    if ((throwable = FutureUtil.unwrapCompletionException((Throwable)throwable)) instanceof BrokerServiceException.NotAllowedException) {
                        publishContext.completed((BrokerServiceException.NotAllowedException)throwable, -1L, -1L);
                        this.decrementPendingWriteOpsAndCheck();
                    } else {
                        this.addFailed(ManagedLedgerException.getManagedLedgerException((Throwable)throwable), publishContext);
                    }
                    return null;
                });
                break;
            }
            case Dup: {
                publishContext.completed(null, -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
                break;
            }
            default: {
                publishContext.completed(new MessageDeduplication.MessageDupUnknownException(this.topic, publishContext.getProducerName()), -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
            }
        }
    }

    @Override
    public CompletableFuture<Void> endTxn(TxnID txnID, int txnAction, long lowWaterMark) {
        if (0 == txnAction) {
            return this.transactionBuffer.commitTxn(txnID, lowWaterMark);
        }
        if (1 == txnAction) {
            return this.transactionBuffer.abortTxn(txnID, lowWaterMark);
        }
        return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Unsupported txnAction " + txnAction));
    }

    @Override
    public CompletableFuture<Void> truncate() {
        return this.ledger.asyncTruncate();
    }

    public long getDelayedDeliveryTickTimeMillis() {
        return (Long)this.topicPolicies.getDelayedDeliveryTickTimeMillis().get();
    }

    public boolean isDelayedDeliveryEnabled() {
        return (Boolean)this.topicPolicies.getDelayedDeliveryEnabled().get();
    }

    public long getDelayedDeliveryMaxDelayInMillis() {
        return (Long)this.topicPolicies.getDelayedDeliveryMaxDelayInMillis().get();
    }

    public int getMaxUnackedMessagesOnSubscription() {
        return (Integer)this.topicPolicies.getMaxUnackedMessagesOnSubscription().get();
    }

    public boolean isDispatcherPauseOnAckStatePersistentEnabled() {
        Boolean b = (Boolean)this.topicPolicies.getDispatcherPauseOnAckStatePersistentEnabled().get();
        return b == null ? false : b;
    }

    @Override
    public void updateBrokerDispatchPauseOnAckStatePersistentEnabled() {
        super.updateBrokerDispatchPauseOnAckStatePersistentEnabled();
        if (!((Boolean)this.topicPolicies.getDispatcherPauseOnAckStatePersistentEnabled().get()).booleanValue()) {
            this.getSubscriptions().forEach((sName, subscription) -> {
                if (subscription.getDispatcher() == null) {
                    return;
                }
                subscription.getDispatcher().checkAndResumeIfPaused();
            });
        }
    }

    @Override
    public void onUpdate(TopicPolicies policies) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] update topic policy: {}", (Object)this.topic, (Object)policies);
        }
        if (policies == null) {
            return;
        }
        this.updateTopicPolicy(policies);
        this.shadowTopics = policies.getShadowTopics();
        this.checkReplicatedSubscriptionControllerState();
        ((CompletableFuture)FutureUtil.waitForAll(this.applyUpdatedTopicPolicies()).thenAccept(__ -> log.info("[{}] topic-level policies updated successfully", (Object)this.topic))).exceptionally(e -> {
            Throwable t = FutureUtil.unwrapCompletionException((Throwable)e);
            log.error("[{}] update topic-level policy error: {}", new Object[]{this.topic, t.getMessage(), t});
            return null;
        });
    }

    private void updateSubscriptionsDispatcherRateLimiter() {
        this.subscriptions.forEach((subName, sub) -> {
            Dispatcher dispatcher = sub.getDispatcher();
            if (dispatcher != null) {
                dispatcher.updateRateLimiter();
            }
        });
    }

    protected CompletableFuture<Void> initTopicPolicy() {
        TopicName partitionedTopicName;
        TopicPoliciesService topicPoliciesService = this.brokerService.pulsar().getTopicPoliciesService();
        if (topicPoliciesService.registerListener(partitionedTopicName = TopicName.getPartitionedTopicName((String)this.topic), this)) {
            if (ExtensibleLoadManagerImpl.isInternalTopic(this.topic)) {
                return CompletableFuture.completedFuture(null);
            }
            return ((CompletableFuture)((CompletableFuture)topicPoliciesService.getTopicPoliciesAsync(partitionedTopicName, TopicPoliciesService.GetType.GLOBAL_ONLY).thenAcceptAsync(optionalPolicies -> optionalPolicies.ifPresent(this::onUpdate), (Executor)this.brokerService.getTopicOrderedExecutor())).thenCompose(__ -> topicPoliciesService.getTopicPoliciesAsync(partitionedTopicName, TopicPoliciesService.GetType.LOCAL_ONLY))).thenAcceptAsync(optionalPolicies -> optionalPolicies.ifPresent(this::onUpdate), (Executor)this.brokerService.getTopicOrderedExecutor());
        }
        return CompletableFuture.completedFuture(null);
    }

    @VisibleForTesting
    public MessageDeduplication getMessageDeduplication() {
        return this.messageDeduplication;
    }

    private boolean checkMaxSubscriptionsPerTopicExceed(String subscriptionName) {
        if (this.isSystemTopic()) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)subscriptionName) && this.getSubscription(subscriptionName) != null) {
            return false;
        }
        Integer maxSubsPerTopic = (Integer)this.topicPolicies.getMaxSubscriptionsPerTopic().get();
        if (maxSubsPerTopic != null && maxSubsPerTopic > 0) {
            return this.subscriptions != null && this.subscriptions.size() >= maxSubsPerTopic;
        }
        return false;
    }

    public boolean checkSubscriptionTypesEnable(CommandSubscribe.SubType subType) {
        EnumSet subTypesEnabled = (EnumSet)this.topicPolicies.getSubscriptionTypesEnabled().get();
        return subTypesEnabled != null && subTypesEnabled.contains(subType);
    }

    public TransactionBufferStats getTransactionBufferStats(boolean lowWaterMarks) {
        return this.getTransactionBufferStats(lowWaterMarks, false);
    }

    public TransactionBufferStats getTransactionBufferStats(boolean lowWaterMarks, boolean segmentStats) {
        return this.transactionBuffer.getStats(lowWaterMarks, segmentStats);
    }

    public TransactionPendingAckStats getTransactionPendingAckStats(String subName, boolean lowWaterMarks) {
        return this.subscriptions.get(subName).getTransactionPendingAckStats(lowWaterMarks);
    }

    public Position getMaxReadPosition() {
        return this.transactionBuffer.getMaxReadPosition();
    }

    public boolean isTxnAborted(TxnID txnID, Position readPosition) {
        return this.transactionBuffer.isTxnAborted(txnID, readPosition);
    }

    public TransactionInBufferStats getTransactionInBufferStats(TxnID txnID) {
        return this.transactionBuffer.getTransactionInBufferStats(txnID);
    }

    @Override
    protected boolean isTerminated() {
        return this.ledger.isTerminated();
    }

    @Override
    public boolean isMigrated() {
        return this.ledger.isMigrated();
    }

    @Override
    public boolean isDeduplicationEnabled() {
        return (Boolean)this.getHierarchyTopicPolicies().getDeduplicationEnabled().get();
    }

    public TransactionInPendingAckStats getTransactionInPendingAckStats(TxnID txnID, String subName) {
        return this.subscriptions.get(subName).getTransactionInPendingAckStats(txnID);
    }

    public CompletableFuture<ManagedLedger> getPendingAckManagedLedger(String subName) {
        PersistentSubscription subscription = this.subscriptions.get(subName);
        if (subscription == null) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.SubscriptionNotFoundException(this.topic + " not found subscription : " + subName));
        }
        return subscription.getPendingAckManageLedger();
    }

    private CompletableFuture<Void> transactionBufferCleanupAndClose() {
        return this.transactionBuffer.clearSnapshot().thenCompose(__ -> this.transactionBuffer.closeAsync());
    }

    public Optional<TopicName> getShadowSourceTopic() {
        return Optional.ofNullable(this.shadowSourceTopic);
    }

    protected boolean isExceedMaximumDeliveryDelay(ByteBuf headersAndPayload) {
        long maxDeliveryDelayInMs;
        if (this.isDelayedDeliveryEnabled() && (maxDeliveryDelayInMs = this.getDelayedDeliveryMaxDelayInMillis()) > 0L) {
            headersAndPayload.markReaderIndex();
            MessageMetadata msgMetadata = Commands.parseMessageMetadata((ByteBuf)headersAndPayload);
            headersAndPayload.resetReaderIndex();
            return msgMetadata.hasDeliverAtTime() && msgMetadata.getDeliverAtTime() - msgMetadata.getPublishTime() > maxDeliveryDelayInMs;
        }
        return false;
    }

    @Override
    public PersistentTopicAttributes getTopicAttributes() {
        if (this.persistentTopicAttributes != null) {
            return this.persistentTopicAttributes;
        }
        return PERSISTENT_TOPIC_ATTRIBUTES_FIELD_UPDATER.updateAndGet(this, old -> old != null ? old : new PersistentTopicAttributes(TopicName.get((String)this.topic)));
    }

    public long getTopicCreationTimeStamp() {
        return this.ledger.getMetadataCreationTimestamp();
    }

    private CompletableFuture<Long> getLastMessagePublishTime() {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            Position lastPosition = this.ledger.getLastConfirmedEntry();
            if (lastPosition == null || lastPosition.getEntryId() < 0L || !this.ledger.getLedgersInfo().containsKey(lastPosition.getLedgerId())) {
                future.complete(0L);
                return future;
            }
            this.ledger.asyncReadEntry(lastPosition, new AsyncCallbacks.ReadEntryCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void readEntryComplete(Entry entry, Object ctx) {
                    try {
                        ByteBuf metadataAndPayload = entry.getDataBuffer();
                        MessageMetadata msgMetadata = entry.getMessageMetadata();
                        if (msgMetadata == null) {
                            msgMetadata = Commands.parseMessageMetadata((ByteBuf)metadataAndPayload);
                        }
                        long publishTime = msgMetadata.getPublishTime();
                        future.complete(publishTime);
                    }
                    catch (Exception e) {
                        log.warn("[{}] Failed to parse message metadata for last publish time", (Object)PersistentTopic.this.topic, (Object)e);
                        future.complete(0L);
                    }
                    finally {
                        entry.release();
                    }
                }

                public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                    log.warn("[{}] Failed to read last entry for publish time", (Object)PersistentTopic.this.topic, (Object)exception);
                    future.complete(0L);
                }
            }, null);
        }
        catch (Exception e) {
            log.warn("[{}] Failed to get last position for publish time", (Object)this.topic, (Object)e);
            future.complete(0L);
        }
        return future;
    }

    @Generated
    public List<String> getShadowTopics() {
        return this.shadowTopics;
    }

    @Generated
    public long getBackloggedCursorThresholdEntries() {
        return this.backloggedCursorThresholdEntries;
    }

    @Generated
    public boolean isClosingOrDeleting() {
        return this.isClosingOrDeleting;
    }

    @Generated
    public TransactionBuffer getTransactionBuffer() {
        return this.transactionBuffer;
    }

    @Generated
    public TopicTransactionBuffer.MaxReadPositionCallBack getMaxReadPositionCallBack() {
        return this.maxReadPositionCallBack;
    }

    @Generated
    public long getLastMaxReadPositionMovedForwardTimestamp() {
        return this.lastMaxReadPositionMovedForwardTimestamp;
    }

    @Generated
    public ExecutorService getOrderedExecutor() {
        return this.orderedExecutor;
    }

    @Generated
    public PersistentTopicMetrics getPersistentTopicMetrics() {
        return this.persistentTopicMetrics;
    }

    private class CloseFutures {
        private final CompletableFuture<Void> transferring;
        private final CompletableFuture<Void> notWaitDisconnectClients;
        private final CompletableFuture<Void> waitDisconnectClients;

        public CloseFutures(CompletableFuture<Void> transferring, CompletableFuture<Void> waitDisconnectClients, CompletableFuture<Void> notWaitDisconnectClients) {
            this.transferring = transferring;
            this.waitDisconnectClients = waitDisconnectClients;
            this.notWaitDisconnectClients = notWaitDisconnectClients;
        }
    }

    private static enum CloseTypes {
        transferring,
        notWaitDisconnectClients,
        waitDisconnectClients;

    }

    private static class TopicStatsHelper {
        public double averageMsgSize;
        public double aggMsgRateIn;
        public double aggMsgThroughputIn;
        public double aggMsgThrottlingFailure;
        public double aggMsgRateOut;
        public double aggMsgThroughputOut;
        public final ObjectObjectHashMap<String, PublisherStatsImpl> remotePublishersStats = new ObjectObjectHashMap();

        public TopicStatsHelper() {
            this.reset();
        }

        public void reset() {
            this.averageMsgSize = 0.0;
            this.aggMsgRateIn = 0.0;
            this.aggMsgThroughputIn = 0.0;
            this.aggMsgRateOut = 0.0;
            this.aggMsgThrottlingFailure = 0.0;
            this.aggMsgThroughputOut = 0.0;
            this.remotePublishersStats.clear();
        }
    }

    private static final class OldestPositionInfo {
        private final Position oldestCursorMarkDeletePosition;
        private final String cursorName;
        private final long positionPublishTimestampInMillis;
        private final long dataVersion;

        @Generated
        public OldestPositionInfo(Position oldestCursorMarkDeletePosition, String cursorName, long positionPublishTimestampInMillis, long dataVersion) {
            this.oldestCursorMarkDeletePosition = oldestCursorMarkDeletePosition;
            this.cursorName = cursorName;
            this.positionPublishTimestampInMillis = positionPublishTimestampInMillis;
            this.dataVersion = dataVersion;
        }

        @Generated
        public Position getOldestCursorMarkDeletePosition() {
            return this.oldestCursorMarkDeletePosition;
        }

        @Generated
        public String getCursorName() {
            return this.cursorName;
        }

        @Generated
        public long getPositionPublishTimestampInMillis() {
            return this.positionPublishTimestampInMillis;
        }

        @Generated
        public long getDataVersion() {
            return this.dataVersion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OldestPositionInfo)) {
                return false;
            }
            OldestPositionInfo other = (OldestPositionInfo)o;
            if (this.getPositionPublishTimestampInMillis() != other.getPositionPublishTimestampInMillis()) {
                return false;
            }
            if (this.getDataVersion() != other.getDataVersion()) {
                return false;
            }
            Position this$oldestCursorMarkDeletePosition = this.getOldestCursorMarkDeletePosition();
            Position other$oldestCursorMarkDeletePosition = other.getOldestCursorMarkDeletePosition();
            if (this$oldestCursorMarkDeletePosition == null ? other$oldestCursorMarkDeletePosition != null : !this$oldestCursorMarkDeletePosition.equals(other$oldestCursorMarkDeletePosition)) {
                return false;
            }
            String this$cursorName = this.getCursorName();
            String other$cursorName = other.getCursorName();
            return !(this$cursorName == null ? other$cursorName != null : !this$cursorName.equals(other$cursorName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $positionPublishTimestampInMillis = this.getPositionPublishTimestampInMillis();
            result = result * 59 + (int)($positionPublishTimestampInMillis >>> 32 ^ $positionPublishTimestampInMillis);
            long $dataVersion = this.getDataVersion();
            result = result * 59 + (int)($dataVersion >>> 32 ^ $dataVersion);
            Position $oldestCursorMarkDeletePosition = this.getOldestCursorMarkDeletePosition();
            result = result * 59 + ($oldestCursorMarkDeletePosition == null ? 43 : $oldestCursorMarkDeletePosition.hashCode());
            String $cursorName = this.getCursorName();
            result = result * 59 + ($cursorName == null ? 43 : $cursorName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PersistentTopic.OldestPositionInfo(oldestCursorMarkDeletePosition=" + String.valueOf(this.getOldestCursorMarkDeletePosition()) + ", cursorName=" + this.getCursorName() + ", positionPublishTimestampInMillis=" + this.getPositionPublishTimestampInMillis() + ", dataVersion=" + this.getDataVersion() + ")";
        }
    }

    private static final class EstimateTimeBasedBacklogQuotaCheckResult {
        private final boolean truncateBacklogToMatchQuota;
        private final Long estimatedOldestUnacknowledgedMessageTimestamp;

        @Generated
        public EstimateTimeBasedBacklogQuotaCheckResult(boolean truncateBacklogToMatchQuota, Long estimatedOldestUnacknowledgedMessageTimestamp) {
            this.truncateBacklogToMatchQuota = truncateBacklogToMatchQuota;
            this.estimatedOldestUnacknowledgedMessageTimestamp = estimatedOldestUnacknowledgedMessageTimestamp;
        }

        @Generated
        public boolean isTruncateBacklogToMatchQuota() {
            return this.truncateBacklogToMatchQuota;
        }

        @Generated
        public Long getEstimatedOldestUnacknowledgedMessageTimestamp() {
            return this.estimatedOldestUnacknowledgedMessageTimestamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EstimateTimeBasedBacklogQuotaCheckResult)) {
                return false;
            }
            EstimateTimeBasedBacklogQuotaCheckResult other = (EstimateTimeBasedBacklogQuotaCheckResult)o;
            if (this.isTruncateBacklogToMatchQuota() != other.isTruncateBacklogToMatchQuota()) {
                return false;
            }
            Long this$estimatedOldestUnacknowledgedMessageTimestamp = this.getEstimatedOldestUnacknowledgedMessageTimestamp();
            Long other$estimatedOldestUnacknowledgedMessageTimestamp = other.getEstimatedOldestUnacknowledgedMessageTimestamp();
            return !(this$estimatedOldestUnacknowledgedMessageTimestamp == null ? other$estimatedOldestUnacknowledgedMessageTimestamp != null : !((Object)this$estimatedOldestUnacknowledgedMessageTimestamp).equals(other$estimatedOldestUnacknowledgedMessageTimestamp));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isTruncateBacklogToMatchQuota() ? 79 : 97);
            Long $estimatedOldestUnacknowledgedMessageTimestamp = this.getEstimatedOldestUnacknowledgedMessageTimestamp();
            result = result * 59 + ($estimatedOldestUnacknowledgedMessageTimestamp == null ? 43 : ((Object)$estimatedOldestUnacknowledgedMessageTimestamp).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PersistentTopic.EstimateTimeBasedBacklogQuotaCheckResult(truncateBacklogToMatchQuota=" + this.isTruncateBacklogToMatchQuota() + ", estimatedOldestUnacknowledgedMessageTimestamp=" + this.getEstimatedOldestUnacknowledgedMessageTimestamp() + ")";
        }
    }
}

