/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.ranger.plugin.resourcematcher.AbstractStringResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;

final class QuotedCaseSensitiveWildcardMatcher
extends AbstractStringResourceMatcher {
    private final String quoteChars;

    QuotedCaseSensitiveWildcardMatcher(String value, Map<String, String> options, String quoteChars) {
        super(value, options);
        this.quoteChars = quoteChars;
    }

    @Override
    boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
        IOCase caseSensitivity = QuotedCaseSensitiveWildcardMatcher.startsWithAnyChar(resourceValue, this.quoteChars) ? IOCase.SENSITIVE : IOCase.INSENSITIVE;
        return FilenameUtils.wildcardMatch((String)resourceValue, (String)this.getExpandedValue(evalContext), (IOCase)caseSensitivity);
    }

    @Override
    public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
        IOCase caseSensitivity = QuotedCaseSensitiveWildcardMatcher.startsWithAnyChar(resourceValue, this.quoteChars) ? IOCase.SENSITIVE : IOCase.INSENSITIVE;
        return ResourceMatcher.wildcardPrefixMatch(resourceValue, this.getExpandedValue(evalContext), caseSensitivity);
    }

    @Override
    int getPriority() {
        return 6 + (this.getNeedsDynamicEval() ? 8 : 0);
    }
}

