/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.containerregistry.Architecture;
import com.microsoft.azure.management.containerregistry.OverridingValue;
import com.microsoft.azure.management.containerregistry.PlatformProperties;
import com.microsoft.azure.management.containerregistry.ProvisioningState;
import com.microsoft.azure.management.containerregistry.RegistryDockerTaskRunRequest;
import com.microsoft.azure.management.containerregistry.RegistryEncodedTaskRunRequest;
import com.microsoft.azure.management.containerregistry.RegistryFileTaskRunRequest;
import com.microsoft.azure.management.containerregistry.RunStatus;
import com.microsoft.azure.management.containerregistry.RunType;
import com.microsoft.azure.management.containerregistry.Variant;
import com.microsoft.azure.management.containerregistry.implementation.RunInner;
import com.microsoft.azure.management.resources.fluentcore.model.Executable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import java.util.Map;
import org.joda.time.DateTime;

@Fluent
@Beta(value=Beta.SinceVersion.V1_17_0)
public interface RegistryTaskRun
extends HasInner<RunInner>,
Refreshable<RegistryTaskRun> {
    public String resourceGroupName();

    public String registryName();

    public String taskName();

    public RunStatus status();

    public RunType runType();

    public DateTime lastUpdatedTime();

    public DateTime createTime();

    public boolean isArchiveEnabled();

    public PlatformProperties platform();

    public int cpu();

    public ProvisioningState provisioningState();

    public String runId();

    public static interface DefinitionStages {

        public static interface RunRequestExecutable
        extends Archive,
        Executable<RegistryTaskRun> {
        }

        public static interface RunRequestExecutableWithSourceLocation
        extends AgentConfiguration,
        RunRequestExecutable {
            public RunRequestExecutableWithSourceLocation withSourceLocation(String var1);

            public RunRequestExecutableWithSourceLocation withTimeout(int var1);
        }

        public static interface Archive {
            public RunRequestExecutable withArchiveEnabled(boolean var1);
        }

        public static interface AgentConfiguration {
            public RunRequestExecutable withCpuCount(int var1);
        }

        public static interface RunRequestType {
            public RegistryFileTaskRunRequest.DefinitionStages.Blank withFileTaskRunRequest();

            public RegistryEncodedTaskRunRequest.DefinitionStages.Blank withEncodedTaskRunRequest();

            public RegistryDockerTaskRunRequest.DefinitionStages.Blank withDockerTaskRunRequest();
        }

        public static interface Platform {
            public RunRequestType withLinux();

            public RunRequestType withWindows();

            public RunRequestType withLinux(Architecture var1);

            public RunRequestType withWindows(Architecture var1);

            public RunRequestType withLinux(Architecture var1, Variant var2);

            public RunRequestType withWindows(Architecture var1, Variant var2);

            public RunRequestType withPlatform(PlatformProperties var1);
        }

        public static interface RegistryTaskRunRequest
        extends RunRequestExecutable {
            public RegistryTaskRunRequest withOverridingValues(Map<String, OverridingValue> var1);

            public RegistryTaskRunRequest withOverridingValue(String var1, OverridingValue var2);

            @Override
            public RegistryTaskRunRequest withArchiveEnabled(boolean var1);
        }

        public static interface PlatformAltTaskRunRequest
        extends Platform {
            public RegistryTaskRunRequest withTaskRunRequest(String var1);
        }

        public static interface BlankFromRuns {
            public PlatformAltTaskRunRequest withExistingRegistry(String var1, String var2);
        }

        public static interface BlankFromRegistry
        extends PlatformAltTaskRunRequest {
        }
    }

    public static interface Definition
    extends DefinitionStages.BlankFromRegistry,
    DefinitionStages.BlankFromRuns,
    DefinitionStages.Platform,
    DefinitionStages.PlatformAltTaskRunRequest,
    DefinitionStages.RegistryTaskRunRequest,
    DefinitionStages.RunRequestType,
    DefinitionStages.RunRequestExecutableWithSourceLocation,
    DefinitionStages.RunRequestExecutable {
    }
}

