/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.ActivityLogAlert;
import com.microsoft.azure.management.monitor.ActivityLogAlertActionGroup;
import com.microsoft.azure.management.monitor.ActivityLogAlertActionList;
import com.microsoft.azure.management.monitor.ActivityLogAlertAllOfCondition;
import com.microsoft.azure.management.monitor.ActivityLogAlertLeafCondition;
import com.microsoft.azure.management.monitor.implementation.ActivityLogAlertResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;

@LangDefinition
class ActivityLogAlertImpl
extends GroupableResourceImpl<ActivityLogAlert, ActivityLogAlertResourceInner, ActivityLogAlertImpl, MonitorManager>
implements ActivityLogAlert,
ActivityLogAlert.Definition,
ActivityLogAlert.Update,
ActivityLogAlert.UpdateStages.WithActivityLogUpdate {
    private Map<String, String> conditions = new TreeMap<String, String>();

    ActivityLogAlertImpl(String name, ActivityLogAlertResourceInner innerModel, MonitorManager monitorManager) {
        super(name, (Resource)innerModel, (ManagerBase)monitorManager);
        if (innerModel.condition() != null && innerModel.condition().allOf() != null) {
            for (ActivityLogAlertLeafCondition aac : innerModel.condition().allOf()) {
                this.conditions.put(aac.field(), aac.equals());
            }
        }
    }

    @Override
    public Collection<String> scopes() {
        return Collections.unmodifiableCollection(((ActivityLogAlertResourceInner)((Object)this.inner())).scopes());
    }

    @Override
    public Boolean enabled() {
        return ((ActivityLogAlertResourceInner)((Object)this.inner())).enabled();
    }

    @Override
    public Map<String, String> equalsConditions() {
        return this.conditions;
    }

    @Override
    public Collection<String> actionGroupIds() {
        if (((ActivityLogAlertResourceInner)((Object)this.inner())).actions() != null && ((ActivityLogAlertResourceInner)((Object)this.inner())).actions().actionGroups() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            for (ActivityLogAlertActionGroup alaag : ((ActivityLogAlertResourceInner)((Object)this.inner())).actions().actionGroups()) {
                ids.add(alaag.actionGroupId());
            }
            return Collections.unmodifiableCollection(ids);
        }
        return Collections.emptyList();
    }

    @Override
    public String description() {
        return ((ActivityLogAlertResourceInner)((Object)this.inner())).description();
    }

    public Observable<ActivityLogAlert> createResourceAsync() {
        ((ActivityLogAlertResourceInner)((Object)this.inner())).withLocation("global");
        ActivityLogAlertAllOfCondition condition = new ActivityLogAlertAllOfCondition();
        condition.withAllOf(new ArrayList<ActivityLogAlertLeafCondition>());
        for (Map.Entry<String, String> cds : this.conditions.entrySet()) {
            ActivityLogAlertLeafCondition alalc = new ActivityLogAlertLeafCondition();
            alalc.withField(cds.getKey());
            alalc.withEquals(cds.getValue());
            condition.allOf().add(alalc);
        }
        ((ActivityLogAlertResourceInner)((Object)this.inner())).withCondition(condition);
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).activityLogAlerts().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ActivityLogAlertResourceInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<ActivityLogAlertResourceInner> getInnerAsync() {
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).activityLogAlerts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public ActivityLogAlert.DefinitionStages.WithDescription withTargetResource(String resourceId) {
        ((ActivityLogAlertResourceInner)((Object)this.inner())).withScopes(new ArrayList<String>());
        ((ActivityLogAlertResourceInner)((Object)this.inner())).scopes().add(resourceId);
        return this;
    }

    @Override
    public ActivityLogAlert.DefinitionStages.WithDescription withTargetResource(HasId resource) {
        return this.withTargetResource(resource.id());
    }

    @Override
    public ActivityLogAlert.DefinitionStages.WithDescription withTargetSubscription(String targetSubscriptionId) {
        return this.withTargetResource("/subscriptions/" + targetSubscriptionId);
    }

    @Override
    public ActivityLogAlertImpl withDescription(String description) {
        ((ActivityLogAlertResourceInner)((Object)this.inner())).withDescription(description);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withRuleEnabled() {
        ((ActivityLogAlertResourceInner)((Object)this.inner())).withEnabled(true);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withRuleDisabled() {
        ((ActivityLogAlertResourceInner)((Object)this.inner())).withEnabled(false);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withActionGroups(String ... actionGroupId) {
        if (((ActivityLogAlertResourceInner)((Object)this.inner())).actions() == null) {
            ((ActivityLogAlertResourceInner)((Object)this.inner())).withActions(new ActivityLogAlertActionList());
            ((ActivityLogAlertResourceInner)((Object)this.inner())).actions().withActionGroups(new ArrayList<ActivityLogAlertActionGroup>());
        }
        ((ActivityLogAlertResourceInner)((Object)this.inner())).actions().actionGroups().clear();
        for (String agid : actionGroupId) {
            ActivityLogAlertActionGroup aaa = new ActivityLogAlertActionGroup();
            aaa.withActionGroupId(agid);
            ((ActivityLogAlertResourceInner)((Object)this.inner())).actions().actionGroups().add(aaa);
        }
        return this;
    }

    @Override
    public ActivityLogAlertImpl withoutActionGroup(String actionGroupId) {
        if (((ActivityLogAlertResourceInner)((Object)this.inner())).actions() != null && ((ActivityLogAlertResourceInner)((Object)this.inner())).actions().actionGroups() != null) {
            ArrayList<ActivityLogAlertActionGroup> toDelete = new ArrayList<ActivityLogAlertActionGroup>();
            for (ActivityLogAlertActionGroup aaa : ((ActivityLogAlertResourceInner)((Object)this.inner())).actions().actionGroups()) {
                if (!aaa.actionGroupId().equalsIgnoreCase(actionGroupId)) continue;
                toDelete.add(aaa);
            }
            ((ActivityLogAlertResourceInner)((Object)this.inner())).actions().actionGroups().removeAll(toDelete);
        }
        return this;
    }

    @Override
    public ActivityLogAlertImpl withEqualsCondition(String field, String equals) {
        this.withoutEqualsCondition(field);
        this.conditions.put(field, equals);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withEqualsConditions(Map<String, String> fieldEqualsMap) {
        this.conditions.clear();
        this.conditions.putAll(fieldEqualsMap);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withoutEqualsCondition(String field) {
        if (this.conditions.containsKey(field)) {
            this.conditions.remove(field);
        }
        return this;
    }
}

