/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.RoleDefinition;
import com.microsoft.azure.management.graphrbac.RoleDefinitions;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleDefinitionImpl;
import com.microsoft.azure.management.graphrbac.implementation.RoleDefinitionInner;
import com.microsoft.azure.management.graphrbac.implementation.RoleDefinitionsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
class RoleDefinitionsImpl
extends ReadableWrappersImpl<RoleDefinition, RoleDefinitionImpl, RoleDefinitionInner>
implements RoleDefinitions,
HasInner<RoleDefinitionsInner> {
    private final GraphRbacManager manager;

    RoleDefinitionsImpl(GraphRbacManager manager) {
        this.manager = manager;
    }

    protected RoleDefinitionImpl wrapModel(RoleDefinitionInner roleDefinitionInner) {
        if (roleDefinitionInner == null) {
            return null;
        }
        return new RoleDefinitionImpl(roleDefinitionInner, this.manager());
    }

    public RoleDefinitionImpl getById(String objectId) {
        return (RoleDefinitionImpl)this.getByIdAsync(objectId).toBlocking().single();
    }

    public Observable<RoleDefinition> getByIdAsync(String id) {
        return this.manager().roleInner().roleDefinitions().getByIdAsync(id).map((Func1)new Func1<RoleDefinitionInner, RoleDefinition>(){

            public RoleDefinition call(RoleDefinitionInner roleDefinitionInner) {
                if (roleDefinitionInner == null) {
                    return null;
                }
                return new RoleDefinitionImpl(roleDefinitionInner, RoleDefinitionsImpl.this.manager());
            }
        });
    }

    public ServiceFuture<RoleDefinition> getByIdAsync(String id, ServiceCallback<RoleDefinition> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    @Override
    public RoleDefinitionImpl getByScope(String scope, String name) {
        return (RoleDefinitionImpl)this.getByScopeAsync(scope, name).toBlocking().single();
    }

    @Override
    public ServiceFuture<RoleDefinition> getByScopeAsync(String scope, String name, ServiceCallback<RoleDefinition> callback) {
        return ServiceFuture.fromBody(this.getByScopeAsync(scope, name), callback);
    }

    @Override
    public Observable<RoleDefinition> getByScopeAsync(String scope, String name) {
        return this.manager().roleInner().roleDefinitions().getAsync(scope, name).map((Func1)new Func1<RoleDefinitionInner, RoleDefinition>(){

            public RoleDefinition call(RoleDefinitionInner roleDefinitionInner) {
                if (roleDefinitionInner == null) {
                    return null;
                }
                return new RoleDefinitionImpl(roleDefinitionInner, RoleDefinitionsImpl.this.manager());
            }
        });
    }

    @Override
    public RoleDefinitionImpl getByScopeAndRoleName(String scope, String roleName) {
        return (RoleDefinitionImpl)this.getByScopeAndRoleNameAsync(scope, roleName).toBlocking().single();
    }

    @Override
    public Observable<RoleDefinition> listByScopeAsync(String scope) {
        return this.wrapPageAsync(this.manager().roleInner().roleDefinitions().listAsync(scope));
    }

    @Override
    public PagedList<RoleDefinition> listByScope(String scope) {
        return this.wrapList(this.manager().roleInner().roleDefinitions().list(scope));
    }

    @Override
    public ServiceFuture<RoleDefinition> getByScopeAndRoleNameAsync(String scope, String roleName, ServiceCallback<RoleDefinition> callback) {
        return ServiceFuture.fromBody(this.getByScopeAndRoleNameAsync(scope, roleName), callback);
    }

    @Override
    public Observable<RoleDefinition> getByScopeAndRoleNameAsync(String scope, String roleName) {
        return this.manager().roleInner().roleDefinitions().listAsync(scope, String.format("roleName eq '%s'", roleName)).map((Func1)new Func1<Page<RoleDefinitionInner>, RoleDefinition>(){

            public RoleDefinition call(Page<RoleDefinitionInner> roleDefinitionInnerPage) {
                if (roleDefinitionInnerPage == null || roleDefinitionInnerPage.items() == null || roleDefinitionInnerPage.items().isEmpty()) {
                    return null;
                }
                return new RoleDefinitionImpl((RoleDefinitionInner)roleDefinitionInnerPage.items().get(0), RoleDefinitionsImpl.this.manager());
            }
        });
    }

    public RoleDefinitionsInner inner() {
        return this.manager().roleInner().roleDefinitions();
    }

    public GraphRbacManager manager() {
        return this.manager;
    }
}

