/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.TopLevelDomainAgreementOption;
import com.microsoft.azure.management.appservice.implementation.PageImpl;
import com.microsoft.azure.management.appservice.implementation.TldLegalAgreementInner;
import com.microsoft.azure.management.appservice.implementation.TopLevelDomainInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class TopLevelDomainsInner {
    private TopLevelDomainsService service;
    private WebSiteManagementClientImpl client;

    public TopLevelDomainsInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (TopLevelDomainsService)retrofit.create(TopLevelDomainsService.class);
        this.client = client;
    }

    public PagedList<TopLevelDomainInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<TopLevelDomainInner>((Page)response.body()){

            public Page<TopLevelDomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TopLevelDomainsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TopLevelDomainInner>> listAsync(ListOperationCallback<TopLevelDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<TopLevelDomainInner>>>>(){

            public Observable<ServiceResponse<Page<TopLevelDomainInner>>> call(String nextPageLink) {
                return TopLevelDomainsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TopLevelDomainInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<TopLevelDomainInner>>, Page<TopLevelDomainInner>>(){

            public Page<TopLevelDomainInner> call(ServiceResponse<Page<TopLevelDomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TopLevelDomainInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<TopLevelDomainInner>>, Observable<ServiceResponse<Page<TopLevelDomainInner>>>>(){

            public Observable<ServiceResponse<Page<TopLevelDomainInner>>> call(ServiceResponse<Page<TopLevelDomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TopLevelDomainsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TopLevelDomainInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TopLevelDomainInner>>>>(){

            public Observable<ServiceResponse<Page<TopLevelDomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TopLevelDomainsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TopLevelDomainInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TopLevelDomainInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public TopLevelDomainInner get(String name) {
        return (TopLevelDomainInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(name).toBlocking().single()).body());
    }

    public ServiceFuture<TopLevelDomainInner> getAsync(String name, ServiceCallback<TopLevelDomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<TopLevelDomainInner> getAsync(String name) {
        return this.getWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<TopLevelDomainInner>, TopLevelDomainInner>(){

            public TopLevelDomainInner call(ServiceResponse<TopLevelDomainInner> response) {
                return (TopLevelDomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TopLevelDomainInner>> getWithServiceResponseAsync(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TopLevelDomainInner>>>(){

            public Observable<ServiceResponse<TopLevelDomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TopLevelDomainsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TopLevelDomainInner> getDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TopLevelDomainInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<TldLegalAgreementInner> listAgreements(String name, TopLevelDomainAgreementOption agreementOption) {
        ServiceResponse response = (ServiceResponse)this.listAgreementsSinglePageAsync(name, agreementOption).toBlocking().single();
        return new PagedList<TldLegalAgreementInner>((Page)response.body()){

            public Page<TldLegalAgreementInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TopLevelDomainsInner.this.listAgreementsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TldLegalAgreementInner>> listAgreementsAsync(String name, TopLevelDomainAgreementOption agreementOption, ListOperationCallback<TldLegalAgreementInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAgreementsSinglePageAsync(name, agreementOption), (Func1)new Func1<String, Observable<ServiceResponse<Page<TldLegalAgreementInner>>>>(){

            public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> call(String nextPageLink) {
                return TopLevelDomainsInner.this.listAgreementsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TldLegalAgreementInner>> listAgreementsAsync(String name, TopLevelDomainAgreementOption agreementOption) {
        return this.listAgreementsWithServiceResponseAsync(name, agreementOption).map((Func1)new Func1<ServiceResponse<Page<TldLegalAgreementInner>>, Page<TldLegalAgreementInner>>(){

            public Page<TldLegalAgreementInner> call(ServiceResponse<Page<TldLegalAgreementInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> listAgreementsWithServiceResponseAsync(String name, TopLevelDomainAgreementOption agreementOption) {
        return this.listAgreementsSinglePageAsync(name, agreementOption).concatMap((Func1)new Func1<ServiceResponse<Page<TldLegalAgreementInner>>, Observable<ServiceResponse<Page<TldLegalAgreementInner>>>>(){

            public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> call(ServiceResponse<Page<TldLegalAgreementInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TopLevelDomainsInner.this.listAgreementsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> listAgreementsSinglePageAsync(String name, TopLevelDomainAgreementOption agreementOption) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (agreementOption == null) {
            throw new IllegalArgumentException("Parameter agreementOption is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)agreementOption);
        return this.service.listAgreements(name, this.client.subscriptionId(), agreementOption, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TldLegalAgreementInner>>>>(){

            public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TopLevelDomainsInner.this.listAgreementsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TldLegalAgreementInner>> listAgreementsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TldLegalAgreementInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<TopLevelDomainInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<TopLevelDomainInner>((Page)response.body()){

            public Page<TopLevelDomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TopLevelDomainsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TopLevelDomainInner>> listNextAsync(String nextPageLink, ServiceFuture<List<TopLevelDomainInner>> serviceFuture, ListOperationCallback<TopLevelDomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<TopLevelDomainInner>>>>(){

            public Observable<ServiceResponse<Page<TopLevelDomainInner>>> call(String nextPageLink) {
                return TopLevelDomainsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TopLevelDomainInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<TopLevelDomainInner>>, Page<TopLevelDomainInner>>(){

            public Page<TopLevelDomainInner> call(ServiceResponse<Page<TopLevelDomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TopLevelDomainInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<TopLevelDomainInner>>, Observable<ServiceResponse<Page<TopLevelDomainInner>>>>(){

            public Observable<ServiceResponse<Page<TopLevelDomainInner>>> call(ServiceResponse<Page<TopLevelDomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TopLevelDomainsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TopLevelDomainInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TopLevelDomainInner>>>>(){

            public Observable<ServiceResponse<Page<TopLevelDomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TopLevelDomainsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TopLevelDomainInner>> listNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TopLevelDomainInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<TldLegalAgreementInner> listAgreementsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAgreementsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<TldLegalAgreementInner>((Page)response.body()){

            public Page<TldLegalAgreementInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TopLevelDomainsInner.this.listAgreementsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TldLegalAgreementInner>> listAgreementsNextAsync(String nextPageLink, ServiceFuture<List<TldLegalAgreementInner>> serviceFuture, ListOperationCallback<TldLegalAgreementInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAgreementsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<TldLegalAgreementInner>>>>(){

            public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> call(String nextPageLink) {
                return TopLevelDomainsInner.this.listAgreementsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TldLegalAgreementInner>> listAgreementsNextAsync(String nextPageLink) {
        return this.listAgreementsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<TldLegalAgreementInner>>, Page<TldLegalAgreementInner>>(){

            public Page<TldLegalAgreementInner> call(ServiceResponse<Page<TldLegalAgreementInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> listAgreementsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAgreementsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<TldLegalAgreementInner>>, Observable<ServiceResponse<Page<TldLegalAgreementInner>>>>(){

            public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> call(ServiceResponse<Page<TldLegalAgreementInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TopLevelDomainsInner.this.listAgreementsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> listAgreementsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAgreementsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TldLegalAgreementInner>>>>(){

            public Observable<ServiceResponse<Page<TldLegalAgreementInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TopLevelDomainsInner.this.listAgreementsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TldLegalAgreementInner>> listAgreementsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TldLegalAgreementInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    static interface TopLevelDomainsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.TopLevelDomains list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/topLevelDomains")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.TopLevelDomains get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/topLevelDomains/{name}")
        public Observable<Response<ResponseBody>> get(@Path(value="name") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.TopLevelDomains listAgreements"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/topLevelDomains/{name}/listAgreements")
        public Observable<Response<ResponseBody>> listAgreements(@Path(value="name") String var1, @Path(value="subscriptionId") String var2, @Body TopLevelDomainAgreementOption var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.TopLevelDomains listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.TopLevelDomains listAgreementsNext"})
        @GET
        public Observable<Response<ResponseBody>> listAgreementsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

