/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.ratis.examples.filestore.FileStoreClient;
import org.apache.ratis.examples.filestore.cli.Client;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.ratis.util.FileUtils;

@Parameters(commandDescription="Load Generator for FileStore")
public class LoadGen
extends Client {
    @Parameter(names={"--sync"}, description="Whether sync every bufferSize", required=false)
    private int sync = 0;

    @Override
    protected void operation(List<FileStoreClient> clients) throws IOException, ExecutionException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(this.getNumThread());
        List<String> paths = this.generateFiles(executor);
        this.dropCache();
        System.out.println("Starting Async write now ");
        long startTime = System.currentTimeMillis();
        long totalWrittenBytes = this.waitWriteFinish(this.writeByHeapByteBuffer(paths, clients, executor));
        long endTime = System.currentTimeMillis();
        System.out.println("Total files written: " + this.getNumFiles());
        System.out.println("Each files size: " + this.getFileSizeInBytes());
        System.out.println("Total data written: " + totalWrittenBytes + " bytes");
        System.out.println("Total time taken: " + (endTime - startTime) + " millis");
        this.close(clients);
    }

    long write(FileChannel in, long offset, FileStoreClient fileStoreClient, String path, List<CompletableFuture<Long>> futures) throws IOException {
        int bufferSize = this.getBufferSizeInBytes();
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.heapBuffer(bufferSize);
        int bytesRead = buf.writeBytes(in, bufferSize);
        if (bytesRead < 0) {
            throw new IllegalStateException("Failed to read " + bufferSize + " byte(s) from " + this + ". The channel has reached end-of-stream at " + offset);
        }
        if (bytesRead > 0) {
            CompletableFuture<Long> f = fileStoreClient.writeAsync(path, offset, offset + (long)bytesRead == this.getFileSizeInBytes(), buf.nioBuffer(), this.sync == 1);
            f.thenRun(buf::release);
            futures.add(f);
        }
        return bytesRead;
    }

    private Map<String, CompletableFuture<List<CompletableFuture<Long>>>> writeByHeapByteBuffer(List<String> paths, List<FileStoreClient> clients, ExecutorService executor) {
        HashMap<String, CompletableFuture<List<CompletableFuture<Long>>>> fileMap = new HashMap<String, CompletableFuture<List<CompletableFuture<Long>>>>();
        int clientIndex = 0;
        for (String path : paths) {
            CompletableFuture future = new CompletableFuture();
            FileStoreClient client = clients.get(clientIndex % clients.size());
            ++clientIndex;
            CompletableFuture.supplyAsync(() -> {
                ArrayList<CompletableFuture<Long>> futures = new ArrayList<CompletableFuture<Long>>();
                File file = new File(path);
                try (FileChannel in = FileUtils.newFileChannel(file, StandardOpenOption.READ);){
                    for (long offset = 0L; offset < this.getFileSizeInBytes(); offset += this.write(in, offset, client, file.getName(), futures)) {
                    }
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
                future.complete(futures);
                return future;
            }, executor);
            fileMap.put(path, future);
        }
        return fileMap;
    }

    private long waitWriteFinish(Map<String, CompletableFuture<List<CompletableFuture<Long>>>> fileMap) throws ExecutionException, InterruptedException {
        long totalBytes = 0L;
        for (CompletableFuture<List<CompletableFuture<Long>>> futures : fileMap.values()) {
            long writtenLen = 0L;
            for (CompletableFuture<Long> future : futures.get()) {
                writtenLen += future.join().longValue();
            }
            if (writtenLen != this.getFileSizeInBytes()) {
                System.out.println("File written:" + writtenLen + " does not match expected:" + this.getFileSizeInBytes());
            }
            totalBytes += writtenLen;
        }
        return totalBytes;
    }
}

