/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.pipeline;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import java.util.List;
import org.apache.rocketmq.auth.authentication.exception.AuthenticationException;
import org.apache.rocketmq.auth.authorization.AuthorizationEvaluator;
import org.apache.rocketmq.auth.authorization.context.AuthorizationContext;
import org.apache.rocketmq.auth.authorization.exception.AuthorizationException;
import org.apache.rocketmq.auth.authorization.factory.AuthorizationFactory;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.grpc.pipeline.RequestPipeline;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;

public class AuthorizationPipeline
implements RequestPipeline {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final AuthConfig authConfig;
    private final AuthorizationEvaluator authorizationEvaluator;

    public AuthorizationPipeline(AuthConfig authConfig, MessagingProcessor messagingProcessor) {
        this.authConfig = authConfig;
        this.authorizationEvaluator = AuthorizationFactory.getEvaluator((AuthConfig)authConfig, messagingProcessor::getMetadataService);
    }

    @Override
    public void execute(ProxyContext context, Metadata headers, GeneratedMessageV3 request) {
        if (!this.authConfig.isAuthorizationEnabled()) {
            return;
        }
        try {
            List<AuthorizationContext> contexts = this.newContexts(context, headers, request);
            this.authorizationEvaluator.evaluate(contexts);
        }
        catch (AuthenticationException | AuthorizationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            LOGGER.error("authorize failed, request:{}", (Object)request, (Object)ex);
            throw ex;
        }
    }

    protected List<AuthorizationContext> newContexts(ProxyContext context, Metadata headers, GeneratedMessageV3 request) {
        return AuthorizationFactory.newContexts((AuthConfig)this.authConfig, (Metadata)headers, (GeneratedMessageV3)request);
    }
}

