/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class MessageStoreStateMachine {
    protected final Logger log;
    private MessageStoreState currentState;
    private long lastStateChangeTimestamp;
    private final long startTimestamp;

    public MessageStoreStateMachine(Logger log) {
        this.log = log == null ? LoggerFactory.getLogger((String)"RocketmqStore") : log;
        this.currentState = MessageStoreState.INIT;
        this.lastStateChangeTimestamp = this.startTimestamp = System.currentTimeMillis();
        this.logStateChange(null, this.currentState, true);
    }

    public void transitTo(MessageStoreState newState) {
        this.transitTo(newState, true);
    }

    public void transitTo(MessageStoreState newState, boolean success) {
        if (!newState.isAfter(this.currentState)) {
            throw new IllegalStateException(String.format("Invalid state transition from %s to %s. Can only move forward.", new Object[]{this.currentState, newState}));
        }
        this.logStateChange(this.currentState, newState, success);
        if (success) {
            this.currentState = newState;
            this.lastStateChangeTimestamp = System.currentTimeMillis();
        }
    }

    private void logStateChange(MessageStoreState fromState, MessageStoreState toState, boolean success) {
        if (fromState == null && success) {
            this.log.info("MessageStoreState initialized, state={}", (Object)toState);
        } else if (success) {
            this.log.info("MessageStoreState transition from {} to {}; Time in previous state={}ms, Total time={}ms", new Object[]{fromState, toState, this.getCurrentStateRunningTimeMs(), this.getTotalRunningTimeMs()});
        } else {
            this.log.warn("MessageStoreState transition from {} to {} failed; Time in previous state={}ms, Total time={}ms", new Object[]{fromState, toState, this.getCurrentStateRunningTimeMs(), this.getTotalRunningTimeMs()});
        }
    }

    public MessageStoreState getCurrentState() {
        return this.currentState;
    }

    public long getTotalRunningTimeMs() {
        return System.currentTimeMillis() - this.startTimestamp;
    }

    public long getCurrentStateRunningTimeMs() {
        return System.currentTimeMillis() - this.lastStateChangeTimestamp;
    }

    public static enum MessageStoreState {
        INIT(0),
        LOAD_BEGIN(10),
        LOAD_COMMITLOG_OK(11),
        LOAD_CONSUME_QUEUE_OK(12),
        LOAD_COMPACTION_OK(13),
        LOAD_INDEX_OK(14),
        RECOVER_BEGIN(20),
        RECOVER_CONSUME_QUEUE_OK(21),
        RECOVER_COMMITLOG_OK(22),
        RECOVER_TOPIC_QUEUE_TABLE_OK(23),
        RUNNING(30),
        SHUTDOWN_BEGIN(40),
        SHUTDOWN_OK(41);

        final int order;

        private MessageStoreState(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isBefore(MessageStoreState storeState) {
            return this.order < storeState.order;
        }

        public boolean isAfter(MessageStoreState storeState) {
            return this.order > storeState.order;
        }
    }
}

