/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.snapshot.file;

import com.alibaba.fastjson.JSON;
import io.openmessaging.storage.dledger.snapshot.SnapshotMeta;
import io.openmessaging.storage.dledger.snapshot.SnapshotStatus;
import io.openmessaging.storage.dledger.snapshot.SnapshotWriter;
import io.openmessaging.storage.dledger.snapshot.file.FileSnapshotStore;
import io.openmessaging.storage.dledger.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnapshotWriter
implements SnapshotWriter {
    private static Logger logger = LoggerFactory.getLogger(FileSnapshotWriter.class);
    private final String snapshotStorePath;
    private final FileSnapshotStore snapshotStore;
    private SnapshotMeta snapshotMeta;

    public FileSnapshotWriter(String snapshotStorePath, FileSnapshotStore snapshotStore) {
        this.snapshotStorePath = snapshotStorePath;
        this.snapshotStore = snapshotStore;
    }

    @Override
    public void save(SnapshotStatus status) throws IOException {
        IOException ioe;
        int res;
        block9: {
            res = status.getCode();
            ioe = null;
            if (res == SnapshotStatus.SUCCESS.getCode()) {
                try {
                    this.sync();
                }
                catch (IOException e) {
                    logger.error("Unable to sync writer: {}", (Object)this.snapshotStorePath, (Object)e);
                    res = SnapshotStatus.FAIL.getCode();
                    ioe = e;
                    break block9;
                }
                long snapshotIdx = this.getSnapshotIndex();
                String tmpPath = this.snapshotStorePath;
                String officialPath = this.snapshotStore.getSnapshotStoreBaseDir() + File.separator + "snapshot_" + snapshotIdx;
                try {
                    IOUtils.atomicMvFile(new File(tmpPath), new File(officialPath));
                }
                catch (IOException e) {
                    logger.error("Unable to move temp snapshot from {} to {}", (Object)tmpPath, (Object)officialPath);
                    res = SnapshotStatus.FAIL.getCode();
                    ioe = e;
                }
            }
        }
        if (res != SnapshotStatus.SUCCESS.getCode()) {
            try {
                IOUtils.deleteFile(new File(this.snapshotStorePath));
            }
            catch (IOException e) {
                logger.error("Unable to delete temp snapshot: {}", (Object)this.snapshotStorePath, (Object)e);
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private void sync() throws IOException {
        IOUtils.string2File(JSON.toJSONString((Object)this.snapshotMeta), this.snapshotStorePath + File.separator + "snapshot_meta");
    }

    @Override
    public String getSnapshotStorePath() {
        return this.snapshotStorePath;
    }

    @Override
    public void setSnapshotMeta(SnapshotMeta snapshotMeta) {
        this.snapshotMeta = snapshotMeta;
    }

    public long getSnapshotIndex() {
        return this.snapshotMeta != null ? this.snapshotMeta.getLastIncludedIndex() : 0L;
    }
}

