/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.failover.impl;

import com.alipay.sofa.jraft.rhea.client.FutureGroup;
import com.alipay.sofa.jraft.rhea.client.failover.ListRetryCallable;
import com.alipay.sofa.jraft.rhea.errors.ApiExceptionHelper;
import com.alipay.sofa.jraft.rhea.util.Attachable;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListFailoverFuture<T>
extends CompletableFuture<List<T>>
implements Attachable<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ListFailoverFuture.class);
    private final int retriesLeft;
    private final ListRetryCallable<T> retryCallable;
    private final Object attachments;

    public ListFailoverFuture(int retriesLeft, ListRetryCallable<T> retryCallable) {
        this(retriesLeft, retryCallable, null);
    }

    public ListFailoverFuture(int retriesLeft, ListRetryCallable<T> retryCallable, Object attachments) {
        this.retriesLeft = retriesLeft;
        this.retryCallable = retryCallable;
        this.attachments = attachments;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        if (this.retriesLeft > 0 && ApiExceptionHelper.isInvalidEpoch(ex)) {
            LOG.warn("[InvalidEpoch-Failover] cause: {}, [{}] retries left.", (Object)StackTraceUtil.stackTrace(ex), (Object)this.retriesLeft);
            FutureGroup<List<T>> futureGroup = this.retryCallable.run(ex);
            CompletableFuture.allOf(futureGroup.toArray()).whenComplete((ignored, throwable) -> {
                if (throwable == null) {
                    ArrayList all = Lists.newArrayList();
                    for (CompletableFuture partOf : futureGroup.futures()) {
                        all.addAll((Collection)partOf.join());
                    }
                    super.complete(all);
                } else {
                    super.completeExceptionally((Throwable)throwable);
                }
            });
            return false;
        }
        if (this.retriesLeft <= 0) {
            LOG.error("[InvalidEpoch-Failover] cause: {}, {} retries left.", (Object)StackTraceUtil.stackTrace(ex), (Object)this.retriesLeft);
        }
        return super.completeExceptionally(ex);
    }

    @Override
    public Object getAttachments() {
        return this.attachments;
    }
}

