/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.meta;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.common.facade.MetaPersistManager;
import org.apache.rocketmq.mqtt.common.model.MqttTopic;
import org.apache.rocketmq.mqtt.common.model.Trie;
import org.apache.rocketmq.mqtt.common.util.StatUtil;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.exporter.collector.MqttMetricsCollector;
import org.apache.rocketmq.mqtt.exporter.exception.PrometheusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WildcardManager {
    private static Logger logger = LoggerFactory.getLogger(WildcardManager.class);
    private Map<String, Trie<String, Integer>> wildCardTrie = new ConcurrentHashMap<String, Trie<String, Integer>>();
    private ScheduledThreadPoolExecutor scheduler;
    @Resource
    private MetaPersistManager metaPersistManager;

    @PostConstruct
    public void init() {
        this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("loadWildcard_thread_"));
        this.scheduler.scheduleWithFixedDelay(() -> this.refreshLoadWildcard(), 0L, 5L, TimeUnit.SECONDS);
    }

    private void refreshLoadWildcard() {
        try {
            Set topics = this.metaPersistManager.getAllFirstTopics();
            if (topics == null) {
                return;
            }
            topics.forEach(firstTopic -> this.refreshWildcards((String)firstTopic));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private void refreshWildcards(String firstTopic) {
        Set wildcards;
        Trie<String, Integer> trie = new Trie<String, Integer>();
        Trie<String, Integer> old = this.wildCardTrie.putIfAbsent(firstTopic, trie);
        if (old != null) {
            trie = old;
        }
        if ((wildcards = this.metaPersistManager.getWildcards(firstTopic)) != null && !wildcards.isEmpty()) {
            for (String each : wildcards) {
                trie.addNode(each, (Object)0, (Object)"");
            }
        }
        Trie<String, Integer> finalTrie = trie;
        trie.traverseAll((path, nodeKey) -> {
            if (!wildcards.contains(path)) {
                finalTrie.deleteNode(path, nodeKey);
            }
        });
    }

    public Set<String> matchQueueSetByMsgTopic(String pubTopic, String namespace) {
        HashSet<String> queueNames = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)pubTopic)) {
            return queueNames;
        }
        MqttTopic mqttTopic = TopicUtils.decode((String)pubTopic);
        String secondTopic = TopicUtils.normalizeSecondTopic((String)mqttTopic.getSecondTopic());
        if (TopicUtils.isP2P((String)secondTopic)) {
            String p2Peer = TopicUtils.getP2Peer((MqttTopic)mqttTopic, (String)namespace);
            queueNames.add(TopicUtils.getP2pTopic((String)p2Peer));
        } else {
            queueNames.add(pubTopic);
            Set<String> wildcards = this.matchWildcards(pubTopic);
            if (wildcards != null && !wildcards.isEmpty()) {
                queueNames.addAll(wildcards);
            }
        }
        return queueNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> matchWildcards(String topic) {
        long start = System.currentTimeMillis();
        try {
            MqttTopic mqttTopic = TopicUtils.decode((String)topic);
            Trie<String, Integer> trie = this.wildCardTrie.get(mqttTopic.getFirstTopic());
            if (trie == null) {
                HashSet<String> hashSet = new HashSet<String>();
                return hashSet;
            }
            Set set = trie.getNodePath(topic);
            return set;
        }
        finally {
            long rt = System.currentTimeMillis() - start;
            StatUtil.addInvoke((String)"MatchWildcards", (long)rt);
            this.collectMatchActionMetrics(rt);
        }
    }

    private void collectMatchActionMetrics(long rt) {
        try {
            MqttMetricsCollector.collectLmqReadWriteMatchActionRt((long)rt, (String[])new String[]{"MatchWildcards", "unknown"});
        }
        catch (PrometheusException e) {
            logger.error("collect MatchWildcards metrics error", (Throwable)e);
        }
    }
}

