/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.upstream;

import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.hook.AbstractUpstreamHook;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHook;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHookEnum;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHookManager;
import org.apache.rocketmq.mqtt.common.model.MqttMessageUpContext;
import org.apache.rocketmq.mqtt.ds.upstream.processor.ConnectProcessor;
import org.apache.rocketmq.mqtt.ds.upstream.processor.DisconnectProcessor;
import org.apache.rocketmq.mqtt.ds.upstream.processor.PublishProcessor;
import org.apache.rocketmq.mqtt.ds.upstream.processor.SubscribeProcessor;
import org.apache.rocketmq.mqtt.ds.upstream.processor.UnSubscribeProcessor;
import org.springframework.stereotype.Component;

@Component
public class UpstreamProcessorManager
extends AbstractUpstreamHook {
    @Resource
    private UpstreamHookManager upstreamHookManager;
    @Resource
    private ConnectProcessor connectProcessor;
    @Resource
    private PublishProcessor publishProcessor;
    @Resource
    private SubscribeProcessor subscribeProcessor;
    @Resource
    private UnSubscribeProcessor unSubscribeProcessor;
    @Resource
    private DisconnectProcessor disconnectProcessor;

    @PostConstruct
    public void register() {
        this.upstreamHookManager.addHook(UpstreamHookEnum.UPSTREAM_PROCESS.ordinal(), (UpstreamHook)this);
    }

    public CompletableFuture<HookResult> processMqttMessage(MqttMessageUpContext context, MqttMessage message) {
        switch (message.fixedHeader().messageType()) {
            case CONNECT: {
                return this.connectProcessor.process(context, message);
            }
            case PUBLISH: {
                return this.publishProcessor.process(context, message);
            }
            case SUBSCRIBE: {
                return this.subscribeProcessor.process(context, message);
            }
            case UNSUBSCRIBE: {
                return this.unSubscribeProcessor.process(context, message);
            }
            case DISCONNECT: {
                return this.disconnectProcessor.process(context, message);
            }
        }
        CompletableFuture<HookResult> hookResult = new CompletableFuture<HookResult>();
        hookResult.complete(new HookResult(-200, "InvalidMqttMsgType", null));
        return hookResult;
    }
}

