/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.store.file;

import io.openmessaging.storage.dledger.store.file.MmapFile;
import io.openmessaging.storage.dledger.store.file.ReferenceResource;
import io.openmessaging.storage.dledger.store.file.SelectMmapBufferResult;
import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMmapFile
extends ReferenceResource
implements MmapFile {
    public static final int OS_PAGE_SIZE = 4096;
    protected static Logger logger = LoggerFactory.getLogger(DefaultMmapFile.class);
    private static final AtomicLong TOTAL_MAPPED_VIRTUAL_MEMORY = new AtomicLong(0L);
    private static final AtomicInteger TOTAL_MAPPED_FILES = new AtomicInteger(0);
    final AtomicInteger startPosition = new AtomicInteger(0);
    final AtomicInteger wrotePosition = new AtomicInteger(0);
    final AtomicInteger committedPosition = new AtomicInteger(0);
    final AtomicInteger flushedPosition = new AtomicInteger(0);
    protected File file;
    int fileSize;
    long fileFromOffset;
    private FileChannel fileChannel;
    private String fileName;
    private MappedByteBuffer mappedByteBuffer;
    private volatile long storeTimestamp = 0L;
    private boolean firstCreateInQueue = false;

    public DefaultMmapFile(String fileName, int fileSize) throws IOException {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.file = new File(fileName);
        this.fileFromOffset = Long.parseLong(this.file.getName());
        boolean ok = false;
        DefaultMmapFile.ensureDirOK(this.file.getParent());
        try {
            this.fileChannel = new RandomAccessFile(this.file, "rw").getChannel();
            this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
            TOTAL_MAPPED_VIRTUAL_MEMORY.addAndGet(fileSize);
            TOTAL_MAPPED_FILES.incrementAndGet();
            ok = true;
        }
        catch (FileNotFoundException e) {
            logger.error("create file channel " + this.fileName + " Failed. ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error("map file " + this.fileName + " Failed. ", (Throwable)e);
            throw e;
        }
        finally {
            if (!ok && this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
    }

    public static int getTotalMappedFiles() {
        return TOTAL_MAPPED_FILES.get();
    }

    public static long getTotalMappedVirtualMemory() {
        return TOTAL_MAPPED_VIRTUAL_MEMORY.get();
    }

    public static void ensureDirOK(String dirName) {
        File f;
        if (dirName != null && !(f = new File(dirName)).exists()) {
            boolean result = f.mkdirs();
            logger.info(dirName + " mkdir " + (result ? "OK" : "Failed"));
        }
    }

    public static void clean(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect() || buffer.capacity() == 0) {
            return;
        }
        DefaultMmapFile.invoke(DefaultMmapFile.invoke(DefaultMmapFile.viewed(buffer), "cleaner", new Class[0]), "clean", new Class[0]);
    }

    private static Object invoke(final Object target, final String methodName, final Class<?> ... args) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = DefaultMmapFile.method(target, methodName, args);
                    method.setAccessible(true);
                    return method.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private static Method method(Object target, String methodName, Class<?>[] args) throws NoSuchMethodException {
        try {
            return target.getClass().getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            return target.getClass().getDeclaredMethod(methodName, args);
        }
    }

    private static ByteBuffer viewed(ByteBuffer buffer) {
        ByteBuffer viewedBuffer;
        String methodName = "viewedBuffer";
        Method[] methods = buffer.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("attachment")) continue;
            methodName = "attachment";
            break;
        }
        if ((viewedBuffer = (ByteBuffer)DefaultMmapFile.invoke(buffer, methodName, new Class[0])) == null) {
            return buffer;
        }
        return DefaultMmapFile.viewed(viewedBuffer);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.file.lastModified();
    }

    @Override
    public int getFileSize() {
        return this.fileSize;
    }

    @Override
    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    @Override
    public long getFileFromOffset() {
        return this.fileFromOffset;
    }

    @Override
    public boolean appendMessage(byte[] data) {
        return this.appendMessage(data, 0, data.length);
    }

    @Override
    public boolean appendMessage(byte[] data, int offset, int length) {
        int currentPos = this.wrotePosition.get();
        if (currentPos + length <= this.fileSize) {
            ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
            byteBuffer.position(currentPos);
            byteBuffer.put(data, offset, length);
            this.wrotePosition.addAndGet(length);
            return true;
        }
        return false;
    }

    @Override
    public int flush(int flushLeastPages) {
        if (this.isAbleToFlush(flushLeastPages)) {
            if (this.hold()) {
                int value = this.getReadPosition();
                try {
                    this.mappedByteBuffer.force();
                }
                catch (Throwable e) {
                    logger.error("Error occurred when force data to disk.", e);
                }
                this.flushedPosition.set(value);
                this.release();
            } else {
                logger.warn("in flush, hold failed, flush offset = " + this.flushedPosition.get());
                this.flushedPosition.set(this.getReadPosition());
            }
        }
        return this.getFlushedPosition();
    }

    @Override
    public int commit(int commitLeastPages) {
        this.committedPosition.set(this.wrotePosition.get());
        return this.committedPosition.get();
    }

    private boolean isAbleToFlush(int flushLeastPages) {
        int flushedPos = this.flushedPosition.get();
        int writePos = this.getReadPosition();
        if (this.isFull()) {
            return writePos > flushedPos;
        }
        if (flushLeastPages > 0) {
            return writePos / 4096 - flushedPos / 4096 >= flushLeastPages;
        }
        return writePos > flushedPos;
    }

    @Override
    public int getFlushedPosition() {
        return this.flushedPosition.get();
    }

    @Override
    public void setFlushedPosition(int pos) {
        this.flushedPosition.set(pos);
    }

    @Override
    public int getStartPosition() {
        return this.startPosition.get();
    }

    @Override
    public void setStartPosition(int startPosition) {
        this.startPosition.set(startPosition);
    }

    @Override
    public boolean isFull() {
        return this.fileSize == this.wrotePosition.get();
    }

    @Override
    public SelectMmapBufferResult selectMappedBuffer(int pos, int size) {
        int readPosition = this.getReadPosition();
        if (pos + size <= readPosition) {
            if (this.hold()) {
                ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
                byteBuffer.position(pos);
                ByteBuffer byteBufferNew = byteBuffer.slice();
                byteBufferNew.limit(size);
                return new SelectMmapBufferResult(this.fileFromOffset + (long)pos, byteBufferNew, size, this);
            }
            logger.warn("matched, but hold failed, request pos={} fileFromOffset={}", (Object)pos, (Object)this.fileFromOffset);
        } else {
            logger.warn("selectMappedBuffer request pos invalid, request pos={} size={} fileFromOffset={} readPos={}", new Object[]{pos, size, this.fileFromOffset, readPosition});
        }
        return null;
    }

    @Override
    public SelectMmapBufferResult selectMappedBuffer(int pos) {
        int readPosition = this.getReadPosition();
        if (pos < readPosition && pos >= 0 && this.hold()) {
            ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
            byteBuffer.position(pos);
            int size = readPosition - pos;
            ByteBuffer byteBufferNew = byteBuffer.slice();
            byteBufferNew.limit(size);
            return new SelectMmapBufferResult(this.fileFromOffset + (long)pos, byteBufferNew, size, this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getData(int pos, int size, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < size) {
            return false;
        }
        int readPosition = this.getReadPosition();
        if (pos + size <= readPosition) {
            if (this.hold()) {
                try {
                    int readNum = this.fileChannel.read(byteBuffer, pos);
                    boolean bl = size == readNum;
                    return bl;
                }
                catch (Throwable t) {
                    logger.warn("Get data failed pos:{} size:{} fileFromOffset:{}", new Object[]{pos, size, this.fileFromOffset});
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.release();
                }
            }
            logger.debug("matched, but hold failed, request pos: " + pos + ", fileFromOffset: " + this.fileFromOffset);
        } else {
            logger.warn("selectMappedBuffer request pos invalid, request pos: " + pos + ", size: " + size + ", fileFromOffset: " + this.fileFromOffset);
        }
        return false;
    }

    @Override
    public boolean cleanup(long currentRef) {
        if (this.isAvailable()) {
            logger.error("this file[REF:" + currentRef + "] " + this.fileName + " have not shutdown, stop unmapping.");
            return false;
        }
        if (this.isCleanupOver()) {
            logger.error("this file[REF:" + currentRef + "] " + this.fileName + " have cleanup, do not do it again.");
            return true;
        }
        DefaultMmapFile.clean(this.mappedByteBuffer);
        TOTAL_MAPPED_VIRTUAL_MEMORY.addAndGet(this.fileSize * -1);
        TOTAL_MAPPED_FILES.decrementAndGet();
        logger.info("unmap file[REF:" + currentRef + "] " + this.fileName + " OK");
        return true;
    }

    @Override
    public boolean destroy(long intervalForcibly) {
        this.shutdown(intervalForcibly);
        if (this.isCleanupOver()) {
            try {
                this.fileChannel.close();
                logger.info("close file channel " + this.fileName + " OK");
                long beginTime = System.currentTimeMillis();
                boolean result = this.file.delete();
                logger.info("delete file[REF:" + this.getRefCount() + "] " + this.fileName + (result ? " OK, " : " Failed, ") + "W:" + this.getWrotePosition() + " M:" + this.getFlushedPosition() + ", " + DLedgerUtils.computeEclipseTimeMilliseconds(beginTime));
                Thread.sleep(10L);
            }
            catch (Exception e) {
                logger.warn("close file channel " + this.fileName + " Failed. ", (Throwable)e);
            }
            return true;
        }
        logger.warn("destroy mapped file[REF:" + this.getRefCount() + "] " + this.fileName + " Failed. cleanupOver: " + this.cleanupOver);
        return false;
    }

    @Override
    public int getWrotePosition() {
        return this.wrotePosition.get();
    }

    @Override
    public void setWrotePosition(int pos) {
        this.wrotePosition.set(pos);
    }

    @Override
    public int getReadPosition() {
        return this.wrotePosition.get();
    }

    @Override
    public void setCommittedPosition(int pos) {
        this.committedPosition.set(pos);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    @Override
    public ByteBuffer sliceByteBuffer() {
        return this.mappedByteBuffer.slice();
    }

    @Override
    public boolean isFirstCreateInQueue() {
        return this.firstCreateInQueue;
    }

    @Override
    public void setFirstCreateInQueue(boolean firstCreateInQueue) {
        this.firstCreateInQueue = firstCreateInQueue;
    }

    File getFile() {
        return this.file;
    }

    public String toString() {
        return this.fileName;
    }
}

