/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.HasCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.SourceMapResolver;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class JsAst
implements SourceAst {
    private static final long serialVersionUID = 1L;
    private final InputId inputId;
    private SourceFile sourceFile;
    private final String fileName;
    private Node root;
    private FeatureSet features;

    public JsAst(SourceFile sourceFile) {
        this.inputId = new InputId(sourceFile.getName());
        this.sourceFile = sourceFile;
        this.fileName = sourceFile.getName();
    }

    @Override
    public Node getAstRoot(AbstractCompiler compiler) {
        if (!this.isParsed()) {
            this.parse(compiler);
            this.root.setInputId(this.inputId);
        }
        return Preconditions.checkNotNull(this.root);
    }

    @Override
    public void clearAst() {
        this.root = null;
        this.sourceFile.clearCachedSource();
    }

    @Override
    public InputId getInputId() {
        return this.inputId;
    }

    @Override
    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(SourceFile file) {
        Preconditions.checkState(this.fileName.equals(file.getName()));
        this.sourceFile = file;
    }

    public FeatureSet getFeatures(AbstractCompiler compiler) {
        this.getAstRoot(compiler);
        return this.features;
    }

    boolean isParsed() {
        return this.root != null;
    }

    private void parse(AbstractCompiler compiler) {
        Object result;
        RecordingReporterProxy reporter = new RecordingReporterProxy(compiler.getDefaultErrorReporter());
        try {
            boolean parseInline;
            SourceFile sourceMapSourceFile;
            result = ParserRunner.parse(this.sourceFile, this.sourceFile.getCode(), compiler.getParserConfig(this.sourceFile.isExtern() ? AbstractCompiler.ConfigContext.EXTERNS : AbstractCompiler.ConfigContext.DEFAULT), reporter);
            this.root = ((ParserRunner.ParseResult)result).ast;
            this.features = ((ParserRunner.ParseResult)result).features;
            if (compiler.getOptions().preservesDetailedSourceInfo()) {
                compiler.addComments(this.sourceFile.getName(), ((ParserRunner.ParseResult)result).comments);
            }
            if (((ParserRunner.ParseResult)result).sourceMapURL != null && compiler.getOptions().resolveSourceMapAnnotations && (sourceMapSourceFile = SourceMapResolver.extractSourceMap(this.sourceFile, ((ParserRunner.ParseResult)result).sourceMapURL, parseInline = compiler.getOptions().parseInlineSourceMaps)) != null) {
                compiler.addInputSourceMap(this.sourceFile.getName(), new SourceMapInput(sourceMapSourceFile));
            }
        }
        catch (IOException e) {
            compiler.report(JSError.make(AbstractCompiler.READ_ERROR, this.sourceFile.getName(), e.getMessage()));
        }
        if (this.root == null) {
            this.root = IR.script();
        } else {
            compiler.prepareAst(this.root);
        }
        if (!reporter.errors.isEmpty() || !reporter.warnings.isEmpty()) {
            result = new ParseResult(ImmutableList.copyOf(reporter.errors), ImmutableList.copyOf(reporter.warnings));
            this.root.putProp(Node.PARSE_RESULTS, result);
        }
        this.root.setStaticSourceFile(this.sourceFile);
    }

    @GwtIncompatible(value="ObjectinputStream")
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        AbstractCompiler compiler = ((HasCompiler)((Object)in)).getCompiler();
        in.defaultReadObject();
        CompilerInput input = compiler.getInput(this.inputId);
        if (input != null) {
            this.sourceFile.restoreFrom(input.getSourceFile());
        }
    }

    private static class RecordingReporterProxy
    implements ErrorReporter {
        final ArrayList<RhinoError> errors = new ArrayList();
        final ArrayList<RhinoError> warnings = new ArrayList();
        private final ErrorReporter delegateReporter;

        RecordingReporterProxy(ErrorReporter delegateReporter) {
            this.delegateReporter = delegateReporter;
        }

        @Override
        public void warning(String message, String sourceName, int line, int lineOffset) {
            this.warnings.add(new RhinoError(message, sourceName, line, lineOffset));
            this.delegateReporter.warning(message, sourceName, line, lineOffset);
        }

        @Override
        public void error(String message, String sourceName, int line, int lineOffset) {
            this.errors.add(new RhinoError(message, sourceName, line, lineOffset));
            this.delegateReporter.error(message, sourceName, line, lineOffset);
        }
    }

    public static class ParseResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ImmutableList<RhinoError> errors;
        public final ImmutableList<RhinoError> warnings;

        ParseResult(ImmutableList<RhinoError> errors, ImmutableList<RhinoError> warnings) {
            this.errors = errors;
            this.warnings = warnings;
        }
    }

    public static class RhinoError
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String message;
        public final String sourceName;
        public final int line;
        public final int lineOffset;

        public RhinoError(String message, String sourceName, int line, int lineOffset) {
            this.message = message;
            this.sourceName = sourceName;
            this.line = line;
            this.lineOffset = lineOffset;
        }
    }
}

